/*
 * Decompiled with CFR 0.152.
 */
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sun.misc.Signal;

public class CordaWebserverCaplet
extends Capsule {
    private Config nodeConfig = null;
    private String baseDir = null;

    protected CordaWebserverCaplet(Capsule pred) {
        super(pred);
    }

    private Config parseConfigFile(List<String> args) {
        this.baseDir = this.getBaseDirectory(args);
        String config = this.getOption(args, "--config-file");
        File configFile = config == null ? new File(this.baseDir, "node.conf") : new File(config);
        try {
            ConfigParseOptions parseOptions = ConfigParseOptions.defaults().setAllowMissing(false);
            Config defaultConfig = ConfigFactory.parseResources("reference.conf", parseOptions);
            Config baseDirectoryConfig = ConfigFactory.parseMap(Collections.singletonMap("baseDirectory", this.baseDir));
            Config nodeConfig = ConfigFactory.parseFile(configFile, parseOptions);
            return baseDirectoryConfig.withFallback(nodeConfig).withFallback(defaultConfig).resolve();
        }
        catch (ConfigException e) {
            CordaWebserverCaplet.log(3, e);
            return ConfigFactory.empty();
        }
    }

    File getConfigFile(List<String> args, String baseDir) {
        String config = this.getOptionMultiple(args, Arrays.asList("--config-file", "-f"));
        return config == null || config.equals("") ? new File(baseDir, "node.conf") : new File(config);
    }

    String getBaseDirectory(List<String> args) {
        String baseDir = this.getOptionMultiple(args, Arrays.asList("--base-directory", "-b"));
        return Paths.get(baseDir == null ? "." : baseDir, new String[0]).toAbsolutePath().normalize().toString();
    }

    private String getOptionMultiple(List<String> args, List<String> possibleOptions) {
        String option;
        String result = null;
        Iterator<String> iterator = possibleOptions.iterator();
        while (iterator.hasNext() && (result = this.getOption(args, option = iterator.next())) == null) {
        }
        return result;
    }

    private String getOption(List<String> args, String option) {
        String lowerCaseOption = option.toLowerCase();
        int index = 0;
        for (String arg : args) {
            if (arg.toLowerCase().equals(lowerCaseOption)) {
                if (index < args.size() - 1 && !args.get(index + 1).startsWith("-")) {
                    return args.get(index + 1);
                }
                return null;
            }
            if (arg.toLowerCase().startsWith(lowerCaseOption)) {
                if (arg.length() > option.length() && arg.substring(option.length(), option.length() + 1).equals("=")) {
                    return arg.substring(option.length() + 1);
                }
                return null;
            }
            ++index;
        }
        return null;
    }

    @Override
    protected ProcessBuilder prelaunch(List<String> jvmArgs, List<String> args) {
        CordaWebserverCaplet.checkJavaVersion();
        this.nodeConfig = this.parseConfigFile(args);
        return super.prelaunch(jvmArgs, args);
    }

    @Override
    protected String getVarValue(String var) {
        if (var.equals("baseDirectory")) {
            return this.baseDir;
        }
        return super.getVarValue(var);
    }

    @Override
    protected <T> T attribute(Map.Entry<String, T> attr) {
        if (ATTR_APP_CLASS_PATH == attr) {
            T cp = super.attribute(attr);
            File cordappsDir = new File(this.baseDir, "cordapps");
            if (!this.checkIfCordappDirExists(cordappsDir).booleanValue()) {
                return cp;
            }
            this.augmentClasspath((List)cp, cordappsDir);
            try {
                List<String> jarDirs = this.nodeConfig.getStringList("jarDirs");
                CordaWebserverCaplet.log(2, "Configured JAR directories = " + jarDirs);
                for (String jarDir : jarDirs) {
                    this.augmentClasspath((List)cp, new File(jarDir));
                }
            }
            catch (ConfigException.Missing jarDirs) {
            }
            catch (ConfigException e) {
                CordaWebserverCaplet.log(1, e);
            }
            return cp;
        }
        if (ATTR_JVM_ARGS == attr) {
            ArrayList<String> jvmArgs = new ArrayList<String>((List)super.attribute(attr));
            try {
                List<String> configJvmArgs = this.nodeConfig.getStringList("custom.jvmArgs");
                jvmArgs.clear();
                jvmArgs.addAll(configJvmArgs);
                CordaWebserverCaplet.log(2, "Configured JVM args = " + jvmArgs);
            }
            catch (ConfigException.Missing configJvmArgs) {
            }
            catch (ConfigException e) {
                CordaWebserverCaplet.log(1, e);
            }
            return (T)jvmArgs;
        }
        if (ATTR_SYSTEM_PROPERTIES == attr) {
            LinkedHashMap<String, String> systemProps = new LinkedHashMap<String, String>((Map)super.attribute(attr));
            try {
                Config overrideSystemProps = this.nodeConfig.getConfig("systemProperties");
                CordaWebserverCaplet.log(2, "Configured system properties = " + overrideSystemProps);
                for (Map.Entry<String, ConfigValue> entry : overrideSystemProps.entrySet()) {
                    systemProps.put(entry.getKey(), entry.getValue().unwrapped().toString());
                }
            }
            catch (ConfigException.Missing overrideSystemProps) {
            }
            catch (ConfigException e) {
                CordaWebserverCaplet.log(1, e);
            }
            return (T)systemProps;
        }
        return super.attribute(attr);
    }

    private void augmentClasspath(List<Path> classpath, File dir) {
        try {
            if (dir.exists()) {
                for (File file : dir.listFiles()) {
                    this.addToClasspath(classpath, file);
                }
            } else {
                CordaWebserverCaplet.log(2, "Directory to add in Classpath was not found " + dir.getAbsolutePath());
            }
        }
        catch (NullPointerException | SecurityException e) {
            CordaWebserverCaplet.log(1, e);
        }
    }

    private static void checkJavaVersion() {
        String version = System.getProperty("java.version");
        if (version == null || !version.startsWith("1.8")) {
            System.err.printf("Error: Unsupported Java version %s; currently only version 1.8 is supported.\n", version);
            System.exit(1);
        }
    }

    private Boolean checkIfCordappDirExists(File dir) {
        try {
            if (!dir.mkdir() && !dir.exists()) {
                this.logOnFailedCordappDir();
                return false;
            }
        }
        catch (NullPointerException | SecurityException e) {
            this.logOnFailedCordappDir();
            return false;
        }
        return true;
    }

    private void logOnFailedCordappDir() {
        CordaWebserverCaplet.log(2, "Cordapps dir could not be created");
    }

    private void addToClasspath(List<Path> classpath, File file) {
        try {
            if (file.canRead()) {
                if (file.isFile() && this.isJAR(file).booleanValue()) {
                    classpath.add(file.toPath().toAbsolutePath());
                } else if (file.isDirectory()) {
                    this.augmentClasspath(classpath, file);
                }
            } else {
                CordaWebserverCaplet.log(2, "File or directory to add in Classpath could not be read " + file.getAbsolutePath());
            }
        }
        catch (NullPointerException | SecurityException e) {
            CordaWebserverCaplet.log(1, e);
        }
    }

    @Override
    protected void liftoff() {
        super.liftoff();
        Signal.handle(new Signal("INT"), signal -> {});
    }

    private Boolean isJAR(File file) {
        return file.getName().toLowerCase().endsWith(".jar");
    }
}

