/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.implementation.MethodAccessorFactory;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.auxiliary.TrivialType;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;

public interface MethodRebaseResolver {
    public Resolution resolve(MethodDescription.InDefinedShape var1);

    public List<DynamicType> getAuxiliaryTypes();

    public Map<MethodDescription.SignatureToken, Resolution> asTokenMap();

    public static class Default
    implements MethodRebaseResolver {
        private final Map<MethodDescription.InDefinedShape, Resolution> resolutions;
        private final List<DynamicType> dynamicTypes;

        protected Default(Map<MethodDescription.InDefinedShape, Resolution> resolutions, List<DynamicType> dynamicTypes) {
            this.resolutions = resolutions;
            this.dynamicTypes = dynamicTypes;
        }

        public static MethodRebaseResolver make(TypeDescription instrumentedType, Set<? extends MethodDescription.Token> rebaseableMethodTokens, ClassFileVersion classFileVersion, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, MethodNameTransformer methodNameTransformer) {
            DynamicType placeholderType = null;
            HashMap<MethodDescription.InDefinedShape, Resolution> resolutions = new HashMap<MethodDescription.InDefinedShape, Resolution>();
            for (MethodDescription.InDefinedShape instrumentedMethod : instrumentedType.getDeclaredMethods()) {
                Resolution resolution;
                if (!rebaseableMethodTokens.contains(instrumentedMethod.asToken(ElementMatchers.is(instrumentedType)))) continue;
                if (instrumentedMethod.isConstructor()) {
                    if (placeholderType == null) {
                        placeholderType = TrivialType.SIGNATURE_RELEVANT.make(auxiliaryTypeNamingStrategy.name(instrumentedType), classFileVersion, MethodAccessorFactory.Illegal.INSTANCE);
                    }
                    resolution = Resolution.ForRebasedConstructor.of(instrumentedMethod, placeholderType.getTypeDescription());
                } else {
                    resolution = Resolution.ForRebasedMethod.of(instrumentedMethod, methodNameTransformer);
                }
                resolutions.put(instrumentedMethod, resolution);
            }
            return placeholderType == null ? new Default(resolutions, Collections.<DynamicType>emptyList()) : new Default(resolutions, Collections.singletonList(placeholderType));
        }

        @Override
        public Resolution resolve(MethodDescription.InDefinedShape methodDescription) {
            Resolution resolution = this.resolutions.get(methodDescription);
            return resolution == null ? new Resolution.Preserved(methodDescription) : resolution;
        }

        @Override
        public List<DynamicType> getAuxiliaryTypes() {
            return this.dynamicTypes;
        }

        @Override
        public Map<MethodDescription.SignatureToken, Resolution> asTokenMap() {
            HashMap<MethodDescription.SignatureToken, Resolution> tokenMap = new HashMap<MethodDescription.SignatureToken, Resolution>();
            for (Map.Entry<MethodDescription.InDefinedShape, Resolution> entry : this.resolutions.entrySet()) {
                tokenMap.put(entry.getKey().asSignatureToken(), entry.getValue());
            }
            return tokenMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Default)) {
                return false;
            }
            Default other = (Default)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<MethodDescription.InDefinedShape, Resolution> this$resolutions = this.resolutions;
            Map<MethodDescription.InDefinedShape, Resolution> other$resolutions = other.resolutions;
            if (this$resolutions == null ? other$resolutions != null : !((Object)this$resolutions).equals(other$resolutions)) {
                return false;
            }
            List<DynamicType> this$dynamicTypes = this.dynamicTypes;
            List<DynamicType> other$dynamicTypes = other.dynamicTypes;
            return !(this$dynamicTypes == null ? other$dynamicTypes != null : !((Object)this$dynamicTypes).equals(other$dynamicTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Default;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<MethodDescription.InDefinedShape, Resolution> $resolutions = this.resolutions;
            result = result * 59 + ($resolutions == null ? 43 : ((Object)$resolutions).hashCode());
            List<DynamicType> $dynamicTypes = this.dynamicTypes;
            result = result * 59 + ($dynamicTypes == null ? 43 : ((Object)$dynamicTypes).hashCode());
            return result;
        }
    }

    public static interface Resolution {
        public boolean isRebased();

        public MethodDescription.InDefinedShape getResolvedMethod();

        public StackManipulation getAdditionalArguments();

        public static class ForRebasedConstructor
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            protected ForRebasedConstructor(MethodDescription.InDefinedShape methodDescription) {
                this.methodDescription = methodDescription;
            }

            public static Resolution of(MethodDescription.InDefinedShape methodDescription, TypeDescription placeholderType) {
                return new ForRebasedConstructor(new RebasedConstructor(methodDescription, placeholderType));
            }

            @Override
            public boolean isRebased() {
                return true;
            }

            @Override
            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                return NullConstant.INSTANCE;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForRebasedConstructor)) {
                    return false;
                }
                ForRebasedConstructor other = (ForRebasedConstructor)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.InDefinedShape this$methodDescription = this.methodDescription;
                MethodDescription.InDefinedShape other$methodDescription = other.methodDescription;
                return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForRebasedConstructor;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.InDefinedShape $methodDescription = this.methodDescription;
                result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                return result;
            }

            protected static class RebasedConstructor
            extends MethodDescription.InDefinedShape.AbstractBase {
                private final MethodDescription.InDefinedShape methodDescription;
                private final TypeDescription placeholderType;

                protected RebasedConstructor(MethodDescription.InDefinedShape methodDescription, TypeDescription placeholderType) {
                    this.methodDescription = methodDescription;
                    this.placeholderType = placeholderType;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return TypeDescription.Generic.VOID;
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)this, CompoundList.of(this.methodDescription.getParameters().asTypeList().asErasures(), this.placeholderType));
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return this.methodDescription.getExceptionTypes().asRawTypes();
                }

                @Override
                public AnnotationValue<?, ?> getDefaultValue() {
                    return AnnotationValue.UNDEFINED;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.methodDescription.getDeclaringType();
                }

                @Override
                public int getModifiers() {
                    return 4098;
                }

                @Override
                public String getInternalName() {
                    return "<init>";
                }
            }
        }

        public static class ForRebasedMethod
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            protected ForRebasedMethod(MethodDescription.InDefinedShape methodDescription) {
                this.methodDescription = methodDescription;
            }

            public static Resolution of(MethodDescription.InDefinedShape methodDescription, MethodNameTransformer methodNameTransformer) {
                return new ForRebasedMethod(new RebasedMethod(methodDescription, methodNameTransformer));
            }

            @Override
            public boolean isRebased() {
                return true;
            }

            @Override
            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                return StackManipulation.Trivial.INSTANCE;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForRebasedMethod)) {
                    return false;
                }
                ForRebasedMethod other = (ForRebasedMethod)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.InDefinedShape this$methodDescription = this.methodDescription;
                MethodDescription.InDefinedShape other$methodDescription = other.methodDescription;
                return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForRebasedMethod;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.InDefinedShape $methodDescription = this.methodDescription;
                result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                return result;
            }

            protected static class RebasedMethod
            extends MethodDescription.InDefinedShape.AbstractBase {
                private final MethodDescription.InDefinedShape methodDescription;
                private final MethodNameTransformer methodNameTransformer;

                protected RebasedMethod(MethodDescription.InDefinedShape methodDescription, MethodNameTransformer methodNameTransformer) {
                    this.methodDescription = methodDescription;
                    this.methodNameTransformer = methodNameTransformer;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return this.methodDescription.getReturnType().asRawType();
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)this, this.methodDescription.getParameters().asTypeList().asRawTypes());
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return this.methodDescription.getExceptionTypes().asRawTypes();
                }

                @Override
                public AnnotationValue<?, ?> getDefaultValue() {
                    return AnnotationValue.UNDEFINED;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.methodDescription.getDeclaringType();
                }

                @Override
                public int getModifiers() {
                    return 0x1000 | (this.methodDescription.isStatic() ? 8 : 0) | (this.methodDescription.isNative() ? 256 : 0) | (this.methodDescription.getDeclaringType().isInterface() ? 1 : 2);
                }

                @Override
                public String getInternalName() {
                    return this.methodNameTransformer.transform(this.methodDescription);
                }
            }
        }

        public static class Preserved
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            public Preserved(MethodDescription.InDefinedShape methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public boolean isRebased() {
                return false;
            }

            @Override
            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                throw new IllegalStateException("Cannot process additional arguments for non-rebased method: " + this.methodDescription);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Preserved)) {
                    return false;
                }
                Preserved other = (Preserved)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.InDefinedShape this$methodDescription = this.methodDescription;
                MethodDescription.InDefinedShape other$methodDescription = other.methodDescription;
                return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Preserved;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.InDefinedShape $methodDescription = this.methodDescription;
                result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                return result;
            }
        }
    }

    public static enum Disabled implements MethodRebaseResolver
    {
        INSTANCE;


        @Override
        public Resolution resolve(MethodDescription.InDefinedShape methodDescription) {
            return new Resolution.Preserved(methodDescription);
        }

        @Override
        public List<DynamicType> getAuxiliaryTypes() {
            return Collections.emptyList();
        }

        @Override
        public Map<MethodDescription.SignatureToken, Resolution> asTokenMap() {
            return Collections.emptyMap();
        }
    }
}

