/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.field;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.FilterableList;

public interface FieldList<T extends FieldDescription>
extends FilterableList<T, FieldList<T>> {
    public ByteCodeElement.Token.TokenList<FieldDescription.Token> asTokenList();

    public ByteCodeElement.Token.TokenList<FieldDescription.Token> asTokenList(ElementMatcher<? super GenericTypeDescription> var1);

    public FieldList<FieldDescription.InDefinedShape> asDefined();

    public static class Empty
    extends FilterableList.Empty<FieldDescription.InDefinedShape, FieldList<FieldDescription.InDefinedShape>>
    implements FieldList<FieldDescription.InDefinedShape> {
        @Override
        public ByteCodeElement.Token.TokenList<FieldDescription.Token> asTokenList() {
            return new ByteCodeElement.Token.TokenList<FieldDescription.Token>(Collections.emptyList());
        }

        @Override
        public ByteCodeElement.Token.TokenList<FieldDescription.Token> asTokenList(ElementMatcher<? super GenericTypeDescription> targetTypeMatcher) {
            return new ByteCodeElement.Token.TokenList<FieldDescription.Token>(Collections.emptyList());
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> asDefined() {
            return this;
        }
    }

    public static class TypeSubstituting
    extends AbstractBase<FieldDescription> {
        private final GenericTypeDescription declaringType;
        private final List<? extends FieldDescription> fieldDescriptions;
        private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;

        public TypeSubstituting(GenericTypeDescription declaringType, List<? extends FieldDescription> fieldDescriptions, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            this.declaringType = declaringType;
            this.fieldDescriptions = fieldDescriptions;
            this.visitor = visitor;
        }

        @Override
        public FieldDescription get(int index) {
            return new FieldDescription.TypeSubstituting(this.declaringType, this.fieldDescriptions.get(index), this.visitor);
        }

        @Override
        public int size() {
            return this.fieldDescriptions.size();
        }
    }

    public static class ForTokens
    extends AbstractBase<FieldDescription.InDefinedShape> {
        private final TypeDescription declaringType;
        private final List<? extends FieldDescription.Token> tokens;

        public ForTokens(TypeDescription declaringType, List<? extends FieldDescription.Token> tokens) {
            this.declaringType = declaringType;
            this.tokens = tokens;
        }

        @Override
        public FieldDescription.InDefinedShape get(int index) {
            return new FieldDescription.Latent(this.declaringType, this.tokens.get(index));
        }

        @Override
        public int size() {
            return this.tokens.size();
        }
    }

    public static class Explicit<S extends FieldDescription>
    extends AbstractBase<S> {
        private final List<? extends S> fieldDescriptions;

        public Explicit(List<? extends S> fieldDescriptions) {
            this.fieldDescriptions = fieldDescriptions;
        }

        @Override
        public S get(int index) {
            return (S)((FieldDescription)this.fieldDescriptions.get(index));
        }

        @Override
        public int size() {
            return this.fieldDescriptions.size();
        }
    }

    public static class ForLoadedField
    extends AbstractBase<FieldDescription.InDefinedShape> {
        private final List<? extends Field> fields;

        public ForLoadedField(Field ... field) {
            this(Arrays.asList(field));
        }

        public ForLoadedField(List<? extends Field> fields) {
            this.fields = fields;
        }

        @Override
        public FieldDescription.InDefinedShape get(int index) {
            return new FieldDescription.ForLoadedField(this.fields.get(index));
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }

    public static abstract class AbstractBase<S extends FieldDescription>
    extends FilterableList.AbstractBase<S, FieldList<S>>
    implements FieldList<S> {
        @Override
        public ByteCodeElement.Token.TokenList<FieldDescription.Token> asTokenList() {
            return this.asTokenList(ElementMatchers.none());
        }

        @Override
        public ByteCodeElement.Token.TokenList<FieldDescription.Token> asTokenList(ElementMatcher<? super GenericTypeDescription> targetTypeMatcher) {
            ArrayList tokens = new ArrayList(this.size());
            for (FieldDescription fieldDescription : this) {
                tokens.add(fieldDescription.asToken(targetTypeMatcher));
            }
            return new ByteCodeElement.Token.TokenList<FieldDescription.Token>(tokens);
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> asDefined() {
            ArrayList declaredForms = new ArrayList(this.size());
            for (FieldDescription fieldDescription : this) {
                declaredForms.add(fieldDescription.asDefined());
            }
            return new Explicit<FieldDescription.InDefinedShape>(declaredForms);
        }

        @Override
        protected FieldList<S> wrap(List<S> values) {
            return new Explicit<S>(values);
        }
    }
}

