/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.utility.StreamDrainer;

public class ClassReloadingStrategy
implements ClassLoadingStrategy {
    private static final String BYTE_BUDDY_AGENT_TYPE = "net.bytebuddy.agent.ByteBuddyAgent";
    private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
    private static final Object STATIC_METHOD = null;
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final Instrumentation instrumentation;
    private final Engine engine;
    private final BootstrapInjection bootstrapInjection;

    public ClassReloadingStrategy(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        if (instrumentation.isRedefineClassesSupported()) {
            this.engine = Engine.REDEFINITION;
        } else if (instrumentation.isRetransformClassesSupported()) {
            this.engine = Engine.RETRANSFORMATION;
        } else {
            throw new IllegalArgumentException("Instrumentation does not support class redefinition: " + instrumentation);
        }
        this.bootstrapInjection = BootstrapInjection.Disabled.INSTANCE;
    }

    public ClassReloadingStrategy(Instrumentation instrumentation, Engine engine) {
        this.instrumentation = instrumentation;
        this.engine = engine;
        this.bootstrapInjection = BootstrapInjection.Disabled.INSTANCE;
    }

    protected ClassReloadingStrategy(Instrumentation instrumentation, Engine engine, BootstrapInjection bootstrapInjection) {
        this.instrumentation = instrumentation;
        this.engine = engine;
        this.bootstrapInjection = bootstrapInjection;
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        try {
            return new ClassReloadingStrategy((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(BYTE_BUDDY_AGENT_TYPE).getDeclaredMethod(GET_INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_METHOD, new Object[0]));
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
        }
    }

    @Override
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap loadedClasses = new HashMap(types.size());
        HashMap<TypeDescription, byte[]> unloadedClasses = new HashMap<TypeDescription, byte[]>(types.size());
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap(types.size());
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            try {
                Class<?> type = classLoader.loadClass(entry.getKey().getName());
                classDefinitions.put(type, new ClassDefinition(type, entry.getValue()));
                loadedClasses.put(entry.getKey(), type);
            }
            catch (ClassNotFoundException ignored) {
                unloadedClasses.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.engine.apply(this.instrumentation, classDefinitions);
            ClassInjector classInjector = classLoader == null ? this.bootstrapInjection.make(this.instrumentation) : new ClassInjector.UsingReflection(classLoader);
            loadedClasses.putAll(classInjector.inject(unloadedClasses));
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Could not locate classes for redefinition", exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot redefine specified class", exception);
        }
        return loadedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassReloadingStrategy reset(Class<?> ... type) {
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap(type.length);
        try {
            for (Class<?> aType : type) {
                InputStream inputStream = aType.getClassLoader().getResourceAsStream(aType.getName().replace('.', '/') + CLASS_FILE_EXTENSION);
                try {
                    classDefinitions.put(aType, new ClassDefinition(aType, new StreamDrainer().drain(inputStream)));
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException("Exception while resetting types " + Arrays.toString(type), exception);
        }
        try {
            this.engine.apply(this.instrumentation, classDefinitions);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Cannot locate types " + Arrays.toString(type), exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot reset types " + Arrays.toString(type), exception);
        }
        return this;
    }

    public ClassReloadingStrategy enableBootstrapInjection(File folder) {
        return new ClassReloadingStrategy(this.instrumentation, this.engine, new BootstrapInjection.Enabled(folder));
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.engine == ((ClassReloadingStrategy)other).engine && this.instrumentation.equals(((ClassReloadingStrategy)other).instrumentation) && this.bootstrapInjection.equals(((ClassReloadingStrategy)other).bootstrapInjection);
    }

    public int hashCode() {
        return 961 * this.instrumentation.hashCode() + 31 * this.engine.hashCode() + this.bootstrapInjection.hashCode();
    }

    public String toString() {
        return "ClassReloadingStrategy{instrumentation=" + this.instrumentation + ", engine=" + (Object)((Object)this.engine) + ", bootstrapInjection=" + this.bootstrapInjection + '}';
    }

    protected static interface BootstrapInjection {
        public ClassInjector make(Instrumentation var1);

        public static class Enabled
        implements BootstrapInjection {
            private final File folder;

            protected Enabled(File folder) {
                this.folder = folder;
            }

            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                return new ClassInjector.UsingInstrumentation(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, instrumentation);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.folder.equals(((Enabled)other).folder);
            }

            public int hashCode() {
                return this.folder.hashCode();
            }

            public String toString() {
                return "ClassReloadingStrategy.BootstrapInjection.Enabled{folder=" + this.folder + '}';
            }
        }

        public static enum Disabled implements BootstrapInjection
        {
            INSTANCE;


            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                throw new IllegalStateException("Bootstrap injection is not enabled");
            }

            public String toString() {
                return "ClassReloadingStrategy.BootstrapInjection.Disabled." + this.name();
            }
        }
    }

    public static enum Engine {
        REDEFINITION(true){

            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException, ClassNotFoundException {
                instrumentation.redefineClasses(classDefinitions.values().toArray(new ClassDefinition[classDefinitions.size()]));
            }
        }
        ,
        RETRANSFORMATION(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException {
                ClassRedefinitionTransformer classRedefinitionTransformer = new ClassRedefinitionTransformer(classDefinitions);
                Instrumentation instrumentation2 = instrumentation;
                synchronized (instrumentation2) {
                    instrumentation.addTransformer(classRedefinitionTransformer, true);
                    try {
                        instrumentation.retransformClasses(classDefinitions.keySet().toArray(new Class[classDefinitions.size()]));
                    }
                    finally {
                        instrumentation.removeTransformer(classRedefinitionTransformer);
                    }
                }
                classRedefinitionTransformer.assertTransformation();
            }
        };

        private static final boolean REDEFINE_CLASSES = true;
        private final boolean redefinition;

        private Engine(boolean redefinition) {
            this.redefinition = redefinition;
        }

        protected abstract void apply(Instrumentation var1, Map<Class<?>, ClassDefinition> var2) throws UnmodifiableClassException, ClassNotFoundException;

        public boolean isRedefinition() {
            return this.redefinition;
        }

        public String toString() {
            return "ClassReloadingStrategy.Engine." + this.name();
        }

        protected static class ClassRedefinitionTransformer
        implements ClassFileTransformer {
            private final Map<Class<?>, ClassDefinition> redefinedClasses;

            protected ClassRedefinitionTransformer(Map<Class<?>, ClassDefinition> redefinedClasses) {
                this.redefinedClasses = redefinedClasses;
            }

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                ClassDefinition redefinedClass = this.redefinedClasses.remove(classBeingRedefined);
                if (redefinedClass == null) {
                    throw new IllegalArgumentException("Encountered class without redefinition information");
                }
                return redefinedClass.getDefinitionClassFile();
            }

            public void assertTransformation() {
                if (this.redefinedClasses.size() > 0) {
                    throw new IllegalStateException("Could not transform: " + this.redefinedClasses.keySet());
                }
            }

            public String toString() {
                return "ClassReloadingStrategy.Engine.ClassRedefinitionTransformer{redefinedClasses=" + this.redefinedClasses + '}';
            }
        }
    }
}

