/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.PluginArgument;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.nullability.UnknownNull;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformation {
    @UnknownNull
    private final transient Project project;
    private final List<PluginArgument> arguments;
    @MaybeNull
    private Class<? extends Plugin> plugin;
    @MaybeNull
    private String pluginName;

    public Transformation() {
        this.project = null;
        this.arguments = new ArrayList<PluginArgument>();
    }

    @Inject
    public Transformation(Project project) {
        this.project = project;
        this.arguments = new ArrayList<PluginArgument>();
    }

    @Input
    public List<PluginArgument> getArguments() {
        return this.arguments;
    }

    public void argument(Closure<?> closure) {
        this.getArguments().add((PluginArgument)this.project.configure((Object)new PluginArgument(this.getArguments().size()), closure));
    }

    public void argument(Action<PluginArgument> action) {
        PluginArgument argument = new PluginArgument(this.getArguments().size());
        action.execute((Object)argument);
        this.getArguments().add(argument);
    }

    protected List<Plugin.Factory.UsingReflection.ArgumentResolver> makeArgumentResolvers() {
        ArrayList<Plugin.Factory.UsingReflection.ArgumentResolver> argumentResolvers = new ArrayList<Plugin.Factory.UsingReflection.ArgumentResolver>();
        for (PluginArgument argument : this.getArguments()) {
            argumentResolvers.add(argument.toArgumentResolver());
        }
        return argumentResolvers;
    }

    @Input
    @MaybeNull
    @Optional
    public Class<? extends Plugin> getPlugin() {
        return this.plugin;
    }

    public void setPlugin(@MaybeNull Class<? extends Plugin> plugin) {
        this.plugin = plugin;
    }

    @Input
    @MaybeNull
    @Optional
    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(@MaybeNull String pluginName) {
        this.pluginName = pluginName;
    }

    protected Class<? extends Plugin> toPlugin(@MaybeNull ClassLoader classLoader) {
        if (this.plugin != null) {
            if (this.pluginName != null && !this.plugin.getName().equals(this.pluginName)) {
                throw new GradleException("Defined both plugin (" + this.plugin + ") and plugin name (" + this.pluginName + ") but they are not equal");
            }
            if (Plugin.class.isAssignableFrom(this.plugin)) {
                return this.plugin;
            }
            Class<?> type = PluginResolvingClassLoader.wrap(this.getClass().getClassLoader(), this.plugin);
            if (!Plugin.class.isAssignableFrom(type)) {
                throw new GradleException(type.getName() + " does not implement " + Plugin.class.getName());
            }
            return type;
        }
        if (this.pluginName != null) {
            try {
                Class<?> type = Class.forName(this.pluginName, false, classLoader);
                if (!Plugin.class.isAssignableFrom(type)) {
                    throw new GradleException(type.getName() + " does not implement " + Plugin.class.getName());
                }
                return type;
            }
            catch (ClassNotFoundException exception) {
                throw new GradleException("Cannot locate plugin class " + this.pluginName + " by its name", (Throwable)exception);
            }
        }
        throw new GradleException("No plugin or plugin name defined for transformation");
    }

    protected String toPluginName() {
        if (this.plugin != null) {
            if (this.pluginName != null && !this.plugin.getName().equals(this.pluginName)) {
                throw new GradleException("Defined both plugin (" + this.plugin + ") and plugin name (" + this.pluginName + ") but they are not equal");
            }
            return this.plugin.getName();
        }
        if (this.pluginName != null) {
            return this.pluginName;
        }
        throw new GradleException("No plugin or plugin name defined for transformation");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PluginResolvingClassLoader
    extends ClassLoader {
        private final ClassLoader classLoader;
        private final ProtectionDomain protectionDomain;

        protected PluginResolvingClassLoader(ClassLoader parent, ClassLoader classLoader, ProtectionDomain protectionDomain) {
            super(parent);
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
        }

        public static Class<?> wrap(ClassLoader parent, Class<?> type) {
            try {
                return Class.forName(type.getName(), false, new PluginResolvingClassLoader(parent, type.getClassLoader(), type.getProtectionDomain()));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Failed to wrap plugin type " + type.getName(), exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (!name.startsWith("net.bytebuddy.")) {
                byte[] binaryRepresentation;
                InputStream inputStream = this.classLoader.getResourceAsStream(name.replace('.', '/') + ".class");
                if (inputStream == null) {
                    return super.findClass(name);
                }
                try {
                    ByteArrayOutputStream outputStream;
                    try {
                        int length;
                        outputStream = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, length);
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    binaryRepresentation = outputStream.toByteArray();
                }
                catch (IOException exception) {
                    throw new IllegalStateException(exception);
                }
                return this.defineClass(name, binaryRepresentation, 0, binaryRepresentation.length, this.protectionDomain);
            }
            return super.findClass(name);
        }
    }
}

