/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import com.android.build.gradle.BaseExtension;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.ClassVisitorFactory;
import net.bytebuddy.build.AndroidDescriptor;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.android.ByteBuddyInstrumentationParameters;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.slf4j.Logger;

public abstract class ByteBuddyAndroidService
implements BuildService<Parameters>,
Closeable {
    private final ClassVisitorFactory<org.objectweb.asm.ClassVisitor> classVisitorFactory = ClassVisitorFactory.of(org.objectweb.asm.ClassVisitor.class);
    @MaybeNull
    private volatile State state;

    private static URL[] toUrls(Collection<File> files) {
        URL[] url = new URL[files.size()];
        int index = 0;
        for (File file : files) {
            try {
                url[index++] = file.toURI().toURL();
            }
            catch (MalformedURLException exception) {
                throw new IllegalStateException("Failed to convert file " + file.getAbsolutePath(), exception);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ByteBuddyInstrumentationParameters parameters) {
        if (this.state != null) {
            return;
        }
        ByteBuddyAndroidService byteBuddyAndroidService = this;
        synchronized (byteBuddyAndroidService) {
            if (this.state != null) {
                return;
            }
            try {
                BuildLogger buildLogger;
                ClassFileVersion classFileVersion = ClassFileVersion.ofJavaVersionString((String)((JavaVersion)((Parameters)this.getParameters()).getJavaTargetCompatibilityVersion().get()).toString());
                ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
                classFileLocators.add(ClassFileLocator.ForClassLoader.of((ClassLoader)ByteBuddy.class.getClassLoader()));
                for (File artifact : parameters.getRuntimeClasspath().plus((FileCollection)parameters.getAndroidBootClasspath()).plus((FileCollection)parameters.getByteBuddyClasspath()).getFiles()) {
                    classFileLocators.add(artifact.isFile() ? ClassFileLocator.ForJarFile.of((File)artifact, (ClassFileVersion)classFileVersion) : ClassFileLocator.ForFolder.of((File)artifact, (ClassFileVersion)classFileVersion));
                }
                ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);
                TypePool typePool = Plugin.Engine.PoolStrategy.Default.FAST.typePool((ClassFileLocator)classFileLocator);
                URLClassLoader classLoader = new URLClassLoader(ByteBuddyAndroidService.toUrls(parameters.getByteBuddyClasspath().getFiles()), (ClassLoader)new URLClassLoader(ByteBuddyAndroidService.toUrls(parameters.getAndroidBootClasspath().getFiles()), ByteBuddy.class.getClassLoader()));
                ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>();
                org.gradle.api.logging.Logger logger = Logging.getLogger(ByteBuddyAndroidService.class);
                try {
                    buildLogger = (BuildLogger)Class.forName("net.bytebuddy.build.gradle.GradleBuildLogger").getConstructor(org.gradle.api.logging.Logger.class).newInstance(logger);
                }
                catch (Exception exception) {
                    throw new GradleException("Failed to resolve Gradle build logger", (Throwable)exception);
                }
                for (Object name : Plugin.Engine.Default.scan((ClassLoader)classLoader)) {
                    try {
                        Class<?> clazz = Class.forName((String)name, false, classLoader);
                        if (!Plugin.class.isAssignableFrom(clazz)) {
                            throw new GradleException(clazz.getName() + " does not implement " + Plugin.class.getName());
                        }
                        factories.add(new Plugin.Factory.UsingReflection(clazz).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(AndroidDescriptor.class, (Object)AndroidDescriptor.Trivial.EXTERNAL)}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(org.gradle.api.logging.Logger.class, (Object)logger)}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Logger.class, (Object)logger)}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)buildLogger)}));
                    }
                    catch (Throwable throwable) {
                        throw new IllegalStateException("Cannot resolve plugin: " + (String)name, throwable);
                    }
                }
                ArrayList<Plugin> plugins = new ArrayList<Plugin>(factories.size());
                for (Plugin.Factory factory : factories) {
                    Plugin plugin = factory.make();
                    if (plugin instanceof Plugin.WithInitialization) {
                        ((Plugin.WithInitialization)plugin).initialize((ClassFileLocator)classFileLocator);
                    }
                    plugins.add(plugin);
                }
                EntryPoint.Unvalidated entryPoint = new EntryPoint.Unvalidated((EntryPoint)EntryPoint.Default.DECORATE);
                ByteBuddy byteBuddy = entryPoint.byteBuddy(classFileVersion);
                this.state = new State(plugins, (Plugin.Engine.TypeStrategy)new Plugin.Engine.TypeStrategy.ForEntryPoint((EntryPoint)entryPoint, MethodNameTransformer.Suffixing.withRandomSuffix()), byteBuddy, typePool, (ClassFileLocator)classFileLocator, classLoader, (AndroidDescriptor)AndroidDescriptor.Trivial.EXTERNAL);
            }
            catch (IOException exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    public boolean matches(String name) {
        State state = this.state;
        if (state == null) {
            throw new IllegalStateException("Byte Buddy Android service was not initialized");
        }
        TypePool.Resolution resolution = state.getTypePool().describe(name);
        if (!resolution.isResolved()) {
            return false;
        }
        TypeDescription typeDescription = resolution.resolve();
        for (Plugin plugin : state.getPlugins()) {
            if (!(plugin instanceof Plugin.WithPreprocessor)) continue;
            ((Plugin.WithPreprocessor)plugin).onPreprocess(typeDescription, state.getClassFileLocator());
        }
        for (Plugin plugin : state.getPlugins()) {
            if (!plugin.matches((Object)typeDescription)) continue;
            return true;
        }
        return false;
    }

    public org.objectweb.asm.ClassVisitor apply(String name, org.objectweb.asm.ClassVisitor classVisitor) {
        State state = this.state;
        if (state == null) {
            throw new IllegalStateException("Byte Buddy Android service was not initialized");
        }
        TypeDescription typeDescription = state.getTypePool().describe(name).resolve();
        DynamicType.Builder builder = state.getTypeStrategy().builder(state.getByteBuddy(), typeDescription, state.getClassFileLocator());
        for (Plugin plugin : state.getPlugins()) {
            if (!plugin.matches((Object)typeDescription)) continue;
            builder = plugin.apply(builder, typeDescription, state.getClassFileLocator());
        }
        return (org.objectweb.asm.ClassVisitor)this.classVisitorFactory.wrap((ClassVisitor)builder.wrap(this.classVisitorFactory.unwrap((Object)classVisitor)));
    }

    @Override
    public synchronized void close() throws IOException {
        State state = this.state;
        if (state == null) {
            return;
        }
        for (Plugin plugin : state.getPlugins()) {
            plugin.close();
        }
        state.getTypePool().clear();
        state.getClassFileLocator().close();
        if (state.getClassLoader() instanceof Closeable) {
            ((Closeable)((Object)state.getClassLoader())).close();
        }
        if (state.getClassLoader().getParent() instanceof Closeable) {
            ((Closeable)((Object)state.getClassLoader().getParent())).close();
        }
        this.state = null;
    }

    public static interface Parameters
    extends BuildServiceParameters {
        public Property<JavaVersion> getJavaTargetCompatibilityVersion();
    }

    protected static class ConfigurationAction
    implements Action<BuildServiceSpec<Parameters>> {
        private final BaseExtension extension;

        protected ConfigurationAction(BaseExtension extension) {
            this.extension = extension;
        }

        public void execute(BuildServiceSpec<Parameters> spec) {
            ((Parameters)spec.getParameters()).getJavaTargetCompatibilityVersion().set((Object)this.extension.getCompileOptions().getTargetCompatibility());
        }
    }

    protected static class State {
        private final List<Plugin> plugins;
        private final Plugin.Engine.TypeStrategy typeStrategy;
        private final ByteBuddy byteBuddy;
        private final TypePool typePool;
        private final ClassFileLocator classFileLocator;
        private final ClassLoader classLoader;
        private final AndroidDescriptor androidDescriptor;

        protected State(List<Plugin> plugins, Plugin.Engine.TypeStrategy typeStrategy, ByteBuddy byteBuddy, TypePool typePool, ClassFileLocator classFileLocator, ClassLoader classLoader, AndroidDescriptor androidDescriptor) {
            this.plugins = plugins;
            this.typeStrategy = typeStrategy;
            this.byteBuddy = byteBuddy;
            this.typePool = typePool;
            this.classFileLocator = classFileLocator;
            this.classLoader = classLoader;
            this.androidDescriptor = androidDescriptor;
        }

        protected List<Plugin> getPlugins() {
            return this.plugins;
        }

        protected Plugin.Engine.TypeStrategy getTypeStrategy() {
            return this.typeStrategy;
        }

        protected ByteBuddy getByteBuddy() {
            return this.byteBuddy;
        }

        protected TypePool getTypePool() {
            return this.typePool;
        }

        protected ClassFileLocator getClassFileLocator() {
            return this.classFileLocator;
        }

        protected ClassLoader getClassLoader() {
            return this.classLoader;
        }

        protected AndroidDescriptor getAndroidDescriptor() {
            return this.androidDescriptor;
        }
    }
}

