/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JpaMethod;
import net.bull.javamelody.JpaNamingStrategy;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.model.Counter;

public final class JpaWrapper {
    private static final boolean DISABLED = Parameter.DISABLED.getValueAsBoolean();
    private static final Counter JPA_COUNTER = MonitoringProxy.getJpaCounter();

    private JpaWrapper() {
    }

    static Counter getJpaCounter() {
        return JPA_COUNTER;
    }

    public static EntityManagerFactory createEntityManagerFactoryProxy(EntityManagerFactory entityManagerFactory) {
        if (DISABLED || !JPA_COUNTER.isDisplayed()) {
            return entityManagerFactory;
        }
        return JdbcWrapper.createProxy(entityManagerFactory, new EntityManagerFactoryHandler(entityManagerFactory));
    }

    static EntityManager createEntityManagerProxy(EntityManager entityManager) {
        if (DISABLED || !JPA_COUNTER.isDisplayed()) {
            return entityManager;
        }
        return JdbcWrapper.createProxy(entityManager, new EntityManagerHandler(entityManager));
    }

    static Query createQueryProxy(Query query, String requestName) {
        return JdbcWrapper.createProxy(query, new QueryHandler(query, requestName));
    }

    static Object doInvoke(Object object, Method method, Object[] args, String requestName) throws Throwable {
        boolean systemError = false;
        try {
            JPA_COUNTER.bindContextIncludingCpu(requestName);
            Object object2 = method.invoke(object, args);
            return object2;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            JPA_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    private static class EntityManagerFactoryHandler
    implements InvocationHandler {
        private final EntityManagerFactory entityManagerFactory;

        EntityManagerFactoryHandler(EntityManagerFactory entityManagerFactory) {
            this.entityManagerFactory = entityManagerFactory;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = method.invoke((Object)this.entityManagerFactory, args);
            if (result instanceof EntityManager) {
                result = JpaWrapper.createEntityManagerProxy((EntityManager)result);
            }
            return result;
        }
    }

    private static class EntityManagerHandler
    implements InvocationHandler {
        private static final JpaNamingStrategy JPA_NAMING_STRATEGY = new JpaNamingStrategy();
        private final EntityManager entityManager;

        EntityManagerHandler(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            JpaMethod jpaMethod = JpaMethod.forCall(method, args);
            assert (jpaMethod != null);
            assert (method != null);
            if (jpaMethod.isQuery() && jpaMethod.isMonitored()) {
                Query query = (Query)method.invoke((Object)this.entityManager, args);
                String requestName = this.getRequestName(jpaMethod, method, args, query);
                query = JpaWrapper.createQueryProxy(query, requestName);
                return query;
            }
            if (jpaMethod.isMonitored()) {
                String requestName = this.getRequestName(jpaMethod, method, args, null);
                return JpaWrapper.doInvoke(this.entityManager, method, args, requestName);
            }
            return method.invoke((Object)this.entityManager, args);
        }

        private String getRequestName(JpaMethod jpaMethod, Method method, Object[] args, Query query) {
            String requestName = JPA_NAMING_STRATEGY.getRequestName(jpaMethod, method, args, query);
            assert (requestName != null);
            return requestName;
        }
    }

    private static class QueryHandler
    implements InvocationHandler {
        private final Query query;
        private final String requestName;

        QueryHandler(Query query, String requestName) {
            this.query = query;
            this.requestName = requestName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (("getSingleResult".equals(methodName) || "getResultList".equals(methodName) || "executeUpdate".equals(methodName)) && (args == null || args.length == 0)) {
                return JpaWrapper.doInvoke(this.query, method, args, this.requestName);
            }
            if (methodName.startsWith("set") && method.getReturnType() != null && Query.class.isAssignableFrom(method.getReturnType())) {
                method.invoke((Object)this.query, args);
                return proxy;
            }
            return method.invoke((Object)this.query, args);
        }
    }
}

