/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JpaOverridePersistenceXmlClassLoader;
import net.bull.javamelody.JpaWrapper;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;

public class JpaPersistence
implements PersistenceProvider {
    private static final Counter JPA_COUNTER = MonitoringProxy.getJpaCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(JPA_COUNTER.getName());
    private static final String JPA_PERSISTENCE_PROVIDER = "javax.persistence.provider";
    private static final String OWN_PACKAGE = JpaPersistence.class.getName().substring(0, JpaPersistence.class.getName().lastIndexOf(46));
    private static final String DELEGATE_PROVIDER_KEY = OWN_PACKAGE + ".jpa.provider";
    private static final String[] PROVIDERS = new String[]{"org.apache.openjpa.persistence.PersistenceProviderImpl", "org.hibernate.jpa.HibernatePersistenceProvider", "org.hibernate.ejb.HibernatePersistence", "org.eclipse.persistence.jpa.PersistenceProvider", "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider", "oracle.toplink.essentials.PersistenceProvider", "me.prettyprint.hom.CassandraPersistenceProvider", "org.datanucleus.jpa.PersistenceProviderImpl", "com.orientechnologies.orient.core.db.object.jpa.OJPAPersistenceProvider", "com.orientechnologies.orient.object.jpa.OJPAPersistenceProvider", "com.spaceprogram.simplejpa.PersistenceProviderImpl"};
    private static final ProviderUtil DUMMY_PROVIDER_UTIL = new ProviderUtil(){

        public LoadState isLoadedWithoutReference(Object entity, String attributeName) {
            return LoadState.UNKNOWN;
        }

        public LoadState isLoadedWithReference(Object entity, String attributeName) {
            return LoadState.UNKNOWN;
        }

        public LoadState isLoaded(Object entity) {
            return LoadState.UNKNOWN;
        }
    };
    private volatile PersistenceProvider delegate;

    public static void initPersistenceProviderResolver() {
        try {
            PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
            if (!(resolver instanceof JavaMelodyPersistenceProviderResolver)) {
                resolver = new JavaMelodyPersistenceProviderResolver(resolver);
                PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)resolver);
                LOG.debug("JPA persistence provider resolver initialized");
            }
        }
        catch (Throwable t) {
            LOG.info("initialization of jpa persistence provider resolver failed, skipping");
        }
    }

    private void initJpaCounter() {
        JPA_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        JPA_COUNTER.setUsed(true);
        LOG.debug("jpa persistence initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createEntityManagerFactory(String unit, Map map) {
        this.initJpaCounter();
        final PersistenceProvider persistenceProvider = this.findDelegate(map);
        final ClassLoader tccl = JpaPersistence.tccl();
        ClassLoader hack = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new JpaOverridePersistenceXmlClassLoader(tccl, persistenceProvider.getClass().getName());
            }
        });
        Thread.currentThread().setContextClassLoader(hack);
        try {
            HashMap<String, String> overridenMap = new HashMap<String, String>();
            if (map != null) {
                overridenMap.putAll(map);
            }
            overridenMap.put(JPA_PERSISTENCE_PROVIDER, persistenceProvider.getClass().getName());
            EntityManagerFactory entityManagerFactory = persistenceProvider.createEntityManagerFactory(unit, overridenMap);
            if (entityManagerFactory == null) {
                EntityManagerFactory entityManagerFactory2 = null;
                return entityManagerFactory2;
            }
            EntityManagerFactory entityManagerFactory3 = JpaWrapper.createEntityManagerFactoryProxy(entityManagerFactory);
            return entityManagerFactory3;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        this.initJpaCounter();
        PersistenceProvider persistenceProvider = this.findDelegate(map);
        PersistenceUnitInfo proxiedInfo = this.createPersistentUnitInfoProxy(info, persistenceProvider);
        HashMap<String, String> overridenMap = new HashMap<String, String>();
        if (map != null) {
            overridenMap.putAll(map);
        }
        overridenMap.put(JPA_PERSISTENCE_PROVIDER, persistenceProvider.getClass().getName());
        EntityManagerFactory entityManagerFactory = persistenceProvider.createContainerEntityManagerFactory(proxiedInfo, overridenMap);
        if (entityManagerFactory == null) {
            return null;
        }
        return JpaWrapper.createEntityManagerFactoryProxy(entityManagerFactory);
    }

    private PersistenceUnitInfo createPersistentUnitInfoProxy(PersistenceUnitInfo info, PersistenceProvider persistenceProvider) {
        ProviderAwareHandler invocationHandler = new ProviderAwareHandler(persistenceProvider.getClass().getName(), info);
        return JdbcWrapper.createProxy(info, invocationHandler);
    }

    public ProviderUtil getProviderUtil() {
        if (this.delegate == null) {
            return DUMMY_PROVIDER_UTIL;
        }
        return this.delegate.getProviderUtil();
    }

    private PersistenceProvider findDelegate(Map<?, ?> map) {
        if (map == null) {
            return this.loadOrGuessDelegate(null);
        }
        return this.loadOrGuessDelegate((String)String.class.cast(map.get(DELEGATE_PROVIDER_KEY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceProvider loadOrGuessDelegate(String name) {
        if (this.delegate == null) {
            JpaPersistence jpaPersistence = this;
            synchronized (jpaPersistence) {
                if (this.delegate == null) {
                    if (name == null) {
                        this.guessDelegate();
                    } else {
                        try {
                            this.delegate = JpaPersistence.newPersistence(name);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(new ClassNotFoundException("Can't instantiate '" + name + "'", e));
                        }
                    }
                }
            }
        }
        if (name != null && !this.delegate.getClass().getName().equals(name)) {
            try {
                return JpaPersistence.newPersistence(name);
            }
            catch (Exception e) {
                throw new IllegalStateException(new ClassNotFoundException("Can't instantiate '" + name + "'", e));
            }
        }
        return this.delegate;
    }

    private void guessDelegate() {
        List persistenceProviders = PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();
        for (PersistenceProvider persistenceProvider : persistenceProviders) {
            if (this.getClass().isInstance(persistenceProvider)) continue;
            this.delegate = persistenceProvider;
            break;
        }
        if (this.delegate == null) {
            for (String provider : PROVIDERS) {
                try {
                    this.delegate = JpaPersistence.newPersistence(provider);
                    break;
                }
                catch (Throwable th2) {
                }
            }
            if (this.delegate == null) {
                throw new IllegalStateException(new ClassNotFoundException("Can't find a delegate"));
            }
        }
    }

    private static ClassLoader tccl() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static PersistenceProvider newPersistence(String name) throws Exception {
        return (PersistenceProvider)PersistenceProvider.class.cast(JpaPersistence.tccl().loadClass(name).newInstance());
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        PersistenceProvider persistenceProvider = this.findDelegate(map);
        persistenceProvider.generateSchema(info, map);
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        PersistenceProvider persistenceProvider = this.findDelegate(map);
        return persistenceProvider.generateSchema(persistenceUnitName, map);
    }

    private static class JavaMelodyPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private final PersistenceProviderResolver delegate;

        JavaMelodyPersistenceProviderResolver(PersistenceProviderResolver delegate) {
            this.delegate = delegate;
        }

        public List<PersistenceProvider> getPersistenceProviders() {
            List providers = this.delegate.getPersistenceProviders();
            ArrayList<PersistenceProvider> result = new ArrayList<PersistenceProvider>();
            for (PersistenceProvider provider : providers) {
                if (provider instanceof JpaPersistence) {
                    result.add(0, provider);
                    continue;
                }
                result.add(provider);
            }
            return result;
        }

        public void clearCachedProviders() {
            this.delegate.clearCachedProviders();
        }
    }

    private static class ProviderAwareHandler
    implements InvocationHandler {
        private final String provider;
        private final PersistenceUnitInfo info;

        ProviderAwareHandler(String provider, PersistenceUnitInfo info) {
            this.provider = provider;
            this.info = info;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getPersistenceProviderClassName".equals(method.getName())) {
                return this.provider;
            }
            return method.invoke((Object)this.info, args);
        }
    }
}

