/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.Method;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcDriver;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.ThreadInformations;

public class MonitoringInterceptor {
    private static final Counter EJB_COUNTER = new Counter("ejb", "beans.png", JdbcDriver.SINGLETON.getJdbcWrapper().getSqlCounter());
    private static final Counter SPRING_COUNTER = new Counter("spring", "beans.png", JdbcDriver.SINGLETON.getJdbcWrapper().getSqlCounter());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    static Counter getEjbCounter() {
        return EJB_COUNTER;
    }

    static Counter getSpringCounter() {
        return SPRING_COUNTER;
    }

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Object object;
        if (DISABLED || !EJB_COUNTER.isDisplayed()) {
            return context.proceed();
        }
        long start = System.currentTimeMillis();
        long startCpuTime = ThreadInformations.getCurrentThreadCpuTime();
        Method method = context.getMethod();
        String requestName = method.getDeclaringClass().getSimpleName() + '.' + method.getName();
        boolean systemError = false;
        try {
            EJB_COUNTER.bindContext(requestName, requestName, null, startCpuTime);
            object = context.proceed();
            Object var11_9 = null;
        }
        catch (Error e) {
            try {
                systemError = true;
                throw e;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
                EJB_COUNTER.addRequest(requestName, duration, cpuUsedMillis, systemError, -1);
                throw throwable;
            }
        }
        long duration = Math.max(System.currentTimeMillis() - start, 0L);
        long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
        EJB_COUNTER.addRequest(requestName, duration, cpuUsedMillis, systemError, -1);
        return object;
    }
}

