/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Collector;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Mailer;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfReport;
import net.bull.javamelody.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MailReport {
    MailReport() {
    }

    static void scheduleReportMailForLocalServer(final Collector collector, final Timer timer) {
        assert (collector != null);
        assert (timer != null);
        final MailReport mailReport = new MailReport();
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    mailReport.sendReportMailForLocalServer(collector);
                }
                catch (Throwable t) {
                    Collector.printStackTrace(t);
                }
                MailReport.scheduleReportMailForLocalServer(collector, timer);
            }
        };
        timer.schedule(task, MailReport.getNextExecutionDate());
    }

    static Date getNextExecutionDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (calendar.getTimeInMillis() < System.currentTimeMillis()) {
            calendar.add(6, 7);
        }
        return calendar.getTime();
    }

    void sendReportMailForLocalServer(Collector collector) throws Exception {
        JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
        this.sendReportMail(collector, false, Collections.singletonList(javaInformations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReportMail(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList) throws Exception {
        File tmpFile = new File(Parameters.TEMPORARY_DIRECTORY, PdfReport.getFileName(collector.getApplication()));
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tmpFile));
            try {
                PdfReport pdfReport = new PdfReport(collector, collectorServer, javaInformationsList, Period.SEMAINE, output);
                pdfReport.toPdf();
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((OutputStream)output).close();
                throw throwable;
            }
            ((OutputStream)output).close();
            String subject = I18N.getString("Monitoring_sur") + ' ' + collector.getApplication();
            Mailer mailer = new Mailer("java:comp/env/" + Parameters.getParameter(Parameter.MAIL_SESSION));
            String adminEmails = Parameters.getParameter(Parameter.ADMIN_EMAILS);
            mailer.send(adminEmails, subject, "", Collections.singletonList(tmpFile), false);
            Object var10_11 = null;
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            throw throwable;
        }
    }
}

