/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Referenceable;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapperHelper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JdbcWrapper {
    static final AtomicInteger ACTIVE_CONNECTION_COUNT = new AtomicInteger();
    static final AtomicInteger USED_CONNECTION_COUNT = new AtomicInteger();
    static final AtomicInteger ACTIVE_THREAD_COUNT = new AtomicInteger();
    private static final Map<String, Object> TOMCAT_BASIC_DATASOURCE_PROPERTIES = new LinkedHashMap<String, Object>();
    private final Counter sqlCounter;
    private ServletContext servletContext;
    private final Map<String, DataSource> dataSourcesBackup = new LinkedHashMap<String, DataSource>(2);
    private boolean jboss;
    private boolean glassfish;
    private boolean weblogic;

    JdbcWrapper(Counter sqlCounter, ServletContext servletContext) {
        assert (sqlCounter != null);
        this.sqlCounter = sqlCounter;
        this.servletContext = servletContext;
        if (servletContext != null) {
            String serverInfo = servletContext.getServerInfo();
            this.jboss = serverInfo.contains("JBoss");
            this.glassfish = serverInfo.contains("GlassFish");
            this.weblogic = serverInfo.contains("WebLogic");
        }
    }

    void initServletContext(ServletContext context) {
        assert (context != null);
        this.servletContext = context;
        String serverInfo = this.servletContext.getServerInfo();
        this.jboss = serverInfo.contains("JBoss");
        this.glassfish = serverInfo.contains("GlassFish");
        this.weblogic = serverInfo.contains("WebLogic");
    }

    static int getUsedConnectionCount() {
        return USED_CONNECTION_COUNT.get();
    }

    static int getActiveConnectionCount() {
        return ACTIVE_CONNECTION_COUNT.get();
    }

    static int getActiveThreadCount() {
        return ACTIVE_THREAD_COUNT.get();
    }

    static int getMaxConnectionCount() {
        Object maxActive = TOMCAT_BASIC_DATASOURCE_PROPERTIES.get("maxActive");
        if (maxActive == null) {
            return -1;
        }
        return (Integer)maxActive;
    }

    static Map<String, Object> getTomcatBasicDataSourceProperties() {
        return Collections.unmodifiableMap(TOMCAT_BASIC_DATASOURCE_PROPERTIES);
    }

    Counter getSqlCounter() {
        return this.sqlCounter;
    }

    Object doExecute(String requestName, Statement statement, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object object;
        assert (requestName != null);
        assert (statement != null);
        assert (method != null);
        if (!this.sqlCounter.isDisplayed()) {
            return method.invoke((Object)statement, args);
        }
        long start = System.currentTimeMillis();
        boolean systemError = true;
        try {
            ACTIVE_CONNECTION_COUNT.incrementAndGet();
            this.sqlCounter.bindContext(requestName, requestName);
            Object result = method.invoke((Object)statement, args);
            systemError = false;
            object = result;
            Object var11_11 = null;
            ACTIVE_CONNECTION_COUNT.decrementAndGet();
        }
        catch (InvocationTargetException e) {
            try {
                int errorCode;
                if (e.getCause() instanceof SQLException && (errorCode = ((SQLException)e.getCause()).getErrorCode()) >= 20000 && errorCode < 30000) {
                    systemError = false;
                }
                throw e;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                ACTIVE_CONNECTION_COUNT.decrementAndGet();
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                this.sqlCounter.addRequest(requestName, duration, -1L, systemError, -1);
                throw throwable;
            }
        }
        long duration = Math.max(System.currentTimeMillis() - start, 0L);
        this.sqlCounter.addRequest(requestName, duration, -1L, systemError, -1);
        return object;
    }

    boolean rebindDataSources() {
        boolean ok;
        try {
            InitialContext initialContext = new InitialContext();
            for (Map.Entry<String, DataSource> entry : JdbcWrapperHelper.getDataSources().entrySet()) {
                String jndiName = entry.getKey();
                DataSource dataSource = entry.getValue();
                if (this.glassfish || this.jboss || this.weblogic) {
                    this.rewrapDataSource(dataSource);
                    continue;
                }
                if (JdbcWrapper.isProxyAlready(dataSource)) continue;
                DataSource dataSourceProxy = this.createDataSourceProxy(dataSource);
                Object securityToken = JdbcWrapperHelper.changeContextWritable(this.servletContext, null);
                initialContext.rebind(jndiName, (Object)dataSourceProxy);
                this.dataSourcesBackup.put(jndiName, dataSource);
                JdbcWrapperHelper.changeContextWritable(this.servletContext, securityToken);
            }
            ok = true;
        }
        catch (Throwable t) {
            ok = false;
        }
        return ok;
    }

    private void rewrapDataSource(DataSource dataSource) throws IllegalAccessException {
        String dataSourceClassName = dataSource.getClass().getName();
        if (this.jboss && "org.jboss.resource.adapter.jdbc.WrapperDataSource".equals(dataSourceClassName) || this.glassfish && "com.sun.gjc.spi.jdbc40.DataSource40".equals(dataSourceClassName)) {
            Field connectionManagerField = JdbcWrapperHelper.getAccessibleField(dataSource, "cm");
            Object javaxConnectionManager = connectionManagerField.get(dataSource);
            javaxConnectionManager = this.createJavaxConnectionManagerProxy(javaxConnectionManager);
            connectionManagerField.set(dataSource, javaxConnectionManager);
        } else if (this.weblogic && "weblogic.jdbc.common.internal.RmiDataSource".equals(dataSourceClassName)) {
            Field driverInstanceField;
            Object driverInstance;
            Field jdbcCtxField = JdbcWrapperHelper.getAccessibleField(dataSource, "jdbcCtx");
            Object jdbcCtx = jdbcCtxField.get(dataSource);
            if (jdbcCtx != null) {
                jdbcCtx = this.createContextProxy((Context)jdbcCtx);
                jdbcCtxField.set(dataSource, jdbcCtx);
            }
            if ((driverInstance = (driverInstanceField = JdbcWrapperHelper.getAccessibleField(dataSource, "driverInstance")).get(dataSource)) != null) {
                driverInstance = this.createDriverProxy((Driver)driverInstance);
                driverInstanceField.set(dataSource, driverInstance);
            }
        }
    }

    boolean stop() {
        boolean ok;
        try {
            InitialContext initialContext = new InitialContext();
            for (Map.Entry<String, DataSource> entry : this.dataSourcesBackup.entrySet()) {
                String jndiName = entry.getKey();
                DataSource dataSource = entry.getValue();
                Object securityToken = JdbcWrapperHelper.changeContextWritable(this.servletContext, null);
                initialContext.rebind(jndiName, (Object)dataSource);
                JdbcWrapperHelper.changeContextWritable(this.servletContext, securityToken);
            }
            ok = true;
        }
        catch (Throwable t) {
            ok = false;
        }
        this.dataSourcesBackup.clear();
        return ok;
    }

    Context createContextProxy(final Context context) {
        assert (context != null);
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)context, args);
                if (result instanceof DataSource) {
                    result = JdbcWrapper.this.createDataSourceProxy((DataSource)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(context, invocationHandler);
    }

    private Driver createDriverProxy(final Driver driver) {
        assert (driver != null);
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)driver, args);
                if (result instanceof Connection) {
                    result = JdbcWrapper.this.createConnectionProxy((Connection)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(driver, invocationHandler);
    }

    private Object createJavaxConnectionManagerProxy(final Object javaxConnectionManager) {
        assert (javaxConnectionManager != null);
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke(javaxConnectionManager, args);
                if (result instanceof Connection) {
                    JdbcWrapper.this.rewrapConnection((Connection)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(javaxConnectionManager, invocationHandler);
    }

    void rewrapConnection(Connection connection) throws IllegalAccessException {
        Field connectionHolderField;
        Connection con;
        assert (connection != null);
        if (this.jboss && connection.getClass().getSimpleName().startsWith("WrappedConnection")) {
            Field baseWrapperManagedConnectionField = JdbcWrapperHelper.getAccessibleField(connection, "mc");
            Object baseWrapperManagedConnection = baseWrapperManagedConnectionField.get(connection);
            Field connectionField = JdbcWrapperHelper.getAccessibleField(baseWrapperManagedConnection, "con");
            Connection con2 = (Connection)connectionField.get(baseWrapperManagedConnection);
            if (!JdbcWrapper.isProxyAlready(con2)) {
                con2 = this.createConnectionProxy(con2);
                connectionField.set(baseWrapperManagedConnection, con2);
            }
        } else if (this.glassfish && "com.sun.gjc.spi.jdbc40.ConnectionHolder40".equals(connection.getClass().getName()) && !JdbcWrapper.isProxyAlready(con = (Connection)(connectionHolderField = JdbcWrapperHelper.getAccessibleField(connection, "con")).get(connection))) {
            con = this.createConnectionProxy(con);
            connectionHolderField.set(connection, con);
        }
    }

    DataSource createDataSourceProxy(final DataSource dataSource) {
        assert (dataSource != null);
        if ("org.apache.tomcat.dbcp.dbcp.BasicDataSource".equals(dataSource.getClass().getName()) && dataSource instanceof BasicDataSource) {
            this.pullTomcatDataSourceProperties(dataSource);
        }
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)dataSource, args);
                if (result instanceof Connection) {
                    result = JdbcWrapper.this.createConnectionProxy((Connection)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(dataSource, invocationHandler);
    }

    private void pullTomcatDataSourceProperties(DataSource dataSource) {
        BasicDataSource basicDataSource = (BasicDataSource)dataSource;
        JdbcWrapper.putTomcatDataSourceProperty("maxActive", basicDataSource.getMaxActive());
        JdbcWrapper.putTomcatDataSourceProperty("poolPreparedStatements", basicDataSource.isPoolPreparedStatements());
        JdbcWrapper.putTomcatDataSourceProperty("defaultCatalog", basicDataSource.getDefaultCatalog());
        JdbcWrapper.putTomcatDataSourceProperty("defaultAutoCommit", basicDataSource.getDefaultAutoCommit());
        JdbcWrapper.putTomcatDataSourceProperty("defaultReadOnly", basicDataSource.getDefaultReadOnly());
        JdbcWrapper.putTomcatDataSourceProperty("defaultTransactionIsolation", basicDataSource.getDefaultTransactionIsolation());
        JdbcWrapper.putTomcatDataSourceProperty("driverClassName", basicDataSource.getDriverClassName());
        JdbcWrapper.putTomcatDataSourceProperty("initialSize", basicDataSource.getInitialSize());
        JdbcWrapper.putTomcatDataSourceProperty("maxIdle", basicDataSource.getMaxIdle());
        JdbcWrapper.putTomcatDataSourceProperty("maxOpenPreparedStatements", basicDataSource.getMaxOpenPreparedStatements());
        JdbcWrapper.putTomcatDataSourceProperty("maxWait", basicDataSource.getMaxWait());
        JdbcWrapper.putTomcatDataSourceProperty("minEvictableIdleTimeMillis", basicDataSource.getMinEvictableIdleTimeMillis());
        JdbcWrapper.putTomcatDataSourceProperty("minIdle", basicDataSource.getMinIdle());
        JdbcWrapper.putTomcatDataSourceProperty("numTestsPerEvictionRun", basicDataSource.getNumTestsPerEvictionRun());
        JdbcWrapper.putTomcatDataSourceProperty("testOnBorrow", basicDataSource.getTestOnBorrow());
        JdbcWrapper.putTomcatDataSourceProperty("testOnReturn", basicDataSource.getTestOnReturn());
        JdbcWrapper.putTomcatDataSourceProperty("testWhileIdle", basicDataSource.getTestWhileIdle());
        JdbcWrapper.putTomcatDataSourceProperty("timeBetweenEvictionRunsMillis", basicDataSource.getTimeBetweenEvictionRunsMillis());
        JdbcWrapper.putTomcatDataSourceProperty("validationQuery", basicDataSource.getValidationQuery());
    }

    private static void putTomcatDataSourceProperty(String key, Object value) {
        TOMCAT_BASIC_DATASOURCE_PROPERTIES.put(key, value);
    }

    Connection createConnectionProxy(Connection connection) {
        assert (connection != null);
        if (JdbcWrapper.isMonitoringDisabled() || !this.sqlCounter.isDisplayed()) {
            return connection;
        }
        ConnectionInvocationHandler invocationHandler = new ConnectionInvocationHandler(connection);
        return JdbcWrapper.createProxy(connection, invocationHandler);
    }

    private static boolean isMonitoringDisabled() {
        return Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
    }

    Statement createStatementProxy(String query, Statement statement) {
        assert (statement != null);
        StatementInvocationHandler invocationHandler = new StatementInvocationHandler(query, statement);
        return JdbcWrapper.createProxy(statement, invocationHandler);
    }

    static boolean isEqualsMethod(Object methodName, Object[] args) {
        return "equals" == methodName && args != null && args.length == 1;
    }

    static boolean isHashCodeMethod(Object methodName, Object[] args) {
        return "hashCode" == methodName && (args == null || args.length == 0);
    }

    static <T> T createProxy(T object, InvocationHandler invocationHandler) {
        if (JdbcWrapper.isProxyAlready(object)) {
            return object;
        }
        ClassLoader classLoader = object.getClass().getClassLoader();
        ArrayList interfaces = new ArrayList(Arrays.asList(object.getClass().getInterfaces()));
        for (Class<?> classe = object.getClass().getSuperclass(); classe != null; classe = classe.getSuperclass()) {
            List<Class<?>> superInterfaces = Arrays.asList(classe.getInterfaces());
            interfaces.removeAll(superInterfaces);
            interfaces.addAll(superInterfaces);
        }
        interfaces.remove(Referenceable.class);
        Class[] interfacesArray = interfaces.toArray(new Class[interfaces.size()]);
        DelegatingInvocationHandler ih = new DelegatingInvocationHandler(invocationHandler);
        return (T)Proxy.newProxyInstance(classLoader, interfacesArray, (InvocationHandler)ih);
    }

    private static boolean isProxyAlready(Object object) {
        return Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof DelegatingInvocationHandler;
    }

    private static class DelegatingInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 7515240588169084785L;
        private final InvocationHandler delegate;

        DelegatingInvocationHandler(InvocationHandler delegate) {
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.delegate.invoke(proxy, method, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                throw e;
            }
        }
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection connection;

        ConnectionInvocationHandler(Connection connection) {
            assert (connection != null);
            this.connection = connection;
            USED_CONNECTION_COUNT.incrementAndGet();
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (JdbcWrapper.isEqualsMethod(methodName, args)) {
                return this.connection.equals(args[0]);
            }
            if (JdbcWrapper.isHashCodeMethod(methodName, args)) {
                return this.connection.hashCode();
            }
            Object result = method.invoke((Object)this.connection, args);
            if (result instanceof Statement) {
                String requestName = "prepareStatement".equals(methodName) || "prepareCall".equals(methodName) ? (String)args[0] : null;
                result = JdbcWrapper.this.createStatementProxy(requestName, (Statement)result);
            } else if ("close".equals(method.getName())) {
                USED_CONNECTION_COUNT.decrementAndGet();
            }
            return result;
        }
    }

    private class StatementInvocationHandler
    implements InvocationHandler {
        private String requestName;
        private final Statement statement;

        StatementInvocationHandler(String query, Statement statement) {
            assert (statement != null);
            this.requestName = query;
            this.statement = statement;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (JdbcWrapper.isEqualsMethod(methodName, args)) {
                return this.statement.equals(args[0]);
            }
            if (JdbcWrapper.isHashCodeMethod(methodName, args)) {
                return this.statement.hashCode();
            }
            if (methodName.startsWith("execute")) {
                if (this.isFirstArgAString(args)) {
                    this.requestName = (String)args[0];
                }
                this.requestName = String.valueOf(this.requestName);
                return JdbcWrapper.this.doExecute(this.requestName, this.statement, method, args);
            }
            if ("addBatch".equals(methodName) && this.isFirstArgAString(args)) {
                this.requestName = (String)args[0];
            }
            return method.invoke((Object)this.statement, args);
        }

        private boolean isFirstArgAString(Object[] args) {
            return args != null && args.length > 0 && args[0] instanceof String;
        }
    }
}

