/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CounterRequest
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4301825473892026959L;
    private final String name;
    private final String id;
    private long hits;
    private long durationsSum;
    private long durationsSquareSum;
    private long maximum;
    private long cpuTimeSum;
    private long systemErrors;
    private long responseSizesSum;
    private long childHits;
    private long childDurationsSum;
    private String stackTrace;
    private Map<String, Long> childRequestsExecutionsByRequestId;

    CounterRequest(String name, String counterName) {
        assert (name != null);
        assert (counterName != null);
        this.name = name;
        this.id = CounterRequest.buildId(name, counterName);
    }

    String getName() {
        return this.name;
    }

    String getId() {
        return this.id;
    }

    long getHits() {
        return this.hits;
    }

    long getDurationsSum() {
        return this.durationsSum;
    }

    int getMean() {
        if (this.hits > 0L) {
            return (int)(this.durationsSum / this.hits);
        }
        return -1;
    }

    int getStandardDeviation() {
        if (this.hits > 0L) {
            return (int)Math.sqrt(((double)this.durationsSquareSum - (double)this.durationsSum * (double)this.durationsSum / (double)this.hits) / (double)(this.hits - 1L));
        }
        return -1;
    }

    long getMaximum() {
        return this.maximum;
    }

    long getCpuTimeSum() {
        return this.cpuTimeSum;
    }

    int getCpuTimeMean() {
        if (this.hits > 0L) {
            return (int)(this.cpuTimeSum / this.hits);
        }
        return -1;
    }

    float getSystemErrorPercentage() {
        if (this.hits > 0L) {
            return 100.0f * (float)this.systemErrors / (float)this.hits;
        }
        return 0.0f;
    }

    int getResponseSizeMean() {
        if (this.hits > 0L) {
            return (int)(this.responseSizesSum / this.hits);
        }
        return -1;
    }

    int getChildHitsMean() {
        if (this.hits > 0L) {
            return (int)(this.childHits / this.hits);
        }
        return -1;
    }

    int getChildDurationsMean() {
        if (this.hits > 0L) {
            return (int)(this.childDurationsSum / this.hits);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Long> getChildRequestsExecutionsByRequestId() {
        if (this.childRequestsExecutionsByRequestId == null) {
            return Collections.emptyMap();
        }
        CounterRequest counterRequest = this;
        synchronized (counterRequest) {
            return new LinkedHashMap<String, Long>(this.childRequestsExecutionsByRequestId);
        }
    }

    String getStackTrace() {
        return this.stackTrace;
    }

    void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    void addHit(long duration, long cpuTime, boolean systemError, int responseSize) {
        ++this.hits;
        this.durationsSum += duration;
        this.durationsSquareSum += duration * duration;
        if (duration > this.maximum) {
            this.maximum = duration;
        }
        this.cpuTimeSum += cpuTime;
        if (systemError) {
            ++this.systemErrors;
        }
        this.responseSizesSum += (long)responseSize;
    }

    void addChildHits(ICounterRequestContext context) {
        this.childHits += (long)context.getChildHits();
        this.childDurationsSum += (long)context.getChildDurationsSum();
    }

    void addChildRequests(Map<String, Long> childRequests) {
        if (childRequests != null && !childRequests.isEmpty()) {
            if (this.childRequestsExecutionsByRequestId == null) {
                this.childRequestsExecutionsByRequestId = new LinkedHashMap<String, Long>(childRequests);
            } else {
                for (Map.Entry<String, Long> entry : childRequests.entrySet()) {
                    String requestId = entry.getKey();
                    Long nbExecutions = this.childRequestsExecutionsByRequestId.get(requestId);
                    nbExecutions = nbExecutions == null ? entry.getValue() : Long.valueOf(nbExecutions + entry.getValue());
                    this.childRequestsExecutionsByRequestId.put(requestId, nbExecutions);
                }
            }
        }
    }

    void addHits(CounterRequest request) {
        assert (request != null);
        if (request.hits != 0L) {
            this.hits += request.hits;
            this.durationsSum += request.durationsSum;
            this.durationsSquareSum += request.durationsSquareSum;
            if (request.maximum > this.maximum) {
                this.maximum = request.maximum;
            }
            this.cpuTimeSum += request.cpuTimeSum;
            this.systemErrors += request.systemErrors;
            this.responseSizesSum += request.responseSizesSum;
            this.childHits += request.childHits;
            this.childDurationsSum += request.childDurationsSum;
            if (request.stackTrace != null) {
                this.stackTrace = request.stackTrace;
            }
            this.addChildRequests(request.childRequestsExecutionsByRequestId);
        }
    }

    void removeHits(CounterRequest request) {
        assert (request != null);
        if (request.hits != 0L) {
            this.hits -= request.hits;
            this.durationsSum -= request.durationsSum;
            this.durationsSquareSum -= request.durationsSquareSum;
            this.cpuTimeSum -= request.cpuTimeSum;
            this.systemErrors -= request.systemErrors;
            this.responseSizesSum -= request.responseSizesSum;
            this.childHits -= request.childHits;
            this.childDurationsSum -= request.childDurationsSum;
            if (request.childRequestsExecutionsByRequestId != null && this.childRequestsExecutionsByRequestId != null) {
                for (Map.Entry<String, Long> entry : request.childRequestsExecutionsByRequestId.entrySet()) {
                    String requestId = entry.getKey();
                    Long nbExecutions = this.childRequestsExecutionsByRequestId.get(requestId);
                    if (nbExecutions == null) continue;
                    if ((nbExecutions = Long.valueOf(Math.max(nbExecutions - entry.getValue(), 0L))) == 0L) {
                        this.childRequestsExecutionsByRequestId.remove(requestId);
                        if (!this.childRequestsExecutionsByRequestId.isEmpty()) continue;
                        this.childRequestsExecutionsByRequestId = null;
                        break;
                    }
                    this.childRequestsExecutionsByRequestId.put(requestId, nbExecutions);
                }
            }
        }
    }

    public CounterRequest clone() {
        try {
            CounterRequest clone = (CounterRequest)super.clone();
            if (this.childRequestsExecutionsByRequestId != null) {
                clone.childRequestsExecutionsByRequestId = new LinkedHashMap<String, Long>(this.getChildRequestsExecutionsByRequestId());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String buildId(String name, String counterName) {
        MessageDigest messageDigest = CounterRequest.getMessageDigestInstance();
        messageDigest.update(name.getBytes());
        byte[] digest = messageDigest.digest();
        StringBuilder sb = new StringBuilder(digest.length * 2);
        sb.append(counterName);
        for (int n : digest) {
            int j;
            int n2 = j = n < 0 ? 256 + n : n;
            if (j < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(j));
        }
        return sb.toString();
    }

    private static MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", hits=" + this.getHits() + ", id=" + this.getId() + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ICounterRequestContext {
        public int getChildHits();

        public int getChildDurationsSum();

        public Map<String, Long> getChildRequestsExecutionsByRequestId();
    }
}

