/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.bull.javamelody.internal.model.MavenArtifact;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

class HtmlDependenciesReport
extends HtmlAbstractReport {
    private final Map<String, MavenArtifact> dependencies;

    HtmlDependenciesReport(Map<String, MavenArtifact> dependencies, Writer writer) {
        super(writer);
        assert (dependencies != null);
        this.dependencies = dependencies;
    }

    @Override
    void toHtml() throws IOException {
        this.writeBackLink();
        this.writeln("<br/>");
        if (this.dependencies.isEmpty()) {
            this.writeln("#Aucune_dependance#");
            return;
        }
        this.writeTitle("beans.png", HtmlDependenciesReport.getString("Dependencies"));
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
        table.beginTable(HtmlDependenciesReport.getString("Dependencies"));
        this.write("<th>Artifact</th><th>#Nom#</th><th>Maven ID</th><th>#Licence#</th>");
        for (Map.Entry<String, MavenArtifact> entry : this.dependencies.entrySet()) {
            String jarFilename = entry.getKey();
            MavenArtifact dependency = entry.getValue();
            table.nextRow();
            this.writeDependency(jarFilename, dependency);
        }
        table.endTable();
        this.writeln("<div align='right'>" + HtmlDependenciesReport.getFormattedString("nb_dependencies", this.dependencies.size()) + "</div>");
    }

    private void writeBackLink() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'>");
        this.writeln("<img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("</div>");
    }

    private void writeDependency(String jarFilename, MavenArtifact dependency) throws IOException {
        this.write("<td>");
        this.writeDirectly(HtmlDependenciesReport.htmlEncodeButNotSpace(jarFilename));
        this.write("</td><td>");
        if (dependency == null) {
            this.write("</td><td>");
            this.write("</td><td>");
        } else {
            if (dependency.getName() != null) {
                if (dependency.getUrl() == null) {
                    this.writeDirectly(HtmlDependenciesReport.htmlEncodeButNotSpace(dependency.getName()));
                } else {
                    this.writeDirectly("<a href='" + HtmlDependenciesReport.urlEncode(dependency.getUrl()) + "'>" + HtmlDependenciesReport.htmlEncodeButNotSpace(dependency.getName()) + "</a>");
                }
            }
            this.write("</td><td>");
            this.writeDirectly(dependency.getGroupId() + ':' + dependency.getArtifactId() + ':' + "<b>" + dependency.getVersion() + "</b>");
            this.write("</td><td>");
            boolean firstLicense = true;
            for (Map.Entry<String, String> entry : dependency.getLicenseUrlsByName().entrySet()) {
                String licenseName = entry.getKey();
                String licenseUrl = entry.getValue();
                if (!firstLicense) {
                    this.write("<br/>");
                }
                if (licenseUrl == null || !licenseUrl.startsWith("http")) {
                    this.writeDirectly(HtmlDependenciesReport.htmlEncodeButNotSpace(licenseName));
                } else {
                    this.writeDirectly("<a href='" + HtmlDependenciesReport.urlEncode(licenseUrl) + "'>" + HtmlDependenciesReport.htmlEncodeButNotSpace(licenseName) + "</a>");
                }
                firstLicense = false;
            }
        }
        this.write("</td>");
    }
}

