/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.CacheInformations;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.MemoryInformations;
import net.bull.javamelody.internal.model.TomcatInformations;

class PrometheusController {
    private final JavaInformations javaInformations;
    private final Collector collector;
    private final PrintWriter out;
    private final DecimalFormat decimalFormat;

    PrometheusController(List<JavaInformations> javaInformations, Collector collector, PrintWriter out) throws IOException {
        assert (javaInformations != null && !javaInformations.isEmpty());
        assert (collector != null);
        assert (out != null);
        if (javaInformations.size() > 1) {
            throw new IOException("JavaMelody collector server not supported - configure Prometheus to scrape nodes.");
        }
        this.javaInformations = javaInformations.get(0);
        this.collector = collector;
        this.out = out;
        this.decimalFormat = new DecimalFormat();
        this.decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        this.decimalFormat.setGroupingUsed(false);
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.decimalFormat.setMaximumFractionDigits(15);
    }

    void report() throws IOException {
        this.reportOnMemoryInformations(this.javaInformations.getMemoryInformations());
        this.reportOnJavaInformations();
        if (this.javaInformations.getTomcatInformationsList() != null) {
            for (TomcatInformations tcInfo : this.javaInformations.getTomcatInformationsList()) {
                if (tcInfo.getRequestCount() <= 0) continue;
                this.reportOnTomcatInformations(tcInfo);
            }
        }
        if (this.javaInformations.isCacheEnabled()) {
            for (CacheInformations cacheInfo : this.javaInformations.getCacheInformationsList()) {
                this.reportOnCacheInformations(cacheInfo);
            }
        }
        this.reportOnCollector();
        if (Parameter.PROMETHEUS_INCLUDE_LAST_VALUE.getValueAsBoolean()) {
            this.reportOnLastValues();
        }
    }

    private void reportOnCollector() {
        for (Counter counter : this.collector.getCounters()) {
            List<CounterRequest> requests = counter.getRequests();
            long hits = 0L;
            long duration = 0L;
            long errors = 0L;
            for (CounterRequest cr : requests) {
                hits += cr.getHits();
                duration += cr.getDurationsSum();
                errors += cr.getSystemErrors();
            }
            String sanitizedName = PrometheusController.sanitizeName(counter.getName());
            this.printLong(MetricType.COUNTER, "javamelody_" + sanitizedName + "_hits_count", "javamelody counter", hits);
            this.printLong(MetricType.COUNTER, "javamelody_" + sanitizedName + "_errors_count", "javamelody counter", errors);
            this.printLong(MetricType.COUNTER, "javamelody_" + sanitizedName + "_duration_millis", "javamelody counter", duration);
        }
    }

    private void reportOnLastValues() throws IOException {
        Collection<JRobin> jrobins = this.collector.getDisplayedCounterJRobins();
        for (JRobin jrobin : jrobins) {
            this.printDouble(MetricType.GAUGE, "javamelody_last_value_" + PrometheusController.camelToSnake(jrobin.getName()), "javamelody value per minute", jrobin.getLastValue());
        }
        jrobins = this.collector.getDisplayedOtherJRobins();
        for (JRobin jrobin : jrobins) {
            this.printDouble(MetricType.GAUGE, "javamelody_last_value_" + PrometheusController.camelToSnake(jrobin.getName()), "javamelody value per minute", jrobin.getLastValue());
        }
    }

    private void reportOnJavaInformations() {
        if (this.javaInformations.getSessionCount() >= 0) {
            this.printLong(MetricType.GAUGE, "javamelody_sessions_active_count", "active session count", this.javaInformations.getSessionCount());
            this.printLong(MetricType.GAUGE, "javamelody_sessions_age_avg_minutes", "session avg age in minutes", this.javaInformations.getSessionMeanAgeInMinutes());
        }
        if (!Parameters.isNoDatabase()) {
            this.printLong(MetricType.COUNTER, "javamelody_transactions_count", "transactions count", this.javaInformations.getTransactionCount());
            this.printLong(MetricType.GAUGE, "javamelody_connections_used_count", "used connections count", this.javaInformations.getActiveConnectionCount());
            this.printLong(MetricType.GAUGE, "javamelody_connections_active_count", "active connections", this.javaInformations.getActiveConnectionCount());
            if (this.javaInformations.getMaxConnectionCount() > 0) {
                this.printLong(MetricType.GAUGE, "javamelody_connections_max_count", "max connections", this.javaInformations.getMaxConnectionCount());
                this.printDouble(MetricType.GAUGE, "javamelody_connections_used_pct", "used connections percentage", this.javaInformations.getUsedConnectionPercentage());
            }
        }
        if (this.javaInformations.getSystemLoadAverage() >= 0.0) {
            this.printDouble(MetricType.GAUGE, "javamelody_system_load_avg", "system load average", this.javaInformations.getSystemLoadAverage());
        }
        if (this.javaInformations.getSystemCpuLoad() >= 0.0) {
            this.printDouble(MetricType.GAUGE, "javamelody_system_cpu_load_pct", "system cpu load", this.javaInformations.getSystemCpuLoad());
        }
        if (this.javaInformations.getUnixOpenFileDescriptorCount() >= 0L) {
            this.printDouble(MetricType.GAUGE, "javamelody_system_unix_file_descriptors_open_count", "unix open file descriptors count", this.javaInformations.getUnixOpenFileDescriptorCount());
            this.printDouble(MetricType.GAUGE, "javamelody_system_unix_file_descriptors_max", "unix file descriptors max", this.javaInformations.getUnixMaxFileDescriptorCount());
            this.printDouble(MetricType.GAUGE, "javamelody_system_unix_file_descriptors_open_pct", "unix open file descriptors percentage", this.javaInformations.getUnixOpenFileDescriptorPercentage());
        }
        if (this.javaInformations.getFreeDiskSpaceInTemp() >= 0L) {
            this.printLong(MetricType.GAUGE, "javamelody_system_tmp_space_free_bytes", "tmp space available", this.javaInformations.getFreeDiskSpaceInTemp());
        }
        this.printLong(MetricType.GAUGE, "javamelody_jvm_start_time", "jvm start time", this.javaInformations.getStartDate().getTime());
        this.printLong(MetricType.COUNTER, "javamelody_jvm_cpu_millis", "jvm cpu millis", this.javaInformations.getProcessCpuTimeMillis());
        this.printLong(MetricType.GAUGE, "javamelody_system_processors_count", "processors available", this.javaInformations.getAvailableProcessors());
        this.printLong(MetricType.GAUGE, "javamelody_threads_count", "threads count", this.javaInformations.getThreadCount());
        this.printLong(MetricType.GAUGE, "javamelody_threads_max_count", "threads peak count", this.javaInformations.getPeakThreadCount());
        this.printLong(MetricType.COUNTER, "javamelody_threads_started_count", "total threads started", this.javaInformations.getTotalStartedThreadCount());
        this.printLong(MetricType.GAUGE, "javamelody_threads_active_count", "active thread count", this.javaInformations.getActiveThreadCount());
        if (this.javaInformations.isJobEnabled()) {
            this.printLong(MetricType.GAUGE, "javamelody_job_executing_count", "executing job count", this.javaInformations.getCurrentlyExecutingJobCount());
        }
    }

    private void reportOnMemoryInformations(MemoryInformations memoryInformations) {
        this.printLong(MetricType.GAUGE, "javamelody_memory_used_bytes", "used memory in bytes", memoryInformations.getUsedMemory());
        this.printLong(MetricType.GAUGE, "javamelody_memory_max_bytes", "max memory in bytes", memoryInformations.getMaxMemory());
        this.printDouble(MetricType.GAUGE, "javamelody_memory_used_pct", "memory used percentage", memoryInformations.getUsedMemoryPercentage());
        if (memoryInformations.getUsedPermGen() > 0L) {
            this.printLong(MetricType.GAUGE, "javamelody_memory_perm_gen_used_bytes", "used perm gen memory in bytes", memoryInformations.getUsedPermGen());
            if (memoryInformations.getMaxPermGen() > 0L) {
                this.printLong(MetricType.GAUGE, "javamelody_memory_perm_gen_max_bytes", "max perm gen memory in bytes", memoryInformations.getMaxPermGen());
                this.printDouble(MetricType.GAUGE, "javamelody_memory_perm_gen_used_pct", "used perm gen memory percentage", memoryInformations.getUsedPermGenPercentage());
            }
        }
        this.printDouble(MetricType.COUNTER, "javamelody_memory_gc_millis", "gc time millis", memoryInformations.getGarbageCollectionTimeMillis());
    }

    private void reportOnTomcatInformations(TomcatInformations tcInfo) {
        String fields = "{tomcat_name=\"" + PrometheusController.sanitizeName(tcInfo.getName()) + "\"}";
        this.printLongWithFields(MetricType.GAUGE, "javamelody_tomcat_threads_max", fields, "tomcat max threads", tcInfo.getMaxThreads());
        this.printLongWithFields(MetricType.GAUGE, "javamelody_tomcat_thread_busy_count", fields, "tomcat busy threads", tcInfo.getCurrentThreadsBusy());
        this.printLongWithFields(MetricType.COUNTER, "javamelody_tomcat_received_bytes", fields, "tomcat received bytes", tcInfo.getBytesReceived());
        this.printLongWithFields(MetricType.COUNTER, "javamelody_tomcat_sent_bytes", fields, "tomcat sent bytes", tcInfo.getBytesSent());
        this.printLongWithFields(MetricType.COUNTER, "javamelody_tomcat_request_count", fields, "tomcat request count", tcInfo.getRequestCount());
        this.printLongWithFields(MetricType.COUNTER, "javamelody_tomcat_error_count", fields, "tomcat error count", tcInfo.getErrorCount());
        this.printLongWithFields(MetricType.COUNTER, "javamelody_tomcat_processing_time_millis", fields, "tomcat processing time", tcInfo.getProcessingTime());
        this.printLongWithFields(MetricType.GAUGE, "javamelody_tomcat_max_time_millis", fields, "tomcat max time", tcInfo.getMaxTime());
    }

    private void reportOnCacheInformations(CacheInformations cacheInfo) {
        String fields = "{cache_name=\"" + PrometheusController.sanitizeName(cacheInfo.getName()) + "\"}";
        this.printLongWithFields(MetricType.GAUGE, "javamelody_cache_in_memory_count", fields, "cache in memory count", cacheInfo.getInMemoryObjectCount());
        this.printDoubleWithFields(MetricType.GAUGE, "javamelody_cache_in_memory_used_pct", fields, "in memory used percent", (double)cacheInfo.getInMemoryPercentUsed() / 100.0);
        this.printDoubleWithFields(MetricType.GAUGE, "javamelody_cache_in_memory_hits_pct", fields, "cache in memory hit percent", (double)cacheInfo.getInMemoryHitsRatio() / 100.0);
        this.printLongWithFields(MetricType.GAUGE, "javamelody_cache_on_disk_count", fields, "cache on disk count", cacheInfo.getOnDiskObjectCount());
        this.printDoubleWithFields(MetricType.GAUGE, "javamelody_cache_hits_pct", fields, "cache hits percent", (double)cacheInfo.getHitsRatio() / 100.0);
        this.printLongWithFields(MetricType.COUNTER, "javamelody_cache_in_memory_hits_count", fields, "cache in memory hit count", cacheInfo.getInMemoryHits());
        this.printLongWithFields(MetricType.COUNTER, "javamelody_cache_hits_count", fields, "cache  hit count", cacheInfo.getCacheHits());
        this.printLongWithFields(MetricType.COUNTER, "javamelody_cache_misses_count", fields, "cache misses count", cacheInfo.getCacheMisses());
    }

    private static String camelToSnake(String camel) {
        return camel.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    private static String sanitizeName(String name) {
        return name.toLowerCase().replaceAll("[- :]", "_").replaceAll("[^a-z0-9_]", "");
    }

    private void printLong(MetricType metricType, String name, String description, long value) {
        this.printLongWithFields(metricType, name, null, description, value);
    }

    private void printDouble(MetricType metricType, String name, String description, double value) {
        this.printDoubleWithFields(metricType, name, null, description, value);
    }

    private void printLongWithFields(MetricType metricType, String name, String fields, String description, long value) {
        this.printHeader(metricType, name, description);
        this.out.print(name);
        if (fields != null) {
            this.out.print(fields);
        }
        this.out.print(' ');
        this.out.println(value);
    }

    private void printDoubleWithFields(MetricType metricType, String name, String fields, String description, double value) {
        this.printHeader(metricType, name, description);
        this.out.print(name);
        if (fields != null) {
            this.out.print(fields);
        }
        this.out.print(' ');
        this.out.println(this.decimalFormat.format(value));
    }

    private void printHeader(MetricType metricType, String name, String description) {
        this.out.print("# HELP ");
        this.out.print(name);
        this.out.print(' ');
        this.out.println(description);
        this.out.print("# TYPE ");
        this.out.print(name);
        this.out.print(' ');
        this.out.println(metricType.getCode());
    }

    private static enum MetricType {
        GAUGE("gauge"),
        COUNTER("counter");

        private final String code;

        private MetricType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

