/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.internal.model.CloudWatch;
import net.bull.javamelody.internal.model.Datadog;
import net.bull.javamelody.internal.model.Graphite;
import net.bull.javamelody.internal.model.InfluxDB;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.Statsd;

abstract class MetricsPublisher {
    MetricsPublisher() {
    }

    static List<MetricsPublisher> getMetricsPublishers(List<JavaInformations> javaInformationsList) {
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        StringBuilder sb = new StringBuilder();
        for (JavaInformations javaInformations : javaInformationsList) {
            if (sb.length() != 0) {
                sb.append('_');
            }
            sb.append(javaInformations.getHost().replaceFirst("@.*", ""));
        }
        String contextPath = javaInformationsList.get(0).getContextPath();
        if (contextPath == null) {
            contextPath = "NA";
        } else if (contextPath.isEmpty()) {
            contextPath = "/";
        }
        String hosts = sb.toString();
        return MetricsPublisher.getMetricsPublishers(contextPath, hosts);
    }

    private static List<MetricsPublisher> getMetricsPublishers(String contextPath, String hosts) {
        ArrayList<MetricsPublisher> metricsPublishers = new ArrayList<MetricsPublisher>();
        Graphite graphite = Graphite.getInstance(contextPath, hosts);
        Statsd statsd = Statsd.getInstance(contextPath, hosts);
        CloudWatch cloudWatch = CloudWatch.getInstance(contextPath, hosts);
        InfluxDB influxDb = InfluxDB.getInstance(contextPath, hosts);
        Datadog datadog = Datadog.getInstance(contextPath, hosts);
        if (graphite != null) {
            metricsPublishers.add(graphite);
        }
        if (statsd != null) {
            metricsPublishers.add(statsd);
        }
        if (cloudWatch != null) {
            metricsPublishers.add(cloudWatch);
        }
        if (influxDb != null) {
            metricsPublishers.add(influxDb);
        }
        if (datadog != null) {
            metricsPublishers.add(datadog);
        }
        if (metricsPublishers.isEmpty()) {
            return Collections.emptyList();
        }
        return metricsPublishers;
    }

    abstract void addValue(String var1, double var2) throws IOException;

    abstract void send() throws IOException;

    abstract void stop();
}

