/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.MetricsPublisher;
import net.bull.javamelody.internal.model.TransportFormat;

class Datadog
extends MetricsPublisher {
    private static final String BEGIN_SERIES = "{ \"series\" : [";
    private static final String END_SERIES = "\n]}";
    private final URL datadogUrl;
    private final String prefix;
    private final String hostAndTags;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Writer bufferWriter = new OutputStreamWriter((OutputStream)this.buffer, Charset.forName("UTF-8"));

    Datadog(String datadogApiKey, String prefix, String hostAndTags) {
        assert (datadogApiKey != null);
        assert (prefix != null);
        assert (hostAndTags != null);
        try {
            this.datadogUrl = new URL("https://app.datadoghq.com/api/v1/series?api_key=" + datadogApiKey);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.prefix = prefix;
        this.hostAndTags = hostAndTags;
        try {
            this.bufferWriter.append(BEGIN_SERIES);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static Datadog getInstance(String contextPath, String hostName) {
        String datadogApiKey = Parameter.DATADOG_API_KEY.getValue();
        if (datadogApiKey != null) {
            assert (contextPath != null);
            assert (hostName != null);
            String prefix = "javamelody.";
            String hostAndTags = "\"host\":\"" + hostName + "\",\"tags\":[\"application\":\"" + contextPath + "\"]";
            return new Datadog(datadogApiKey, "javamelody.", hostAndTags);
        }
        return null;
    }

    @Override
    synchronized void addValue(String metric, double value) throws IOException {
        this.bufferWriter.append("\n{\"metric\":\"").append(this.prefix).append(metric).append("\",");
        this.bufferWriter.append("\"points\":").append(this.decimalFormat.format(value)).append(",");
        this.bufferWriter.append(this.hostAndTags);
        this.bufferWriter.append("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void send() throws IOException {
        try {
            this.bufferWriter.append(END_SERIES);
            this.bufferWriter.flush();
            HttpURLConnection connection = (HttpURLConnection)this.datadogUrl.openConnection();
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(60000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            this.buffer.writeTo(outputStream);
            outputStream.flush();
            int status = connection.getResponseCode();
            if (status >= 400) {
                ByteArrayOutputStream errorOutputStream = new ByteArrayOutputStream();
                TransportFormat.pump(connection.getErrorStream(), errorOutputStream);
                String msg = "Error connecting to Datadog (" + status + "): " + errorOutputStream.toString("UTF-8");
                LOG.warn(msg, new IOException(msg));
            }
            connection.disconnect();
        }
        catch (Exception e) {
            LOG.warn(e.toString(), e);
        }
        finally {
            this.buffer.reset();
            this.bufferWriter.append(BEGIN_SERIES);
        }
    }

    @Override
    void stop() {
    }
}

