/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.MavenArtifact;
import net.bull.javamelody.MemoryInformations;
import net.bull.javamelody.PID;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.SpringContext;
import net.bull.javamelody.ThreadInformations;
import net.bull.javamelody.TomcatInformations;

class JavaInformations
implements Serializable {
    static final double HIGH_USAGE_THRESHOLD_IN_PERCENTS = 95.0;
    private static final long serialVersionUID = 3281861236369720876L;
    private static final Date START_DATE = new Date();
    private static final boolean SYSTEM_CPU_LOAD_ENABLED = "1.7".compareTo(Parameters.JAVA_VERSION) < 0;
    private static final boolean SPRING_AVAILABLE = JavaInformations.isSpringAvailable();
    private static boolean localWebXmlExists = true;
    private static boolean localPomXmlExists = true;
    private final MemoryInformations memoryInformations;
    private final List<TomcatInformations> tomcatInformationsList;
    private final int sessionCount;
    private final long sessionAgeSum;
    private final int activeThreadCount;
    private final int usedConnectionCount;
    private final int maxConnectionCount;
    private final int activeConnectionCount;
    private final long transactionCount;
    private final long processCpuTimeMillis;
    private final double systemLoadAverage;
    private final double systemCpuLoad;
    private final long unixOpenFileDescriptorCount;
    private final long unixMaxFileDescriptorCount;
    private final String host;
    private final String os;
    private final int availableProcessors;
    private final String javaVersion;
    private final String jvmVersion;
    private final String pid;
    private final String serverInfo;
    private final String contextPath;
    private final String contextDisplayName;
    private final String webappVersion;
    private final Date startDate;
    private final String jvmArguments;
    private final long freeDiskSpaceInTemp;
    private final int threadCount;
    private final int peakThreadCount;
    private final long totalStartedThreadCount;
    private final String dataBaseVersion;
    private final String dataSourceDetails;
    private final List<ThreadInformations> threadInformationsList;
    private final List<CacheInformations> cacheInformationsList;
    private final List<JobInformations> jobInformationsList;
    private final boolean webXmlExists = localWebXmlExists;
    private final boolean pomXmlExists = localPomXmlExists;
    private final boolean springBeanExists;

    JavaInformations(ServletContext servletContext, boolean includeDetails) {
        this.memoryInformations = new MemoryInformations();
        this.tomcatInformationsList = TomcatInformations.buildTomcatInformationsList();
        this.sessionCount = SessionListener.getSessionCount();
        this.sessionAgeSum = SessionListener.getSessionAgeSum();
        this.activeThreadCount = JdbcWrapper.getActiveThreadCount();
        this.usedConnectionCount = JdbcWrapper.getUsedConnectionCount();
        this.activeConnectionCount = JdbcWrapper.getActiveConnectionCount();
        this.maxConnectionCount = JdbcWrapper.getMaxConnectionCount();
        this.transactionCount = JdbcWrapper.getTransactionCount();
        this.systemLoadAverage = JavaInformations.buildSystemLoadAverage();
        this.systemCpuLoad = JavaInformations.buildSystemCpuLoad();
        this.processCpuTimeMillis = JavaInformations.buildProcessCpuTimeMillis();
        this.unixOpenFileDescriptorCount = JavaInformations.buildOpenFileDescriptorCount();
        this.unixMaxFileDescriptorCount = JavaInformations.buildMaxFileDescriptorCount();
        this.host = Parameters.getHostName() + '@' + Parameters.getHostAddress();
        this.os = JavaInformations.buildOS();
        this.availableProcessors = Runtime.getRuntime().availableProcessors();
        this.javaVersion = System.getProperty("java.runtime.name") + ", " + System.getProperty("java.runtime.version");
        this.jvmVersion = System.getProperty("java.vm.name") + ", " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info");
        if (servletContext == null) {
            this.serverInfo = null;
            this.contextPath = null;
            this.contextDisplayName = null;
            this.webappVersion = null;
        } else {
            this.serverInfo = servletContext.getServerInfo();
            this.contextPath = Parameters.getContextPath(servletContext);
            this.contextDisplayName = servletContext.getServletContextName();
            this.webappVersion = MavenArtifact.getWebappVersion();
        }
        this.startDate = START_DATE;
        this.jvmArguments = JavaInformations.buildJvmArguments();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        this.threadCount = threadBean.getThreadCount();
        this.peakThreadCount = threadBean.getPeakThreadCount();
        this.totalStartedThreadCount = threadBean.getTotalStartedThreadCount();
        this.freeDiskSpaceInTemp = Parameters.TEMPORARY_DIRECTORY.getFreeSpace();
        boolean bl = this.springBeanExists = SPRING_AVAILABLE && SpringContext.getSingleton() != null;
        if (includeDetails) {
            this.dataBaseVersion = JavaInformations.buildDataBaseVersion();
            this.dataSourceDetails = JavaInformations.buildDataSourceDetails();
            this.threadInformationsList = JavaInformations.buildThreadInformationsList();
            this.cacheInformationsList = CacheInformations.buildCacheInformationsList();
            this.jobInformationsList = JobInformations.buildJobInformationsList();
            this.pid = PID.getPID();
        } else {
            this.dataBaseVersion = null;
            this.dataSourceDetails = null;
            this.threadInformationsList = null;
            this.cacheInformationsList = null;
            this.jobInformationsList = null;
            this.pid = null;
        }
    }

    static void setWebXmlExistsAndPomXmlExists(boolean webXmlExists, boolean pomXmlExists) {
        localWebXmlExists = webXmlExists;
        localPomXmlExists = pomXmlExists;
    }

    boolean doesWebXmlExists() {
        return this.webXmlExists;
    }

    boolean doesPomXmlExists() {
        return this.pomXmlExists;
    }

    private static String buildOS() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String patchLevel = System.getProperty("sun.os.patch.level");
        String arch = System.getProperty("os.arch");
        String bits = System.getProperty("sun.arch.data.model");
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(", ");
        if (!name.toLowerCase(Locale.ENGLISH).contains("windows")) {
            sb.append(version).append(' ');
        }
        if (!"unknown".equals(patchLevel)) {
            sb.append(patchLevel);
        }
        sb.append(", ").append(arch).append('/').append(bits);
        return sb.toString();
    }

    private static long buildProcessCpuTimeMillis() {
        OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (JavaInformations.isSunOsMBean(operatingSystem)) {
            return MemoryInformations.getLongFromOperatingSystem(operatingSystem, "getProcessCpuTime") / 1000000L;
        }
        return -1L;
    }

    private static long buildOpenFileDescriptorCount() {
        OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (JavaInformations.isSunOsMBean(operatingSystem) && JavaInformations.isSunUnixMBean(operatingSystem)) {
            try {
                return MemoryInformations.getLongFromOperatingSystem(operatingSystem, "getOpenFileDescriptorCount");
            }
            catch (Error e) {
                return -1L;
            }
        }
        return -1L;
    }

    private static long buildMaxFileDescriptorCount() {
        OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (JavaInformations.isSunOsMBean(operatingSystem) && JavaInformations.isSunUnixMBean(operatingSystem)) {
            try {
                return MemoryInformations.getLongFromOperatingSystem(operatingSystem, "getMaxFileDescriptorCount");
            }
            catch (Error e) {
                return -1L;
            }
        }
        return -1L;
    }

    private static double buildSystemCpuLoad() {
        OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (SYSTEM_CPU_LOAD_ENABLED && JavaInformations.isSunOsMBean(operatingSystem)) {
            return MemoryInformations.getDoubleFromOperatingSystem(operatingSystem, "getSystemCpuLoad") * 100.0;
        }
        return -1.0;
    }

    private static double buildSystemLoadAverage() {
        OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystem.getSystemLoadAverage() >= 0.0) {
            return operatingSystem.getSystemLoadAverage();
        }
        return -1.0;
    }

    private static String buildJvmArguments() {
        StringBuilder jvmArgs = new StringBuilder();
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            jvmArgs.append(jvmArg).append('\n');
        }
        if (jvmArgs.length() > 0) {
            jvmArgs.deleteCharAt(jvmArgs.length() - 1);
        }
        return jvmArgs.toString();
    }

    static List<ThreadInformations> buildThreadInformationsList() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ArrayList<Thread> threads = new ArrayList<Thread>(stackTraces.keySet());
        boolean cpuTimeEnabled = threadBean.isThreadCpuTimeSupported() && threadBean.isThreadCpuTimeEnabled();
        long[] deadlockedThreads = JavaInformations.getDeadlockedThreads(threadBean);
        ArrayList<ThreadInformations> threadInfosList = new ArrayList<ThreadInformations>(threads.size());
        String hostAddress = Parameters.getHostAddress();
        for (Thread thread : threads) {
            long userTimeMillis;
            long cpuTimeMillis;
            ArrayList<StackTraceElement> stackTraceElementList;
            StackTraceElement[] stackTraceElements = stackTraces.get(thread);
            ArrayList<StackTraceElement> arrayList = stackTraceElementList = stackTraceElements == null ? null : new ArrayList<StackTraceElement>(Arrays.asList(stackTraceElements));
            if (cpuTimeEnabled) {
                cpuTimeMillis = threadBean.getThreadCpuTime(thread.getId()) / 1000000L;
                userTimeMillis = threadBean.getThreadUserTime(thread.getId()) / 1000000L;
            } else {
                cpuTimeMillis = -1L;
                userTimeMillis = -1L;
            }
            boolean deadlocked = deadlockedThreads != null && Arrays.binarySearch(deadlockedThreads, thread.getId()) >= 0;
            threadInfosList.add(new ThreadInformations(thread, stackTraceElementList, cpuTimeMillis, userTimeMillis, deadlocked, hostAddress));
        }
        return threadInfosList;
    }

    static List<Thread> getThreadsFromThreadGroups() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        Thread[] threadsArray = new Thread[group.activeCount()];
        group.enumerate(threadsArray, true);
        return Arrays.asList(threadsArray);
    }

    private static long[] getDeadlockedThreads(ThreadMXBean threadBean) {
        long[] deadlockedThreads = threadBean.isSynchronizerUsageSupported() ? threadBean.findDeadlockedThreads() : threadBean.findMonitorDeadlockedThreads();
        if (deadlockedThreads != null) {
            Arrays.sort(deadlockedThreads);
        }
        return deadlockedThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildDataBaseVersion() {
        if (Parameters.isNoDatabase()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        try {
            if (Parameters.getLastConnectUrl() != null) {
                Connection connection = DriverManager.getConnection(Parameters.getLastConnectUrl(), Parameters.getLastConnectInfo());
                connection.setAutoCommit(false);
                try {
                    JavaInformations.appendDataBaseVersion(result, connection);
                }
                finally {
                    connection.close();
                }
            }
            Map<String, DataSource> dataSources = JdbcWrapper.getJndiAndSpringDataSources();
            for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
                String name = entry.getKey();
                DataSource dataSource = entry.getValue();
                Connection connection = dataSource.getConnection();
                try {
                    if (result.length() > 0) {
                        result.append("\n\n");
                    }
                    result.append(name).append(":\n");
                    JavaInformations.appendDataBaseVersion(result, connection);
                }
                finally {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            result.append(e.toString());
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    private static void appendDataBaseVersion(StringBuilder result, Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        result.append(metaData.getURL()).append('\n');
        result.append(metaData.getDatabaseProductName()).append(", ").append(metaData.getDatabaseProductVersion()).append('\n');
        result.append("Driver JDBC:\n").append(metaData.getDriverName()).append(", ").append(metaData.getDriverVersion());
    }

    private static String buildDataSourceDetails() {
        Map<String, Map<String, Object>> dataSourcesProperties = JdbcWrapper.getBasicDataSourceProperties();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, Object>> entry : dataSourcesProperties.entrySet()) {
            String name;
            Map<String, Object> dataSourceProperties = entry.getValue();
            if (dataSourceProperties.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if ((name = entry.getKey()) != null) {
                sb.append(name).append(":\n");
            }
            for (Map.Entry<String, Object> propertyEntry : dataSourceProperties.entrySet()) {
                sb.append(propertyEntry.getKey()).append(" = ").append(propertyEntry.getValue()).append('\n');
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private static boolean isSunOsMBean(OperatingSystemMXBean operatingSystem) {
        String className = operatingSystem.getClass().getName();
        return "com.sun.management.OperatingSystem".equals(className) || "com.sun.management.UnixOperatingSystem".equals(className) || "sun.management.OperatingSystemImpl".equals(className);
    }

    private static boolean isSunUnixMBean(OperatingSystemMXBean operatingSystem) {
        for (Class<?> inter : operatingSystem.getClass().getInterfaces()) {
            if (!"com.sun.management.UnixOperatingSystemMXBean".equals(inter.getName())) continue;
            return true;
        }
        return false;
    }

    MemoryInformations getMemoryInformations() {
        return this.memoryInformations;
    }

    List<TomcatInformations> getTomcatInformationsList() {
        return this.tomcatInformationsList;
    }

    int getSessionCount() {
        return this.sessionCount;
    }

    long getSessionAgeSum() {
        return this.sessionAgeSum;
    }

    long getSessionMeanAgeInMinutes() {
        if (this.sessionCount > 0) {
            return this.sessionAgeSum / (long)this.sessionCount / 60000L;
        }
        return -1L;
    }

    int getActiveThreadCount() {
        return this.activeThreadCount;
    }

    int getUsedConnectionCount() {
        return this.usedConnectionCount;
    }

    int getActiveConnectionCount() {
        return this.activeConnectionCount;
    }

    int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    long getTransactionCount() {
        return this.transactionCount;
    }

    double getUsedConnectionPercentage() {
        if (this.maxConnectionCount > 0) {
            return 100.0 * (double)this.usedConnectionCount / (double)this.maxConnectionCount;
        }
        return -1.0;
    }

    long getProcessCpuTimeMillis() {
        return this.processCpuTimeMillis;
    }

    double getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    double getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    long getUnixOpenFileDescriptorCount() {
        return this.unixOpenFileDescriptorCount;
    }

    long getUnixMaxFileDescriptorCount() {
        return this.unixMaxFileDescriptorCount;
    }

    double getUnixOpenFileDescriptorPercentage() {
        if (this.unixOpenFileDescriptorCount >= 0L) {
            return 100.0 * (double)this.unixOpenFileDescriptorCount / (double)this.unixMaxFileDescriptorCount;
        }
        return -1.0;
    }

    String getHost() {
        return this.host;
    }

    String getOS() {
        return this.os;
    }

    int getAvailableProcessors() {
        return this.availableProcessors;
    }

    String getJavaVersion() {
        return this.javaVersion;
    }

    String getJvmVersion() {
        return this.jvmVersion;
    }

    String getPID() {
        return this.pid;
    }

    String getServerInfo() {
        return this.serverInfo;
    }

    String getContextPath() {
        return this.contextPath;
    }

    String getContextDisplayName() {
        return this.contextDisplayName;
    }

    String getWebappVersion() {
        return this.webappVersion;
    }

    Date getStartDate() {
        return this.startDate;
    }

    String getJvmArguments() {
        return this.jvmArguments;
    }

    long getFreeDiskSpaceInTemp() {
        return this.freeDiskSpaceInTemp;
    }

    int getThreadCount() {
        return this.threadCount;
    }

    int getPeakThreadCount() {
        return this.peakThreadCount;
    }

    long getTotalStartedThreadCount() {
        return this.totalStartedThreadCount;
    }

    String getDataBaseVersion() {
        return this.dataBaseVersion;
    }

    String getDataSourceDetails() {
        return this.dataSourceDetails;
    }

    List<ThreadInformations> getThreadInformationsList() {
        ArrayList<ThreadInformations> result = new ArrayList<ThreadInformations>(this.threadInformationsList);
        Collections.sort(result, new ThreadInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    List<CacheInformations> getCacheInformationsList() {
        ArrayList<CacheInformations> result = new ArrayList<CacheInformations>(this.cacheInformationsList);
        Collections.sort(result, new CacheInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    List<JobInformations> getJobInformationsList() {
        ArrayList<JobInformations> result = new ArrayList<JobInformations>(this.jobInformationsList);
        Collections.sort(result, new JobInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    int getCurrentlyExecutingJobCount() {
        int result = 0;
        for (JobInformations jobInformations : this.jobInformationsList) {
            if (!jobInformations.isCurrentlyExecuting()) continue;
            ++result;
        }
        return result;
    }

    boolean isStackTraceEnabled() {
        for (ThreadInformations threadInformations : this.threadInformationsList) {
            List<StackTraceElement> stackTrace = threadInformations.getStackTrace();
            if (stackTrace == null || stackTrace.isEmpty()) continue;
            return true;
        }
        return false;
    }

    boolean isCacheEnabled() {
        return this.cacheInformationsList != null && !this.cacheInformationsList.isEmpty();
    }

    boolean isJobEnabled() {
        return this.jobInformationsList != null && !this.jobInformationsList.isEmpty();
    }

    boolean isSpringBeansEnabled() {
        return this.springBeanExists;
    }

    private static boolean isSpringAvailable() {
        try {
            Class.forName("org.springframework.context.ApplicationContextAware");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pid=" + this.getPID() + ", host=" + this.getHost() + ", javaVersion=" + this.getJavaVersion() + ", serverInfo=" + this.getServerInfo() + ']';
    }

    static final class JobInformationsComparator
    implements Comparator<JobInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JobInformationsComparator() {
        }

        @Override
        public int compare(JobInformations job1, JobInformations job2) {
            return job1.getName().compareToIgnoreCase(job2.getName());
        }
    }

    static final class CacheInformationsComparator
    implements Comparator<CacheInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CacheInformationsComparator() {
        }

        @Override
        public int compare(CacheInformations cache1, CacheInformations cache2) {
            return cache1.getName().compareToIgnoreCase(cache2.getName());
        }
    }

    static final class ThreadInformationsComparator
    implements Comparator<ThreadInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ThreadInformationsComparator() {
        }

        @Override
        public int compare(ThreadInformations thread1, ThreadInformations thread2) {
            return thread1.getName().compareToIgnoreCase(thread2.getName());
        }
    }
}

