/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.FilterServletResponseWrapper;
import net.bull.javamelody.HtmlInjectorResponseStream;

class HtmlInjectorServletResponseWrapper
extends FilterServletResponseWrapper {
    private static final String INJECTOR_WRAPPED_REQUEST_KEY = "javamelody.injectorWrapped";
    private final HtmlInjectorResponseStream.HtmlToInject htmlToInject;

    HtmlInjectorServletResponseWrapper(HttpServletRequest request, HttpServletResponse response, HtmlInjectorResponseStream.HtmlToInject htmlToInject) {
        super(response);
        assert (request != null);
        assert (response != null);
        assert (htmlToInject != null);
        this.htmlToInject = htmlToInject;
        request.setAttribute(INJECTOR_WRAPPED_REQUEST_KEY, (Object)Boolean.TRUE);
    }

    static boolean acceptsRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        return accept != null && accept.contains("text/html") && request.getAttribute(INJECTOR_WRAPPED_REQUEST_KEY) == null;
    }

    @Override
    public ServletOutputStream createOutputStream() throws IOException {
        if (!this.isContentTypeHtml()) {
            return this.getHttpServletResponse().getOutputStream();
        }
        return new HtmlInjectorResponseStream(this.getHttpServletResponse(), this.htmlToInject);
    }

    public void setContentType(String contentType) {
        super.setContentType(contentType);
        if (!this.isContentTypeHtml() && this.getStream() instanceof HtmlInjectorResponseStream) {
            ((HtmlInjectorResponseStream)this.getStream()).cancelInjection();
        }
    }

    private boolean isContentTypeHtml() {
        String contentType = this.getContentType();
        return contentType == null || contentType.contains("text/html");
    }
}

