/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestAggregation;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.MBeanNode;
import net.bull.javamelody.PdfCounterReport;
import net.bull.javamelody.PdfCounterRequestContextReport;
import net.bull.javamelody.PdfDatabaseInformationsReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.PdfHeapHistogramReport;
import net.bull.javamelody.PdfHotspotsReport;
import net.bull.javamelody.PdfJndiReport;
import net.bull.javamelody.PdfMBeansReport;
import net.bull.javamelody.PdfProcessInformationsReport;
import net.bull.javamelody.PdfRequestAndGraphDetailReport;
import net.bull.javamelody.PdfRuntimeDependenciesReport;
import net.bull.javamelody.PdfSessionInformationsReport;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SamplingProfiler;
import net.bull.javamelody.SessionInformations;

class PdfOtherReport {
    private final OutputStream output;
    private final Document document;
    private final PdfDocumentFactory pdfDocumentFactory;

    PdfOtherReport(String application, OutputStream output) throws IOException {
        assert (output != null);
        this.output = output;
        try {
            this.pdfDocumentFactory = new PdfDocumentFactory(application, null, output);
            this.document = this.pdfDocumentFactory.createDocument();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
    }

    void close() throws IOException {
        this.output.close();
    }

    void writeSessionInformations(List<SessionInformations> sessionsInformations) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getString("Sessions"), "system-users.png");
            new PdfSessionInformationsReport(sessionsInformations, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeHeapHistogram(HeapHistogram heapHistogram) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getFormattedString("heap_histo_du", I18N.createDateAndTimeFormat().format(heapHistogram.getTime())), "memory.png");
            new PdfHeapHistogramReport(heapHistogram, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeHotspots(List<SamplingProfiler.SampledMethod> hotspots) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getString("hotspots"), "clock.png");
            new PdfHotspotsReport(hotspots, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeProcessInformations(List<ProcessInformations> processInformations) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getString("Processus"), "processes.png");
            new PdfProcessInformationsReport(processInformations, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeProcessInformations(Map<String, List<ProcessInformations>> processInformationsByTitle) throws IOException {
        try {
            this.document.open();
            for (Map.Entry<String, List<ProcessInformations>> entry : processInformationsByTitle.entrySet()) {
                this.addParagraph(entry.getKey(), "processes.png");
                new PdfProcessInformationsReport(entry.getValue(), this.document).toPdf();
            }
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeDatabaseInformations(DatabaseInformations databaseInformations) throws IOException {
        try {
            this.document.open();
            String selectedRequestName = databaseInformations.getSelectedRequestName();
            this.addParagraph(PdfOtherReport.getString("database") + " : " + PdfOtherReport.getString(selectedRequestName), "db.png");
            new PdfDatabaseInformationsReport(databaseInformations, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeJndi(List<JndiBinding> jndiBindings, String path) throws IOException {
        try {
            this.document.open();
            if (path.isEmpty()) {
                this.addParagraph(PdfOtherReport.getString("Arbre_JNDI"), "jndi.png");
            } else {
                this.addParagraph(PdfOtherReport.getFormattedString("Arbre_JNDI_pour_contexte", path), "jndi.png");
            }
            new PdfJndiReport(jndiBindings, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeMBeans(List<MBeanNode> mbeans) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getString("MBeans"), "mbeans.png");
            new PdfMBeansReport(mbeans, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeMBeans(Map<String, List<MBeanNode>> mbeansByTitle) throws IOException {
        try {
            this.document.open();
            for (Map.Entry<String, List<MBeanNode>> entry : mbeansByTitle.entrySet()) {
                this.addParagraph(entry.getKey(), "mbeans.png");
                new PdfMBeansReport(entry.getValue(), this.document).toPdf();
            }
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeAllCurrentRequestsAsPart(Map<JavaInformations, List<CounterRequestContext>> currentRequests, Collector collector, List<Counter> counters, long timeOfSnapshot) throws IOException {
        try {
            this.document.open();
            ArrayList<CounterRequestContext> allCurrentRequests = new ArrayList<CounterRequestContext>();
            for (List<CounterRequestContext> rootCurrentContexts : currentRequests.values()) {
                allCurrentRequests.addAll(rootCurrentContexts);
            }
            CounterRequestContext.replaceParentCounters(allCurrentRequests, counters);
            ArrayList<PdfCounterReport> pdfCounterReports = new ArrayList<PdfCounterReport>();
            Range range = Period.TOUT.getRange();
            for (Counter counter : counters) {
                PdfCounterReport pdfCounterReport = new PdfCounterReport(collector, counter, range, false, this.document);
                pdfCounterReports.add(pdfCounterReport);
            }
            Font normalFont = PdfFonts.NORMAL.getFont();
            for (Map.Entry<JavaInformations, List<CounterRequestContext>> entry : currentRequests.entrySet()) {
                JavaInformations javaInformations = entry.getKey();
                List<CounterRequestContext> rootCurrentContexts = entry.getValue();
                this.addParagraph(PdfOtherReport.getString("Requetes_en_cours"), "hourglass.png");
                if (rootCurrentContexts.isEmpty()) {
                    this.addToDocument((Element)new Phrase(PdfOtherReport.getString("Aucune_requete_en_cours"), normalFont));
                    continue;
                }
                PdfCounterRequestContextReport pdfCounterRequestContextReport = new PdfCounterRequestContextReport(rootCurrentContexts, pdfCounterReports, javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.pdfDocumentFactory, this.document);
                pdfCounterRequestContextReport.setTimeOfSnapshot(timeOfSnapshot);
                pdfCounterRequestContextReport.writeContextDetails();
            }
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeRequestAndGraphDetail(Collector collector, CollectorServer collectorServer, Range range, String requestId) throws IOException {
        try {
            this.document.open();
            new PdfRequestAndGraphDetailReport(collector, collectorServer, range, requestId, this.pdfDocumentFactory, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeRuntimeDependencies(Counter counter, Range range) throws IOException {
        try {
            Document myDocument = this.pdfDocumentFactory.createDocument(true);
            myDocument.open();
            String counterLabel = PdfOtherReport.getString(counter.getName() + "Label");
            String paragraphTitle = PdfOtherReport.getFormattedString("Dependance_compteur", counterLabel) + " - " + range.getLabel();
            myDocument.add(this.pdfDocumentFactory.createParagraphElement(paragraphTitle, counter.getIconName()));
            new PdfRuntimeDependenciesReport(counter, myDocument).toPdf();
            myDocument.close();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
    }

    void writeCounterSummaryPerClass(Collector collector, Counter counter, String requestId, Range range) throws IOException {
        List<CounterRequest> requestList = new CounterRequestAggregation(counter).getRequestsAggregatedOrFilteredByClassName(requestId);
        try {
            this.document.open();
            String counterLabel = PdfOtherReport.getString(counter.getName() + "Label");
            String title = PdfOtherReport.getFormattedString("Statistiques_compteur", counterLabel) + " - " + range.getLabel();
            this.addParagraph(title, counter.getIconName());
            new PdfCounterReport(collector, counter, range, false, this.document).writeRequests(counter.getChildCounterName(), requestList);
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    private static IOException createIOException(Exception e) {
        return new IOException(e.getMessage(), e);
    }

    private void addParagraph(String paragraphTitle, String iconName) throws DocumentException, IOException {
        this.addToDocument(this.pdfDocumentFactory.createParagraphElement(paragraphTitle, iconName));
    }

    private static String getString(String key) {
        return I18N.getString(key);
    }

    private static String getFormattedString(String key, Object ... arguments) {
        return I18N.getFormattedString(key, arguments);
    }

    private void addToDocument(Element element) throws DocumentException {
        this.document.add(element);
    }
}

