/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.HtmlSourceReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.SamplingProfiler;

class HtmlHotspotsReport
extends HtmlAbstractReport {
    private final List<SamplingProfiler.SampledMethod> hotspots;
    private final long totalCount;
    private final DecimalFormat percentFormat = I18N.createPercentFormat();

    HtmlHotspotsReport(List<SamplingProfiler.SampledMethod> hotspots, Writer writer) {
        super(writer);
        assert (hotspots != null);
        this.hotspots = hotspots;
        long total = 0L;
        for (SamplingProfiler.SampledMethod hotspot : hotspots) {
            total += hotspot.getCount();
        }
        this.totalCount = total;
    }

    @Override
    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeTitle("clock.png", HtmlHotspotsReport.getString("hotspots"));
        this.writeTable();
    }

    private void writeTable() throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlHotspotsReport.getString("hotspots"));
        this.write("<th>#Methode_executee#</th>");
        this.write("<th class='sorttable_numeric'>#percent_time#</th>");
        for (SamplingProfiler.SampledMethod hotspot : this.hotspots) {
            table.nextRow();
            this.writeHotspot(hotspot);
        }
        table.endTable();
    }

    private void writeHotspot(SamplingProfiler.SampledMethod hotspot) throws IOException {
        this.write("<td>");
        this.writeDirectly(HtmlSourceReport.addLinkToClassName(hotspot.getClassName()));
        this.write(".<b>");
        this.writeDirectly(HtmlHotspotsReport.htmlEncode(hotspot.getMethodName()));
        this.write("</b>");
        this.write("</td><td align='right'>");
        double percent = 100.0 * (double)hotspot.getCount() / (double)this.totalCount;
        this.write(this.percentFormat.format(percent));
        this.write("</td>");
    }

    void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=hotspots'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlHotspotsReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=hotspots&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=hotspots&amp;action=clear_hotspots" + HtmlHotspotsReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + HtmlHotspotsReport.getStringForJavascript("confirm_clear_hotspots") + "');\">");
        this.writeln("<img width='16' height='16' src='?resource=user-trash.png' alt='#clear_hotspots#' title='#clear_hotspots#' /> #clear_hotspots#</a>");
        this.writeln("</div>");
    }
}

