/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

class Mailer {
    private final String jndiName;
    private Session session;
    private InternetAddress fromAddress;

    Mailer(String jndiName) {
        assert (jndiName != null);
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() throws NamingException {
        if (this.session == null) {
            Mailer mailer = this;
            synchronized (mailer) {
                try {
                    this.session = (Session)this.lookupFromJndiName();
                }
                catch (ClassCastException e) {
                    this.session = Session.getInstance((Properties)this.getPropertiesFromSession(this.lookupFromJndiName()));
                }
            }
            this.fromAddress = InternetAddress.getLocalAddress((Session)this.session);
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupFromJndiName() throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            Object object = ctx.lookup("java:comp/env/" + this.jndiName);
            return object;
        }
        catch (NameNotFoundException e) {
            try {
                Object object = ctx.lookup("java:/" + this.jndiName);
                return object;
            }
            catch (NameNotFoundException e2) {
                Object object = ctx.lookup(this.jndiName);
                return object;
            }
        }
        finally {
            ctx.close();
        }
    }

    void setSession(Session session) {
        this.session = session;
        this.fromAddress = InternetAddress.getLocalAddress((Session)session);
    }

    private Properties getPropertiesFromSession(Object jndiSession) {
        try {
            Method getPropertiesMethod = jndiSession.getClass().getMethod("getProperties", null);
            return (Properties)getPropertiesMethod.invoke(jndiSession, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(String toAddress, String subject, String message, List<File> attachments, boolean highPriority) throws NamingException, MessagingException {
        assert (toAddress != null);
        assert (subject != null);
        assert (message != null);
        InternetAddress[] toAddresses = InternetAddress.parse((String)toAddress, (boolean)false);
        MimeMessage msg = new MimeMessage(this.getSession());
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setFrom((Address)this.fromAddress);
        if (highPriority) {
            msg.setHeader("X-Priority", "1");
            msg.setHeader("x-msmail-priority", "high");
        }
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setText(message);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)mbp);
        if (attachments != null && !attachments.isEmpty()) {
            for (File attachment : attachments) {
                FileDataSource source = new FileDataSource(attachment);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(attachment.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
        msg.setContent((Multipart)multipart);
        String protocol = this.session.getProperty("mail.transport.protocol");
        if (protocol == null) {
            protocol = "smtp";
        }
        if (Boolean.parseBoolean(this.session.getProperty("mail." + protocol + ".auth"))) {
            Transport tr = this.session.getTransport(protocol);
            try {
                tr.connect(this.session.getProperty("mail." + protocol + ".user"), this.session.getProperty("mail." + protocol + ".password"));
                msg.saveChanges();
                tr.sendMessage((Message)msg, msg.getAllRecipients());
            }
            finally {
                tr.close();
            }
        } else {
            Transport.send((Message)msg);
        }
    }
}

