/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MBeanNode;

final class MBeans {
    private static final String JAVA_LANG_MBEAN_DESCRIPTION = "Information on the management interface of the MBean";
    private static final Comparator<MBeanNode> NODE_COMPARATOR = new Comparator<MBeanNode>(){

        @Override
        public int compare(MBeanNode o1, MBeanNode o2) {
            return o1.getName() != null ? o1.getName().compareTo(o2.getName()) : 0;
        }
    };
    private static final Comparator<MBeanNode.MBeanAttribute> ATTRIBUTE_COMPARATOR = new Comparator<MBeanNode.MBeanAttribute>(){

        @Override
        public int compare(MBeanNode.MBeanAttribute o1, MBeanNode.MBeanAttribute o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final MBeanServer mbeanServer;

    MBeans() {
        this(MBeans.getPlatformMBeanServer());
    }

    private MBeans(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    Set<ObjectName> getTomcatThreadPools() throws MalformedObjectNameException {
        return this.mbeanServer.queryNames(new ObjectName("*:type=ThreadPool,*"), null);
    }

    Set<ObjectName> getTomcatGlobalRequestProcessors() throws MalformedObjectNameException {
        return this.mbeanServer.queryNames(new ObjectName("*:type=GlobalRequestProcessor,*"), null);
    }

    Object getAttribute(ObjectName name, String attribute) throws JMException {
        return this.mbeanServer.getAttribute(name, attribute);
    }

    static List<MBeanNode> getAllMBeanNodes() throws JMException {
        MBeans.initJRockitMBeansIfNeeded();
        ArrayList<MBeanNode> result = new ArrayList<MBeanNode>();
        MBeanServer platformMBeanServer = MBeans.getPlatformMBeanServer();
        MBeanNode platformNode = new MBeanNode("");
        MBeans platformMBeans = new MBeans();
        platformNode.getChildren().addAll(platformMBeans.getMBeanNodes());
        result.add(platformNode);
        for (MBeanServer mbeanServer : MBeans.getMBeanServers()) {
            if (mbeanServer.equals(platformMBeanServer)) continue;
            MBeanNode node = new MBeanNode(mbeanServer.getDefaultDomain());
            MBeans mbeans = new MBeans(mbeanServer);
            node.getChildren().addAll(mbeans.getMBeanNodes());
            result.add(node);
        }
        return result;
    }

    private static void initJRockitMBeansIfNeeded() {
        if (System.getProperty("java.vendor").contains("BEA")) {
            try {
                try {
                    MBeans.getPlatformMBeanServer().getMBeanInfo(new ObjectName("bea.jrockit.management:type=JRockitConsole"));
                }
                catch (InstanceNotFoundException e1) {
                    MBeans.getPlatformMBeanServer().createMBean("bea.jrockit.management.JRockitConsole", null);
                    LOG.debug("JRockit MBeans initialized");
                }
            }
            catch (JMException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private List<MBeanNode> getMBeanNodes() throws JMException {
        ArrayList<MBeanNode> result = new ArrayList<MBeanNode>();
        Set<ObjectName> names = this.mbeanServer.queryNames(null, null);
        for (ObjectName name : names) {
            String keyPropertyListString;
            int indexOf;
            String firstPropertyValue;
            String domain = name.getDomain();
            if ("jboss.deployment".equals(domain)) continue;
            MBeanNode domainNode = MBeans.getMBeanNodeFromList(result, domain);
            if (domainNode == null) {
                domainNode = new MBeanNode(domain);
                result.add(domainNode);
            }
            if ("Servlet".equals(firstPropertyValue = (indexOf = (keyPropertyListString = name.getKeyPropertyListString()).indexOf(61)) == -1 ? null : name.getKeyProperty(keyPropertyListString.substring(0, indexOf))) && "jonas".equals(domain)) continue;
            MBeanNode firstPropertyNode = MBeans.getMBeanNodeFromList(domainNode.getChildren(), firstPropertyValue);
            if (firstPropertyNode == null) {
                firstPropertyNode = new MBeanNode(firstPropertyValue);
                domainNode.getChildren().add(firstPropertyNode);
            }
            MBeanNode mbean = this.getMBeanNode(name);
            firstPropertyNode.getChildren().add(mbean);
        }
        this.sortMBeanNodes(result);
        return result;
    }

    private void sortMBeanNodes(List<MBeanNode> nodes) {
        if (nodes.size() > 1) {
            Collections.sort(nodes, NODE_COMPARATOR);
        }
        for (MBeanNode node : nodes) {
            List<MBeanNode.MBeanAttribute> attributes;
            List<MBeanNode> children = node.getChildren();
            if (children != null) {
                this.sortMBeanNodes(children);
            }
            if ((attributes = node.getAttributes()) == null || attributes.size() <= 1) continue;
            Collections.sort(attributes, ATTRIBUTE_COMPARATOR);
        }
    }

    private static MBeanNode getMBeanNodeFromList(List<MBeanNode> list, String name) {
        for (MBeanNode node : list) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    private MBeanNode getMBeanNode(ObjectName name) throws JMException {
        String mbeanName = name.toString();
        MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(name);
        String description = this.formatDescription(mbeanInfo.getDescription());
        MBeanAttributeInfo[] attributeInfos = mbeanInfo.getAttributes();
        List<MBeanNode.MBeanAttribute> attributes = this.getAttributes(name, attributeInfos);
        return new MBeanNode(mbeanName, description, attributes);
    }

    private List<MBeanNode.MBeanAttribute> getAttributes(ObjectName name, MBeanAttributeInfo[] attributeInfos) {
        ArrayList<String> attributeNames = new ArrayList<String>(attributeInfos.length);
        for (MBeanAttributeInfo attribute : attributeInfos) {
            if (!attribute.isReadable() || "password".equalsIgnoreCase(attribute.getName())) continue;
            attributeNames.add(attribute.getName());
        }
        String[] attributeNamesArray = attributeNames.toArray(new String[attributeNames.size()]);
        ArrayList<MBeanNode.MBeanAttribute> result = new ArrayList<MBeanNode.MBeanAttribute>();
        try {
            AttributeList attributes = this.mbeanServer.getAttributes(name, attributeNamesArray);
            for (Object object : attributes) {
                Attribute attribute = (Attribute)object;
                Object value = this.convertValueIfNeeded(attribute.getValue());
                String attributeDescription = this.getAttributeDescription(attribute.getName(), attributeInfos);
                String formattedAttributeValue = this.formatAttributeValue(value);
                MBeanNode.MBeanAttribute mbeanAttribute = new MBeanNode.MBeanAttribute(attribute.getName(), attributeDescription, formattedAttributeValue);
                result.add(mbeanAttribute);
            }
        }
        catch (Exception e) {
            MBeanNode.MBeanAttribute mbeanAttribute = new MBeanNode.MBeanAttribute("exception", null, e.toString());
            result.add(mbeanAttribute);
        }
        return result;
    }

    private String formatAttributeValue(Object attributeValue) {
        try {
            if (attributeValue instanceof List) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                boolean first = true;
                for (Object value : (List)attributeValue) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",\n");
                    }
                    sb.append(String.valueOf(value));
                }
                sb.append(']');
                return sb.toString();
            }
            return String.valueOf(attributeValue);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private String formatDescription(String description) {
        if (description == null || JAVA_LANG_MBEAN_DESCRIPTION.equals(description)) {
            return null;
        }
        int indexOf = description.indexOf("  ");
        if (indexOf != -1) {
            StringBuilder sb = new StringBuilder(description);
            while (indexOf != -1) {
                sb.deleteCharAt(indexOf);
                indexOf = sb.indexOf("  ");
            }
            return sb.toString();
        }
        return description;
    }

    private Object convertValueIfNeeded(Object value) {
        if (value instanceof CompositeData) {
            CompositeData data = (CompositeData)value;
            TreeMap<String, Object> values = new TreeMap<String, Object>();
            for (String key : data.getCompositeType().keySet()) {
                values.put(key, this.convertValueIfNeeded(data.get(key)));
            }
            return values;
        }
        if (value instanceof CompositeData[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (CompositeData data : (CompositeData[])value) {
                list.add(this.convertValueIfNeeded(data));
            }
            return list;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof TabularData) {
            TabularData tabularData = (TabularData)value;
            return this.convertValueIfNeeded(tabularData.values());
        }
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object data : (Collection)value) {
                list.add(this.convertValueIfNeeded(data));
            }
            return list;
        }
        return MBeans.convertJRockitValueIfNeeded(value);
    }

    private static Object convertJRockitValueIfNeeded(Object value) {
        if (value instanceof double[]) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (double data : (double[])value) {
                list.add(data);
            }
            return list;
        }
        if (value instanceof int[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int data : (int[])value) {
                list.add(data);
            }
            return list;
        }
        return value;
    }

    private static List<Object> getConvertedAttributes(List<String> mbeanAttributes) {
        MBeans.initJRockitMBeansIfNeeded();
        ArrayList<Object> result = new ArrayList<Object>();
        List<MBeanServer> mBeanServers = MBeans.getMBeanServers();
        for (String mbeansAttribute : mbeanAttributes) {
            int lastIndexOfPoint = mbeansAttribute.lastIndexOf(46);
            if (lastIndexOfPoint <= 0) {
                throw new IllegalArgumentException(mbeansAttribute);
            }
            String name = mbeansAttribute.substring(0, lastIndexOfPoint);
            String attribute = mbeansAttribute.substring(lastIndexOfPoint + 1);
            if ("password".equalsIgnoreCase(attribute)) {
                throw new IllegalArgumentException(name + '.' + attribute);
            }
            InstanceNotFoundException instanceNotFoundException = null;
            for (MBeanServer mbeanServer : mBeanServers) {
                try {
                    MBeans mbeans = new MBeans(mbeanServer);
                    Object jmxValue = mbeans.convertValueIfNeeded(mbeans.getAttribute(new ObjectName(name), attribute));
                    result.add(jmxValue);
                    instanceNotFoundException = null;
                    break;
                }
                catch (InstanceNotFoundException e) {
                    instanceNotFoundException = e;
                }
                catch (JMException e) {
                    throw new IllegalArgumentException(name + '.' + attribute, e);
                }
            }
            if (instanceNotFoundException == null) continue;
            throw new IllegalArgumentException(name + '.' + attribute, instanceNotFoundException);
        }
        return result;
    }

    static String getConvertedAttributes(String jmxValueParameter) {
        List<String> mbeanAttributes = Arrays.asList(jmxValueParameter.split("[|]"));
        List<Object> jmxValues = MBeans.getConvertedAttributes(mbeanAttributes);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object jmxValue : jmxValues) {
            if (first) {
                first = false;
            } else {
                sb.append('|');
            }
            sb.append(jmxValue);
        }
        return sb.toString();
    }

    private String getAttributeDescription(String name, MBeanAttributeInfo[] attributeInfos) {
        for (MBeanAttributeInfo attributeInfo : attributeInfos) {
            if (!name.equals(attributeInfo.getName())) continue;
            String attributeDescription = this.formatDescription(attributeInfo.getDescription());
            if (attributeDescription == null || name.equals(attributeDescription) || attributeDescription.length() == 0) {
                return null;
            }
            return attributeDescription;
        }
        return null;
    }

    static MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private static List<MBeanServer> getMBeanServers() {
        return MBeanServerFactory.findMBeanServer(null);
    }
}

