/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import java.awt.Image;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.PdfAbstractTableReport;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.PdfJavaInformationsReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfJobInformationsReport
extends PdfAbstractTableReport {
    private static final long ONE_DAY_MILLIS = 86400000L;
    private final List<JobInformations> jobInformationsList;
    private final Counter jobCounter;
    private final DateFormat fireTimeFormat = I18N.createDateAndTimeFormat();
    private final DateFormat durationFormat = I18N.createDurationFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();

    PdfJobInformationsReport(List<JobInformations> jobInformationsList, Counter rangeJobCounter, Document document) {
        super(document);
        assert (jobInformationsList != null);
        assert (rangeJobCounter != null);
        this.jobInformationsList = jobInformationsList;
        this.jobCounter = rangeJobCounter;
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        this.writeHeader();
        for (JobInformations jobInformations : this.jobInformationsList) {
            this.nextRow();
            this.writeJobInformations(jobInformations);
        }
        this.addTableToDocument();
        this.addConfigurationReference();
    }

    private void addConfigurationReference() throws DocumentException {
        Anchor quartzAnchor = new Anchor("Configuration reference", PdfFonts.BLUE.getFont());
        quartzAnchor.setName("Quartz configuration reference");
        quartzAnchor.setReference("http://www.quartz-scheduler.org/docs/index.html");
        quartzAnchor.setFont(PdfFonts.BLUE.getFont());
        Paragraph quartzParagraph = new Paragraph();
        quartzParagraph.add((Object)quartzAnchor);
        quartzParagraph.setAlignment(2);
        this.addToDocument((Element)quartzParagraph);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 2);
        relativeWidths[1] = 3;
        relativeWidths[2] = 5;
        relativeWidths[headers.size() - 1] = 1;
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfJobInformationsReport.getString("JobGroup"));
        headers.add(PdfJobInformationsReport.getString("JobName"));
        headers.add(PdfJobInformationsReport.getString("JobClassName"));
        headers.add(PdfJobInformationsReport.getString("JobMeanTime"));
        headers.add(PdfJobInformationsReport.getString("JobElapsedTime"));
        headers.add(PdfJobInformationsReport.getString("JobPreviousFireTime"));
        headers.add(PdfJobInformationsReport.getString("JobNextFireTime"));
        headers.add(PdfJobInformationsReport.getString("JobPeriodOrCronExpression"));
        headers.add(PdfJobInformationsReport.getString("JobPaused"));
        return headers;
    }

    private void writeJobInformations(JobInformations jobInformations) throws BadElementException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(jobInformations.getGroup());
        this.addCell(jobInformations.getName());
        this.addCell(jobInformations.getJobClassName());
        defaultCell.setHorizontalAlignment(2);
        CounterRequest counterRequest = this.getCounterRequest(jobInformations);
        this.addCell(this.formatDuration(counterRequest.getMean()));
        this.writeJobTimes(jobInformations, counterRequest);
        defaultCell.setHorizontalAlignment(1);
        if (jobInformations.isPaused()) {
            this.addCell(PdfJobInformationsReport.getString("oui"));
        } else {
            this.addCell(PdfJobInformationsReport.getString("non"));
        }
    }

    private String formatDuration(int durationAsMillis) {
        long duration = 1L * (long)durationAsMillis;
        return this.durationFormat.format(new Date(duration));
    }

    private void writeJobTimes(JobInformations jobInformations, CounterRequest counterRequest) throws BadElementException, IOException {
        long elapsedTime = jobInformations.getElapsedTime();
        if (elapsedTime >= 0L) {
            Phrase elapsedTimePhrase = new Phrase(this.durationFormat.format(elapsedTime), this.cellFont);
            com.lowagie.text.Image memoryImage = com.lowagie.text.Image.getInstance((Image)PdfJavaInformationsReport.Bar.toBar(100.0 * (double)elapsedTime / (double)counterRequest.getMean()), null);
            memoryImage.scalePercent(47.0f);
            elapsedTimePhrase.add((Object)"\n");
            elapsedTimePhrase.add((Object)new Chunk(memoryImage, 0.0f, 0.0f));
            this.addCell(elapsedTimePhrase);
        } else {
            this.addCell("");
        }
        if (jobInformations.getPreviousFireTime() != null) {
            this.addCell(this.fireTimeFormat.format(jobInformations.getPreviousFireTime()));
        } else {
            this.addCell("");
        }
        if (jobInformations.getNextFireTime() != null) {
            this.addCell(this.fireTimeFormat.format(jobInformations.getNextFireTime()));
        } else {
            this.addCell("");
        }
        if (jobInformations.getRepeatInterval() > 0L && jobInformations.getRepeatInterval() < 86400000L) {
            this.addCell(this.durationFormat.format(new Date(jobInformations.getRepeatInterval())));
        } else if (jobInformations.getCronExpression() != null) {
            this.addCell(jobInformations.getCronExpression());
        } else {
            this.addCell("");
        }
    }

    private CounterRequest getCounterRequest(JobInformations jobInformations) {
        String jobFullName = jobInformations.getGroup() + '.' + jobInformations.getName();
        CounterRequest result = this.jobCounter.getCounterRequestByName(jobFullName);
        assert (result != null);
        return result;
    }
}

