/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.List;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlCounterErrorReport
extends HtmlAbstractReport {
    private final Counter counter;
    private final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 2, I18N.getCurrentLocale());

    HtmlCounterErrorReport(Counter counter, Writer writer) {
        super(writer);
        assert (counter != null);
        assert (counter.isErrorCounter());
        this.counter = counter;
    }

    @Override
    void toHtml() throws IOException {
        List<CounterError> errors = this.counter.getErrors();
        if (errors.isEmpty()) {
            this.writeln("#Aucune_erreur#");
        } else {
            this.writeErrors(errors);
        }
    }

    private void writeErrors(List<CounterError> errors) throws IOException {
        assert (errors != null);
        boolean displayUser = HtmlCounterErrorReport.shouldDisplayUser(errors);
        boolean displayHttpRequest = HtmlCounterErrorReport.shouldDisplayHttpRequest(errors);
        if (errors.size() >= 100) {
            this.write("<div class='severe' align='left'>");
            this.writeln(HtmlCounterErrorReport.getFormattedString("Dernieres_erreurs_seulement", 100));
            this.write("</div>");
        }
        String tableName = this.counter.getName();
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='" + tableName + "'>");
        this.write("<thead><tr><th class='sorttable_date'>#Date#</th>");
        if (displayHttpRequest) {
            this.write("<th>#Requete#</th>");
        }
        if (displayUser) {
            this.write("<th>#Utilisateur#</th>");
        }
        this.write("<th>#Erreur#</th>");
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (CounterError error : errors) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeError(error, displayUser, displayHttpRequest);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
    }

    private void writeError(CounterError error, boolean displayUser, boolean displayHttpRequest) throws IOException {
        this.write("<td align='right'>");
        this.write(this.dateTimeFormat.format(error.getDate()));
        this.write("</td><td>");
        if (displayHttpRequest) {
            if (error.getHttpRequest() == null) {
                this.write("&nbsp;");
            } else {
                this.writeDirectly(HtmlCounterErrorReport.htmlEncode(error.getHttpRequest()));
            }
            this.write("</td><td>");
        }
        if (displayUser) {
            if (error.getRemoteUser() == null) {
                this.write("&nbsp;");
            } else {
                this.writeDirectly(HtmlCounterErrorReport.htmlEncode(error.getRemoteUser()));
            }
            this.write("</td><td>");
        }
        if (error.getStackTrace() != null) {
            this.writeln("<a class='tooltip'>");
            this.writeln("<em>");
            this.writeDirectly(HtmlCounterErrorReport.htmlEncode(error.getStackTrace()));
            this.writeln("</em>");
            this.writeDirectly(HtmlCounterErrorReport.htmlEncode(error.getMessage()));
            this.writeln("</a>");
        } else {
            this.writeDirectly(HtmlCounterErrorReport.htmlEncode(error.getMessage()));
        }
        this.write("</td>");
    }

    static boolean shouldDisplayUser(List<CounterError> errors) {
        for (CounterError error : errors) {
            if (error.getRemoteUser() == null) continue;
            return true;
        }
        return false;
    }

    static boolean shouldDisplayHttpRequest(List<CounterError> errors) {
        for (CounterError error : errors) {
            if (error.getHttpRequest() == null) continue;
            return true;
        }
        return false;
    }
}

