/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.HtmlCounterErrorReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCounterErrorReport {
    private final Counter counter;
    private final Document document;
    private final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 2, I18N.getCurrentLocale());
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font severeFont = PdfFonts.SEVERE_CELL.getFont();
    private final Font normalFont = PdfFonts.NORMAL.getFont();
    private PdfPTable currentTable;

    PdfCounterErrorReport(Counter counter, Document document) {
        assert (counter != null);
        assert (counter.isErrorCounter());
        assert (document != null);
        this.counter = counter;
        this.document = document;
    }

    void toPdf() throws DocumentException {
        List<CounterError> errors = this.counter.getErrors();
        if (errors.isEmpty()) {
            this.document.add((Element)new Phrase(PdfCounterErrorReport.getI18nString("Aucune_erreur"), this.normalFont));
        } else {
            this.writeErrors(errors);
        }
    }

    private void writeErrors(List<CounterError> errors) throws DocumentException {
        assert (errors != null);
        boolean displayUser = HtmlCounterErrorReport.shouldDisplayUser(errors);
        boolean displayHttpRequest = HtmlCounterErrorReport.shouldDisplayHttpRequest(errors);
        if (errors.size() >= 100) {
            this.document.add((Element)new Phrase(I18N.getFormattedString("Dernieres_erreurs_seulement", 100) + '\n', this.severeFont));
        }
        this.writeHeader(displayUser, displayHttpRequest);
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (CounterError error : errors) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeError(error, displayUser, displayHttpRequest);
        }
        this.document.add((Element)this.currentTable);
    }

    private void writeHeader(boolean displayUser, boolean displayHttpRequest) throws DocumentException {
        List<String> headers = this.createHeaders(displayUser, displayHttpRequest);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        if (displayHttpRequest) {
            relativeWidths[1] = 4;
        }
        relativeWidths[headers.size() - 1] = 4;
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders(boolean displayUser, boolean displayHttpRequest) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfCounterErrorReport.getI18nString("Date"));
        if (displayHttpRequest) {
            headers.add(PdfCounterErrorReport.getI18nString("Requete"));
        }
        if (displayUser) {
            headers.add(PdfCounterErrorReport.getI18nString("Utilisateur"));
        }
        headers.add(PdfCounterErrorReport.getI18nString("Erreur"));
        return headers;
    }

    private void writeError(CounterError error, boolean displayUser, boolean displayHttpRequest) {
        this.getDefaultCell().setHorizontalAlignment(2);
        this.addCell(this.dateTimeFormat.format(error.getDate()));
        this.getDefaultCell().setHorizontalAlignment(0);
        if (displayHttpRequest) {
            if (error.getHttpRequest() == null) {
                this.addCell("");
            } else {
                this.addCell(error.getHttpRequest());
            }
        }
        if (displayUser) {
            if (error.getRemoteUser() == null) {
                this.addCell("");
            } else {
                this.addCell(error.getRemoteUser());
            }
        }
        this.addCell(error.getMessage());
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

