/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JobGlobalListener;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.JsfActionHelper;
import net.bull.javamelody.JspWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Log4JAppender;
import net.bull.javamelody.LogbackAppender;
import net.bull.javamelody.LoggingHandler;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.MonitoringInitialContextFactory;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterContext {
    private static final boolean MOJARRA_AVAILABLE = FilterContext.isMojarraAvailable();
    private final Collector collector;
    private final Timer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FilterContext() {
        block8: {
            boolean initOk = false;
            this.timer = new Timer("javamelody" + Parameters.getContextPath(Parameters.getServletContext()).replace('/', ' '), true);
            try {
                FilterContext.logSystemInformationsAndParameters();
                FilterContext.initLogs();
                if (Boolean.parseBoolean(Parameters.getParameter(Parameter.CONTEXT_FACTORY_ENABLED))) {
                    MonitoringInitialContextFactory.init();
                }
                JdbcWrapper.SINGLETON.initServletContext(Parameters.getServletContext());
                if (!Parameters.isNoDatabase()) {
                    JdbcWrapper.SINGLETON.rebindDataSources();
                } else {
                    JdbcWrapper.SINGLETON.stop();
                }
                if (JobInformations.QUARTZ_AVAILABLE) {
                    JobGlobalListener.initJobGlobalListener();
                }
                if (MOJARRA_AVAILABLE) {
                    JsfActionHelper.initJsfActionListener();
                }
                List<Counter> counters = FilterContext.initCounters();
                String application = Parameters.getCurrentApplication();
                this.collector = new Collector(application, counters);
                this.initCollect();
                initOk = true;
                Object var5_4 = null;
                if (initOk) break block8;
                this.timer.cancel();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!initOk) {
                    this.timer.cancel();
                    LOG.debug("JavaMelody init failed");
                }
                throw throwable;
            }
            LOG.debug("JavaMelody init failed");
            {
            }
        }
    }

    private static List<Counter> initCounters() {
        List<Counter> counters;
        Counter sqlCounter = JdbcWrapper.SINGLETON.getSqlCounter();
        Counter httpCounter = new Counter("http", "dbweb.png", sqlCounter);
        Counter errorCounter = new Counter("error", "error.png");
        errorCounter.setMaxRequestsCount(250);
        Counter ejbCounter = MonitoringProxy.getEjbCounter();
        Counter springCounter = MonitoringProxy.getSpringCounter();
        Counter guiceCounter = MonitoringProxy.getGuiceCounter();
        Counter servicesCounter = MonitoringProxy.getServicesCounter();
        Counter strutsCounter = MonitoringProxy.getStrutsCounter();
        Counter jsfCounter = MonitoringProxy.getJsfCounter();
        Counter logCounter = LoggingHandler.getLogCounter();
        Counter jspCounter = JspWrapper.getJspCounter();
        if (JobInformations.QUARTZ_AVAILABLE) {
            Counter jobCounter = JobGlobalListener.getJobCounter();
            counters = Arrays.asList(httpCounter, sqlCounter, ejbCounter, springCounter, guiceCounter, servicesCounter, strutsCounter, jsfCounter, jspCounter, errorCounter, logCounter, jobCounter);
        } else {
            counters = Arrays.asList(httpCounter, sqlCounter, ejbCounter, springCounter, guiceCounter, servicesCounter, strutsCounter, jsfCounter, jspCounter, errorCounter, logCounter);
        }
        FilterContext.setRequestTransformPatterns(counters);
        String displayedCounters = Parameters.getParameter(Parameter.DISPLAYED_COUNTERS);
        if (displayedCounters == null) {
            httpCounter.setDisplayed(true);
            sqlCounter.setDisplayed(!Parameters.isNoDatabase());
            errorCounter.setDisplayed(true);
            logCounter.setDisplayed(true);
            ejbCounter.setDisplayed(ejbCounter.isUsed());
            springCounter.setDisplayed(springCounter.isUsed());
            guiceCounter.setDisplayed(guiceCounter.isUsed());
            servicesCounter.setDisplayed(servicesCounter.isUsed());
            strutsCounter.setDisplayed(strutsCounter.isUsed());
            jsfCounter.setDisplayed(jsfCounter.isUsed());
            jspCounter.setDisplayed(jspCounter.isUsed());
        } else {
            FilterContext.setDisplayedCounters(counters, displayedCounters);
        }
        LOG.debug("counters initialized");
        return counters;
    }

    private static void setRequestTransformPatterns(List<Counter> counters) {
        for (Counter counter : counters) {
            Parameter parameter = Parameter.valueOfIgnoreCase(counter.getName() + "_TRANSFORM_PATTERN");
            if (Parameters.getParameter(parameter) == null) continue;
            Pattern pattern = Pattern.compile(Parameters.getParameter(parameter));
            counter.setRequestTransformPattern(pattern);
        }
    }

    private static void setDisplayedCounters(List<Counter> counters, String displayedCounters) {
        for (Counter counter : counters) {
            if (counter.isJobCounter()) {
                counter.setDisplayed(true);
                continue;
            }
            counter.setDisplayed(false);
        }
        if (displayedCounters.length() != 0) {
            for (String displayedCounter : displayedCounters.split(",")) {
                String displayedCounterName = displayedCounter.trim();
                boolean found = false;
                for (Counter counter : counters) {
                    if (!displayedCounterName.equalsIgnoreCase(counter.getName())) continue;
                    counter.setDisplayed(true);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Unknown counter: " + displayedCounterName);
            }
        }
    }

    private void initCollect() {
        try {
            Class.forName("org.jrobin.core.RrdDb");
            Class.forName("org.jrobin.core.RrdException");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("jrobin classes unavailable: collect of data is disabled");
            return;
        }
        try {
            JRobin.setJRobinThreadName("jrobin " + Parameters.getContextPath(Parameters.getServletContext()).replace('/', ' '));
        }
        catch (IOException e) {
            LOG.warn(e.toString(), e);
        }
        int resolutionSeconds = Parameters.getResolutionSeconds();
        int periodMillis = resolutionSeconds * 1000;
        CollectTimerTask task = new CollectTimerTask(this.collector);
        this.timer.schedule((TimerTask)task, periodMillis, (long)periodMillis);
        LOG.debug("collect task scheduled every " + resolutionSeconds + 's');
        this.collector.collectLocalContextWithoutErrors();
        LOG.debug("first collect of data done");
        if (Parameters.getParameter(Parameter.MAIL_SESSION) != null && Parameters.getParameter(Parameter.ADMIN_EMAILS) != null) {
            MailReport.scheduleReportMailForLocalServer(this.collector, this.timer);
            LOG.debug("mail reports scheduled for " + Parameters.getParameter(Parameter.ADMIN_EMAILS));
        }
    }

    private static void initLogs() {
        LoggingHandler.getSingleton().register();
        if (LOG.LOG4J_ENABLED) {
            Log4JAppender.getSingleton().register();
        }
        if (LOG.LOGBACK_ENABLED) {
            LogbackAppender.getSingleton().register();
        }
        LOG.debug("log listeners initialized");
    }

    private static boolean isMojarraAvailable() {
        try {
            Class.forName("com.sun.faces.application.ActionListenerImpl");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static void logSystemInformationsAndParameters() {
        LOG.debug("OS: " + System.getProperty("os.name") + ' ' + System.getProperty("sun.os.patch.level") + ", " + System.getProperty("os.arch") + '/' + System.getProperty("sun.arch.data.model"));
        LOG.debug("Java: " + System.getProperty("java.runtime.name") + ", " + System.getProperty("java.runtime.version"));
        LOG.debug("Server: " + Parameters.getServletContext().getServerInfo());
        LOG.debug("Webapp context: " + Parameters.getContextPath(Parameters.getServletContext()));
        LOG.debug("JavaMelody version: " + Parameters.JAVAMELODY_VERSION);
        LOG.debug("Host: " + Parameters.getHostName() + '@' + Parameters.getHostAddress());
        for (Parameter parameter : Parameter.values()) {
            String value = Parameters.getParameter(parameter);
            if (value == null) continue;
            LOG.debug("parameter defined: " + parameter.getCode() + '=' + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        try {
            try {
                if (this.collector != null) {
                    new MonitoringController(this.collector, null).writeHtmlToLastShutdownFile();
                }
                Object var2_1 = null;
                JdbcWrapper.SINGLETON.stop();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                JdbcWrapper.SINGLETON.stop();
                FilterContext.deregisterJdbcDriver();
                FilterContext.deregisterLogs();
                if (JobInformations.QUARTZ_AVAILABLE) {
                    JobGlobalListener.destroyJobGlobalListener();
                }
                throw throwable;
            }
            FilterContext.deregisterJdbcDriver();
            FilterContext.deregisterLogs();
            if (JobInformations.QUARTZ_AVAILABLE) {
                JobGlobalListener.destroyJobGlobalListener();
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            MonitoringInitialContextFactory.stop();
            if (this.timer != null) {
                this.timer.cancel();
            }
            if (this.collector != null) {
                this.collector.stop();
            }
            Collector.stopJRobin();
            Collector.detachVirtualMachine();
            throw throwable;
        }
        MonitoringInitialContextFactory.stop();
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.collector != null) {
            this.collector.stop();
        }
        Collector.stopJRobin();
        Collector.detachVirtualMachine();
    }

    private static void deregisterJdbcDriver() {
        Class<FilterContext> classe = FilterContext.class;
        String packageName = classe.getName().substring(0, classe.getName().length() - classe.getSimpleName().length() - 1);
        for (Driver driver : Collections.list(DriverManager.getDrivers())) {
            if (!driver.getClass().getName().startsWith(packageName)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static void deregisterLogs() {
        if (LOG.LOGBACK_ENABLED) {
            LogbackAppender.getSingleton().deregister();
        }
        if (LOG.LOG4J_ENABLED) {
            Log4JAppender.getSingleton().deregister();
        }
        LoggingHandler.getSingleton().deregister();
    }

    Collector getCollector() {
        return this.collector;
    }

    Timer getTimer() {
        return this.timer;
    }

    private static final class CollectTimerTask
    extends TimerTask {
        private final Collector collector;

        CollectTimerTask(Collector collector) {
            this.collector = collector;
        }

        public void run() {
            this.collector.collectLocalContextWithoutErrors();
        }
    }
}

