/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JndiBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlJndiTreeReport {
    private final List<JndiBinding> jndiBindings;
    private final String path;
    private final Writer writer;

    HtmlJndiTreeReport(List<JndiBinding> jndiBindings, String path, Writer writer) {
        assert (jndiBindings != null);
        assert (writer != null);
        this.jndiBindings = jndiBindings;
        this.path = JndiBinding.normalizePath(path);
        this.writer = writer;
    }

    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeln("<img src='?resource=jndi.png' width='24' height='24' alt='#Arbre_JNDI#' />&nbsp;");
        if (this.path.length() == 0) {
            this.writeln("<b>#Arbre_JNDI#</b>");
        } else {
            this.writer.write("<b>" + I18N.getFormattedString("Arbre_JNDI_pour_contexte", HtmlJndiTreeReport.htmlEncode(this.path)) + "</b>\n");
        }
        this.writeTable();
    }

    private void writeTable() throws IOException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Arbre_JNDI#'>");
        this.write("<thead><tr><th>#Nom#</th><th>#Type#</th>");
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (JndiBinding binding : this.jndiBindings) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeBinding(binding);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
    }

    private void writeBinding(JndiBinding binding) throws IOException {
        String name = binding.getName();
        this.write("<td>");
        String encodedName = HtmlJndiTreeReport.htmlEncode(name);
        String className = binding.getClassName();
        String contextPath = binding.getContextPath();
        if (contextPath != null) {
            this.writer.write("<a href=\"?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(contextPath) + "\">");
            this.writer.write("<img width='16' height='16' src='?resource=folder.png' alt='" + encodedName + "' />&nbsp;");
            this.writer.write(encodedName);
            this.writer.write("</a>");
        } else {
            this.writer.write(encodedName);
        }
        this.write("</td>");
        this.write("<td>");
        this.writer.write(className != null ? HtmlJndiTreeReport.htmlEncode(className) : "&nbsp;");
        this.write("</td>");
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writer.write("<a href='?#systeminfo'>");
        this.writeln("<img src='?resource=action_home.png' alt='#Page_principale#'/> #Page_principale#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(this.path) + "'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

