/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.SessionInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionListener
implements HttpSessionListener,
HttpSessionActivationListener,
ServletContextListener,
Serializable {
    private static final String SESSION_ACTIVATION_KEY = "javamelody.sessionActivation";
    private static final long serialVersionUID = -1624944319058843901L;
    private static final AtomicInteger SESSION_COUNT = new AtomicInteger();
    private static final List<String> CONTEXT_PATHS = new ArrayList<String>();
    private static final ConcurrentMap<String, HttpSession> SESSION_MAP_BY_ID = new ConcurrentHashMap<String, HttpSession>();
    private static boolean instanceCreated;
    private boolean instanceEnabled;

    public SessionListener() {
        if (instanceCreated) {
            this.instanceEnabled = false;
        } else {
            this.instanceEnabled = true;
            SessionListener.setInstanceCreated(true);
        }
    }

    public SessionListener(boolean instanceEnabled) {
        this.instanceEnabled = instanceEnabled;
        SessionListener.setInstanceCreated(true);
    }

    private static void setInstanceCreated(boolean newInstanceCreated) {
        instanceCreated = newInstanceCreated;
    }

    static int getSessionCount() {
        if (!instanceCreated) {
            return -1;
        }
        return SESSION_COUNT.get();
    }

    static long getSessionAgeSum() {
        if (!instanceCreated) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        long result = 0L;
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            try {
                result += now - session.getCreationTime();
            }
            catch (Exception e) {}
        }
        return result;
    }

    static void invalidateAllSessions() {
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            try {
                session.invalidate();
            }
            catch (Exception e) {}
        }
    }

    static void invalidateSession(String sessionId) {
        HttpSession session = (HttpSession)SESSION_MAP_BY_ID.get(sessionId);
        if (session != null) {
            session.invalidate();
        }
    }

    static List<SessionInformations> getAllSessionsInformations() {
        Collection sessions = SESSION_MAP_BY_ID.values();
        ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>(sessions.size());
        for (HttpSession session : sessions) {
            try {
                sessionsInformations.add(new SessionInformations(session, false));
            }
            catch (Exception e) {}
        }
        SessionListener.sortSessions(sessionsInformations);
        return Collections.unmodifiableList(sessionsInformations);
    }

    static List<SessionInformations> sortSessions(List<SessionInformations> sessionsInformations) {
        if (sessionsInformations.size() > 1) {
            Collections.sort(sessionsInformations, Collections.reverseOrder(new SessionInformationsComparator()));
        }
        return sessionsInformations;
    }

    static SessionInformations getSessionInformationsBySessionId(String sessionId) {
        HttpSession session = (HttpSession)SESSION_MAP_BY_ID.get(sessionId);
        if (session == null) {
            return null;
        }
        return new SessionInformations(session, true);
    }

    public void contextInitialized(ServletContextEvent event) {
        String contextPath = event.getServletContext().getContextPath();
        if (!this.instanceEnabled) {
            if (!CONTEXT_PATHS.contains(contextPath)) {
                this.instanceEnabled = true;
            } else {
                return;
            }
        }
        CONTEXT_PATHS.add(contextPath);
        System.getProperty("java.io.tmpdir");
        Parameters.initialize(event.getServletContext());
        LOG.debug("JavaMelody listener init started");
        JdbcWrapper jdbcWrapper = JdbcWrapper.SINGLETON;
        jdbcWrapper.initServletContext(event.getServletContext());
        if (!Parameters.isNoDatabase()) {
            jdbcWrapper.rebindDataSources();
        }
        LOG.debug("JavaMelody listener init done");
    }

    public void contextDestroyed(ServletContextEvent event) {
        SESSION_MAP_BY_ID.clear();
        SESSION_COUNT.set(0);
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        HttpSession session = event.getSession();
        if (session.getAttribute(SESSION_ACTIVATION_KEY) == this) {
            for (Map.Entry entry : SESSION_MAP_BY_ID.entrySet()) {
                HttpSession other;
                String id = (String)entry.getKey();
                if (id.equals((other = (HttpSession)entry.getValue()).getId())) continue;
                SESSION_MAP_BY_ID.remove(id);
            }
        } else {
            session.setAttribute(SESSION_ACTIVATION_KEY, (Object)this);
            SESSION_COUNT.incrementAndGet();
        }
        SESSION_MAP_BY_ID.put(session.getId(), session);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        HttpSession session = event.getSession();
        SESSION_COUNT.decrementAndGet();
        SESSION_MAP_BY_ID.remove(session.getId());
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        SESSION_COUNT.incrementAndGet();
        SESSION_MAP_BY_ID.put(event.getSession().getId(), event.getSession());
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        SESSION_COUNT.decrementAndGet();
        SESSION_MAP_BY_ID.remove(event.getSession().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSessionIfNeeded(HttpSession session) {
        if (session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                if (!SESSION_MAP_BY_ID.containsKey(session.getId())) {
                    this.sessionCreated(new HttpSessionEvent(session));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSessionIfNeeded(HttpSession session) {
        if (session != null) {
            try {
                session.getCreationTime();
            }
            catch (IllegalStateException e) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    this.sessionDestroyed(new HttpSessionEvent(session));
                }
            }
        }
    }

    void unregisterInvalidatedSessions() {
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            this.unregisterSessionIfNeeded(session);
        }
    }

    void removeAllActivationListeners() {
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            try {
                session.removeAttribute(SESSION_ACTIVATION_KEY);
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[sessionCount=" + SessionListener.getSessionCount() + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SessionInformationsComparator
    implements Comparator<SessionInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SessionInformationsComparator() {
        }

        @Override
        public int compare(SessionInformations session1, SessionInformations session2) {
            if (session1.getLastAccess().before(session2.getLastAccess())) {
                return 1;
            }
            if (session1.getLastAccess().after(session2.getLastAccess())) {
                return -1;
            }
            return 0;
        }
    }
}

