/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlController {
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;
    private final String messageForReport;
    private final String anchorNameForRedirect;

    HtmlController(Collector collector, CollectorServer collectorServer, String messageForReport, String anchorNameForRedirect) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.messageForReport = messageForReport;
        this.anchorNameForRedirect = anchorNameForRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        String part = httpRequest.getParameter("part");
        if (!this.isFromCollectorServer() && (part == null || "currentRequests".equalsIgnoreCase(part) || "graph".equalsIgnoreCase(part) || "counterSummaryPerClass".equalsIgnoreCase(part))) {
            this.collector.collectLocalContextWithoutErrors();
        }
        httpResponse.setContentType("text/html; charset=UTF-8");
        BufferedWriter writer = HtmlController.getWriter(httpResponse);
        try {
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, javaInformationsList, range, (Writer)writer);
            if (part == null) {
                htmlReport.toHtml(this.messageForReport, this.anchorNameForRedirect);
            } else if ("threadsDump".equalsIgnoreCase(part)) {
                httpResponse.setContentType("text/plain; charset=UTF-8");
                htmlReport.writeThreadsDump();
            } else {
                this.doHtmlPart(httpRequest, part, htmlReport);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    static BufferedWriter getWriter(HttpServletResponse httpResponse) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)httpResponse.getOutputStream(), "UTF-8"));
    }

    private void doHtmlPart(HttpServletRequest httpRequest, String part, HtmlReport htmlReport) throws IOException {
        if ("graph".equalsIgnoreCase(part)) {
            String graphName = httpRequest.getParameter("graph");
            htmlReport.writeRequestAndGraphDetail(graphName);
        } else if ("usages".equalsIgnoreCase(part)) {
            String graphName = httpRequest.getParameter("graph");
            htmlReport.writeRequestUsages(graphName);
        } else if ("currentRequests".equalsIgnoreCase(part)) {
            boolean withoutHeaders = "htmlbody".equalsIgnoreCase(httpRequest.getParameter("format"));
            this.doCurrentRequests(htmlReport, withoutHeaders);
        } else if ("threads".equalsIgnoreCase(part)) {
            htmlReport.writeAllThreadsAsPart();
        } else if ("counterSummaryPerClass".equalsIgnoreCase(part)) {
            String counterName = httpRequest.getParameter("counter");
            String requestId = httpRequest.getParameter("graph");
            htmlReport.writeCounterSummaryPerClass(counterName, requestId);
        } else {
            this.doHtmlPartForSystemActions(httpRequest, part, htmlReport);
        }
    }

    private void doHtmlPartForSystemActions(HttpServletRequest httpRequest, String part, HtmlReport htmlReport) throws IOException {
        if ("sessions".equalsIgnoreCase(part)) {
            this.doSessions(htmlReport, httpRequest.getParameter("sessionId"));
        } else if ("heaphisto".equalsIgnoreCase(part)) {
            this.doHeapHisto(htmlReport);
        } else if ("processes".equalsIgnoreCase(part)) {
            this.doProcesses(htmlReport);
        } else if ("database".equalsIgnoreCase(part)) {
            int requestIndex = DatabaseInformations.parseRequestIndex(httpRequest.getParameter("request"));
            this.doDatabase(htmlReport, requestIndex);
        } else if ("connections".equalsIgnoreCase(part)) {
            boolean withoutHeaders = "htmlbody".equalsIgnoreCase(httpRequest.getParameter("format"));
            this.doConnections(htmlReport, withoutHeaders);
        } else if ("jndi".equalsIgnoreCase(part)) {
            this.doJndi(htmlReport, httpRequest.getParameter("path"));
        } else if ("mbeans".equalsIgnoreCase(part)) {
            boolean withoutHeaders = "htmlbody".equalsIgnoreCase(httpRequest.getParameter("format"));
            this.doMBeans(htmlReport, withoutHeaders);
        } else {
            throw new IllegalArgumentException(part);
        }
    }

    private void doSessions(HtmlReport htmlReport, String sessionId) throws IOException {
        Action.checkSystemActionsEnabled();
        List<SessionInformations> sessionsInformations = !this.isFromCollectorServer() ? (sessionId == null ? SessionListener.getAllSessionsInformations() : Collections.singletonList(SessionListener.getSessionInformationsBySessionId(sessionId))) : this.collectorServer.collectSessionInformations(this.collector.getApplication(), sessionId);
        if (sessionId == null || sessionsInformations.isEmpty()) {
            htmlReport.writeSessions(sessionsInformations, this.messageForReport, "sessions");
        } else {
            SessionInformations sessionInformation = sessionsInformations.get(0);
            htmlReport.writeSessionDetail(sessionId, sessionInformation);
        }
    }

    private void doCurrentRequests(HtmlReport htmlReport, boolean withoutHeaders) throws IOException {
        if (this.isFromCollectorServer()) {
            throw new IllegalStateException();
        }
        htmlReport.writeAllCurrentRequestsAsPart(withoutHeaders);
    }

    private void doHeapHisto(HtmlReport htmlReport) throws IOException {
        HeapHistogram heapHistogram;
        Action.checkSystemActionsEnabled();
        try {
            heapHistogram = !this.isFromCollectorServer() ? VirtualMachine.createHeapHistogram() : this.collectorServer.collectHeapHistogram(this.collector.getApplication());
        }
        catch (Exception e) {
            LOG.warn("heaphisto report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
            return;
        }
        htmlReport.writeHeapHistogram(heapHistogram, this.messageForReport, "heaphisto");
    }

    private void doProcesses(HtmlReport htmlReport) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeProcesses(ProcessInformations.buildProcessInformations());
        }
        catch (Exception e) {
            LOG.warn("processes report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    private void doDatabase(HtmlReport htmlReport, int index) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            DatabaseInformations databaseInformations = !this.isFromCollectorServer() ? new DatabaseInformations(index) : this.collectorServer.collectDatabaseInformations(this.collector.getApplication(), index);
            htmlReport.writeDatabase(databaseInformations);
        }
        catch (Exception e) {
            LOG.warn("database report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    private void doConnections(HtmlReport htmlReport, boolean withoutHeaders) throws IOException {
        Action.checkSystemActionsEnabled();
        htmlReport.writeConnections(JdbcWrapper.getConnectionInformationsList(), withoutHeaders);
    }

    private void doJndi(HtmlReport htmlReport, String path) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeJndi(path);
        }
        catch (Exception e) {
            LOG.warn("jndi report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    private void doMBeans(HtmlReport htmlReport, boolean withoutHeaders) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeMBeans(withoutHeaders);
        }
        catch (Exception e) {
            LOG.warn("mbeans report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHtmlToLastShutdownFile() {
        try {
            File dir = Parameters.getStorageDirectory(this.collector.getApplication());
            if (!dir.mkdirs() && !dir.exists()) {
                throw new IOException("JavaMelody directory can't be created: " + dir.getPath());
            }
            File lastShutdownFile = new File(dir, "last_shutdown.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(lastShutdownFile));
            try {
                JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
                HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, Collections.singletonList(javaInformations), Period.JOUR, (Writer)writer);
                htmlReport.writeLastShutdown();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                writer.close();
                throw throwable;
            }
            writer.close();
            {
            }
        }
        catch (IOException e) {
            LOG.warn("exception while writing the last shutdown report", e);
        }
    }

    private boolean isFromCollectorServer() {
        return this.collectorServer != null;
    }
}

