/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CustomResourceFilter
implements Filter {
    private final Map<String, String> customResources = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        ArrayList<String> parameterNames = Collections.list(filterConfig.getInitParameterNames());
        for (String parameterName : parameterNames) {
            this.customResources.put(parameterName, filterConfig.getInitParameter(parameterName));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String resource = request.getParameter("resource");
        if (resource != null && this.customResources.get(resource) != null) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.addHeader("Cache-Control", "max-age=3600");
            httpResponse.setContentType("text/css");
            String customResource = this.customResources.get(resource);
            request.getRequestDispatcher(customResource).include(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

