/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameters;

public class JdbcDriver
implements Driver {
    static final JdbcDriver SINGLETON = new JdbcDriver();

    public Connection connect(String url, Properties info) throws SQLException {
        String proxiedDriver = info.getProperty("driver");
        if (proxiedDriver == null) {
            return null;
        }
        try {
            Class.forName(proxiedDriver);
        }
        catch (ClassNotFoundException e) {
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        Properties tmp = (Properties)info.clone();
        tmp.remove("driver");
        Parameters.initJdbcDriverParameters(url, tmp);
        return JdbcWrapper.SINGLETON.createConnectionProxy(DriverManager.getConnection(url, tmp));
    }

    public boolean acceptsURL(String url) throws SQLException {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().endsWith("dbcp.BasicDataSource")) continue;
            return false;
        }
        return true;
    }

    public int getMajorVersion() {
        return -1;
    }

    public int getMinorVersion() {
        return -1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[lastConnectUrl=" + Parameters.getLastConnectUrl() + ", lastConnectInfo=" + Parameters.getLastConnectInfo() + ']';
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("global");
    }

    static {
        try {
            DriverManager.registerDriver(SINGLETON);
            LOG.debug("JDBC driver registered");
            for (Driver driver : Collections.list(DriverManager.getDrivers())) {
                if (driver == SINGLETON) continue;
                DriverManager.deregisterDriver(driver);
                DriverManager.registerDriver(driver);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

