/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfCacheInformationsReport;
import net.bull.javamelody.PdfCounterReport;
import net.bull.javamelody.PdfCounterRequestContextReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfJavaInformationsReport;
import net.bull.javamelody.PdfJobInformationsReport;
import net.bull.javamelody.PdfThreadInformationsReport;
import net.bull.javamelody.Period;
import net.bull.javamelody.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfReport {
    static final int SMALL_GRAPH_WIDTH = 200;
    static final int SMALL_GRAPH_HEIGHT = 50;
    static final int LARGE_GRAPH_WIDTH = 960;
    static final int LARGE_GRAPH_HEIGHT = 370;
    private final Collector collector;
    private final List<JavaInformations> javaInformationsList;
    private final Range range;
    private final Document document;
    private final boolean collectorServer;
    private final PdfDocumentFactory pdfDocumentFactory;
    private final Font normalFont = PdfDocumentFactory.NORMAL_FONT;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private final long start = System.currentTimeMillis();
    private Map<String, byte[]> smallGraphs;
    private Map<String, byte[]> smallOtherGraphs;
    private Map<String, byte[]> largeGraphs;

    PdfReport(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Range range, OutputStream output) throws IOException {
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (range != null);
        assert (output != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.javaInformationsList = javaInformationsList;
        this.range = range;
        try {
            this.pdfDocumentFactory = new PdfDocumentFactory(collector.getApplication(), range, output);
            this.document = this.pdfDocumentFactory.createDocument();
        }
        catch (DocumentException e) {
            throw PdfReport.createIOException(e);
        }
    }

    PdfReport(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Period period, OutputStream output) throws IOException {
        this(collector, collectorServer, javaInformationsList, period.getRange(), output);
    }

    static String getFileName(String application) {
        return "JavaMelody_" + application.replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + ".pdf";
    }

    void preInitGraphs(Map<String, byte[]> newSmallGraphs, Map<String, byte[]> newSmallOtherGraphs, Map<String, byte[]> newLargeGraphs) {
        this.smallGraphs = newSmallGraphs;
        this.smallOtherGraphs = newSmallOtherGraphs;
        this.largeGraphs = newLargeGraphs;
    }

    void toPdf() throws IOException {
        try {
            this.document.open();
            this.writeContent();
        }
        catch (DocumentException e) {
            throw PdfReport.createIOException(e);
        }
        this.document.close();
    }

    private static IOException createIOException(DocumentException e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    private void writeContent() throws IOException, DocumentException {
        this.addParagraph(this.buildSummary(), "systemmonitor.png");
        this.writeGraphs(this.collector.getCounterJRobins(), this.smallGraphs);
        List<PdfCounterReport> pdfCounterReports = this.writeCounters();
        ArrayList<PdfCounterRequestContextReport> pdfCounterRequestContextReports = new ArrayList<PdfCounterRequestContextReport>();
        if (!this.collectorServer) {
            this.addParagraph(PdfReport.getI18nString("Requetes_en_cours"), "hourglass.png");
            pdfCounterRequestContextReports.addAll(this.writeCurrentRequests(this.javaInformationsList.get(0), pdfCounterReports));
        }
        this.add((Element)new Phrase("\n", this.normalFont));
        this.addParagraph(PdfReport.getI18nString("Informations_systemes"), "systeminfo.png");
        new PdfJavaInformationsReport(this.javaInformationsList, this.document).toPdf();
        this.addParagraph(PdfReport.getI18nString("Threads"), "threads.png");
        this.writeThreads(false);
        PdfCounterReport pdfJobCounterReport = null;
        Counter rangeJobCounter = null;
        if (this.isJobEnabled()) {
            rangeJobCounter = this.collector.getRangeCounter(this.range, "job");
            this.add((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfReport.getI18nString("Jobs"), "jobs.png");
            this.writeJobs(rangeJobCounter, false);
            pdfJobCounterReport = this.writeCounter(rangeJobCounter);
        }
        if (this.isCacheEnabled()) {
            this.add((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfReport.getI18nString("Caches"), "caches.png");
            this.writeCaches(false);
        }
        this.document.newPage();
        this.addParagraph(PdfReport.getI18nString("Statistiques_detaillees"), "systemmonitor.png");
        this.writeGraphs(this.collector.getOtherJRobins(), this.smallOtherGraphs);
        this.document.newPage();
        this.writeGraphDetails();
        this.writeCountersDetails(pdfCounterReports);
        if (!this.collectorServer) {
            this.addParagraph(PdfReport.getI18nString("Requetes_en_cours_detaillees"), "hourglass.png");
            this.writeCurrentRequestsDetails(pdfCounterRequestContextReports);
        }
        this.addParagraph(PdfReport.getI18nString("Informations_systemes_detaillees"), "systeminfo.png");
        new PdfJavaInformationsReport(this.javaInformationsList, this.document).writeInformationsDetails();
        this.addParagraph(PdfReport.getI18nString("Threads_detailles"), "threads.png");
        this.writeThreads(true);
        if (this.isJobEnabled()) {
            this.add((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfReport.getI18nString("Jobs_detailles"), "jobs.png");
            this.writeJobs(rangeJobCounter, true);
            this.writeCounterDetails(pdfJobCounterReport);
        }
        if (this.isCacheEnabled()) {
            this.add((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfReport.getI18nString("Caches_detailles"), "caches.png");
            this.writeCaches(true);
        }
        this.writeDurationAndOverhead();
    }

    private String buildSummary() {
        String tmp;
        if (this.range.getPeriod() == Period.TOUT) {
            String startDate = I18N.createDateAndTimeFormat().format(this.collector.getCounters().get(0).getStartDate());
            tmp = I18N.getFormattedString("Statistiques", "JavaMelody", I18N.getCurrentDateAndTime(), startDate, this.collector.getApplication());
        } else {
            tmp = I18N.getFormattedString("Statistiques_sans_depuis", "JavaMelody", I18N.getCurrentDateAndTime(), this.collector.getApplication());
        }
        if (this.javaInformationsList.get(0).getContextDisplayName() != null) {
            return tmp + " (" + this.javaInformationsList.get(0).getContextDisplayName() + ')';
        }
        return tmp;
    }

    private void writeGraphs(Collection<JRobin> jrobins, Map<String, byte[]> mySmallGraphs) throws IOException, DocumentException {
        Paragraph jrobinParagraph = new Paragraph("", PdfDocumentFactory.getFont(9.0f, 0));
        jrobinParagraph.setAlignment(1);
        jrobinParagraph.add((Object)new Phrase("\n\n\n\n"));
        int i = 0;
        if (mySmallGraphs != null) {
            for (byte[] imageData : mySmallGraphs.values()) {
                if (i % 3 == 0 && i != 0) {
                    jrobinParagraph.add((Object)new Phrase("\n\n\n\n\n"));
                }
                Image image = Image.getInstance((byte[])imageData);
                image.scalePercent(50.0f);
                jrobinParagraph.add((Object)new Phrase(new Chunk(image, 0.0f, 0.0f)));
                jrobinParagraph.add((Object)new Phrase(" "));
                ++i;
            }
        } else {
            for (JRobin jrobin : jrobins) {
                if (!this.collector.isJRobinDisplayed(jrobin)) continue;
                if (i % 3 == 0 && i != 0) {
                    jrobinParagraph.add((Object)new Phrase("\n\n\n\n\n"));
                }
                Image image = Image.getInstance((byte[])jrobin.graph(this.range, 200, 50));
                image.scalePercent(50.0f);
                jrobinParagraph.add((Object)new Phrase(new Chunk(image, 0.0f, 0.0f)));
                jrobinParagraph.add((Object)new Phrase(" "));
                ++i;
            }
        }
        jrobinParagraph.add((Object)new Phrase("\n"));
        this.add((Element)jrobinParagraph);
    }

    private void writeGraphDetails() throws IOException, DocumentException {
        PdfPTable jrobinTable = new PdfPTable(1);
        jrobinTable.setHorizontalAlignment(1);
        jrobinTable.setWidthPercentage(100.0f);
        jrobinTable.getDefaultCell().setBorder(0);
        if (this.largeGraphs != null) {
            for (byte[] imageData : this.largeGraphs.values()) {
                Image image = Image.getInstance((byte[])imageData);
                jrobinTable.addCell(image);
            }
        } else {
            for (JRobin jrobin : this.collector.getCounterJRobins()) {
                if (!this.collector.isJRobinDisplayed(jrobin)) continue;
                Image image = Image.getInstance((byte[])jrobin.graph(this.range, 960, 370));
                jrobinTable.addCell(image);
            }
        }
        this.document.add((Element)jrobinTable);
        this.document.newPage();
    }

    private List<PdfCounterReport> writeCounters() throws IOException, DocumentException {
        ArrayList<PdfCounterReport> pdfCounterReports = new ArrayList<PdfCounterReport>();
        for (Counter counter : this.collector.getRangeCountersToBeDisplayed(this.range)) {
            pdfCounterReports.add(this.writeCounter(counter));
        }
        return pdfCounterReports;
    }

    private PdfCounterReport writeCounter(Counter counter) throws DocumentException, IOException {
        String counterLabel = I18N.getString(counter.getName() + "Label");
        this.addParagraph(I18N.getFormattedString("Statistiques_compteur", counterLabel) + " - " + this.range.getLabel(), counter.getIconName());
        PdfCounterReport pdfCounterReport = new PdfCounterReport(this.collector, counter, this.range, false, this.document);
        pdfCounterReport.toPdf();
        return pdfCounterReport;
    }

    private void writeCountersDetails(List<PdfCounterReport> pdfCounterReports) throws DocumentException, IOException {
        for (PdfCounterReport pdfCounterReport : pdfCounterReports) {
            this.writeCounterDetails(pdfCounterReport);
        }
    }

    private void writeCounterDetails(PdfCounterReport pdfCounterReport) throws DocumentException, IOException {
        String counterLabel = I18N.getString(pdfCounterReport.getCounterName() + "Label");
        this.addParagraph(I18N.getFormattedString("Statistiques_compteur_detaillees", counterLabel) + " - " + this.range.getLabel(), pdfCounterReport.getCounterIconName());
        pdfCounterReport.writeRequestDetails();
        if (pdfCounterReport.isErrorCounter()) {
            this.addParagraph(I18N.getString(pdfCounterReport.getCounterName() + "ErrorLabel") + " - " + this.range.getLabel(), pdfCounterReport.getCounterIconName());
            pdfCounterReport.writeErrorDetails();
        }
    }

    private List<PdfCounterRequestContextReport> writeCurrentRequests(JavaInformations javaInformations, List<PdfCounterReport> pdfCounterReports) throws IOException, DocumentException {
        ArrayList<PdfCounterRequestContextReport> pdfCounterRequestContextReports = new ArrayList<PdfCounterRequestContextReport>();
        List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts();
        if (rootCurrentContexts.isEmpty()) {
            this.add((Element)new Phrase(PdfReport.getI18nString("Aucune_requete_en_cours"), this.normalFont));
        } else {
            PdfCounterRequestContextReport pdfCounterRequestContextReport = new PdfCounterRequestContextReport(rootCurrentContexts, pdfCounterReports, javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.pdfDocumentFactory, this.document);
            pdfCounterRequestContextReport.toPdf();
            pdfCounterRequestContextReports.add(pdfCounterRequestContextReport);
        }
        return pdfCounterRequestContextReports;
    }

    private void writeCurrentRequestsDetails(List<PdfCounterRequestContextReport> pdfCounterRequestContextReports) throws IOException, DocumentException {
        for (PdfCounterRequestContextReport pdfCounterRequestContextReport : pdfCounterRequestContextReports) {
            pdfCounterRequestContextReport.writeContextDetails();
        }
        if (pdfCounterRequestContextReports.isEmpty()) {
            this.add((Element)new Phrase(PdfReport.getI18nString("Aucune_requete_en_cours"), this.normalFont));
        }
    }

    private void writeThreads(boolean includeDetails) throws DocumentException, IOException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.add((Element)new Phrase(eol + I18N.getFormattedString("Threads_sur", javaInformations.getHost()) + ": ", PdfDocumentFactory.BOLD_FONT));
            this.add((Element)new Phrase(I18N.getFormattedString("thread_count", javaInformations.getThreadCount(), javaInformations.getPeakThreadCount(), javaInformations.getTotalStartedThreadCount()), this.normalFont));
            PdfThreadInformationsReport pdfThreadInformationsReport = new PdfThreadInformationsReport(javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.pdfDocumentFactory, this.document);
            pdfThreadInformationsReport.writeDeadlocks();
            if (includeDetails) {
                pdfThreadInformationsReport.toPdf();
            }
            eol = "\n";
        }
    }

    private void writeCaches(boolean includeDetails) throws DocumentException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            List<CacheInformations> cacheInformationsList = javaInformations.getCacheInformationsList();
            String msg = I18N.getFormattedString("caches_sur", cacheInformationsList.size(), javaInformations.getHost(), javaInformations.getCurrentlyExecutingJobCount());
            this.add((Element)new Phrase(eol + msg, PdfDocumentFactory.BOLD_FONT));
            if (includeDetails) {
                new PdfCacheInformationsReport(cacheInformationsList, this.document).toPdf();
            }
            eol = "\n";
        }
    }

    private boolean isCacheEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            return true;
        }
        return false;
    }

    private void writeJobs(Counter rangeJobCounter, boolean includeDetails) throws DocumentException, IOException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            List<JobInformations> jobInformationsList = javaInformations.getJobInformationsList();
            String msg = I18N.getFormattedString("jobs_sur", jobInformationsList.size(), javaInformations.getHost(), javaInformations.getCurrentlyExecutingJobCount());
            this.add((Element)new Phrase(eol + msg, PdfDocumentFactory.BOLD_FONT));
            if (includeDetails) {
                new PdfJobInformationsReport(jobInformationsList, rangeJobCounter, this.document).toPdf();
            }
            eol = "\n";
        }
    }

    private boolean isJobEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            return true;
        }
        return false;
    }

    private void writeDurationAndOverhead() throws DocumentException {
        long displayDuration = System.currentTimeMillis() - this.start;
        String tmp = "\n\n" + PdfReport.getI18nString("temps_derniere_collecte") + ": " + this.collector.getLastCollectDuration() + ' ' + PdfReport.getI18nString("ms") + '\n' + PdfReport.getI18nString("temps_affichage") + ": " + displayDuration + ' ' + PdfReport.getI18nString("ms") + '\n' + PdfReport.getI18nString("Estimation_overhead_memoire") + ": < " + (this.collector.getEstimatedMemorySize() / 1024L / 1024L + 1L) + ' ' + PdfReport.getI18nString("Mo");
        String string = Parameters.JAVAMELODY_VERSION != null ? tmp + "\n\n" + "JavaMelody " + Parameters.JAVAMELODY_VERSION : tmp;
        this.add((Element)new Phrase(string, this.cellFont));
    }

    private void addParagraph(String paragraphTitle, String iconName) throws DocumentException, IOException {
        this.add(this.pdfDocumentFactory.createParagraphElement(paragraphTitle, iconName));
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private void add(Element element) throws DocumentException {
        this.document.add(element);
    }
}

