/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestAggregation;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfCounterReport;
import net.bull.javamelody.PdfDatabaseInformationsReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfHeapHistogramReport;
import net.bull.javamelody.PdfMBeansReport;
import net.bull.javamelody.PdfProcessInformationsReport;
import net.bull.javamelody.PdfRuntimeDependenciesReport;
import net.bull.javamelody.PdfSessionInformationsReport;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SessionInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfOtherReport {
    private final Document document;
    private final PdfDocumentFactory pdfDocumentFactory;

    PdfOtherReport(String application, OutputStream output) throws IOException {
        assert (output != null);
        try {
            this.pdfDocumentFactory = new PdfDocumentFactory(application, null, output);
            this.document = this.pdfDocumentFactory.createDocument();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
    }

    void writeSessionInformations(List<SessionInformations> sessionsInformations) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getI18nString("Sessions"), "system-users.png");
            new PdfSessionInformationsReport(sessionsInformations, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeHeapHistogram(HeapHistogram heapHistogram) throws IOException {
        try {
            this.document.open();
            this.addParagraph(I18N.getFormattedString("heap_histo_du", I18N.createDateAndTimeFormat().format(heapHistogram.getTime())), "memory.png");
            new PdfHeapHistogramReport(heapHistogram, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeProcessInformations(List<ProcessInformations> processInformations) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getI18nString("Processus"), "processes.png");
            new PdfProcessInformationsReport(processInformations, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeProcessInformations(Map<String, List<ProcessInformations>> processInformationsByTitle) throws IOException {
        try {
            this.document.open();
            for (Map.Entry<String, List<ProcessInformations>> entry : processInformationsByTitle.entrySet()) {
                this.addParagraph(entry.getKey(), "processes.png");
                new PdfProcessInformationsReport(entry.getValue(), this.document).toPdf();
            }
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeDatabaseInformations(DatabaseInformations databaseInformations) throws IOException {
        try {
            this.document.open();
            String selectedRequestName = databaseInformations.getSelectedRequestName();
            this.addParagraph(PdfOtherReport.getI18nString("database") + " : " + PdfOtherReport.getI18nString(selectedRequestName), "db.png");
            new PdfDatabaseInformationsReport(databaseInformations, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    void writeMBeans() throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getI18nString("MBeans"), "mbeans.png");
            new PdfMBeansReport(this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        catch (JMException e) {
            throw PdfOtherReport.createIOException(e);
        }
        this.document.close();
    }

    void writeRuntimeDependencies(Counter counter, Range range) throws IOException {
        try {
            Document myDocument = this.pdfDocumentFactory.createDocument(true);
            myDocument.open();
            String counterLabel = I18N.getString(counter.getName() + "Label");
            String paragraphTitle = I18N.getFormattedString("Dependance_compteur", counterLabel) + " - " + range.getLabel();
            myDocument.add(this.pdfDocumentFactory.createParagraphElement(paragraphTitle, counter.getIconName()));
            new PdfRuntimeDependenciesReport(counter, myDocument).toPdf();
            myDocument.close();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
    }

    void writeCounterSummaryPerClass(Collector collector, Counter counter, String requestId, Range range) throws IOException {
        List<CounterRequest> requestList = new CounterRequestAggregation(counter).getRequestsAggregatedOrFilteredByClassName(requestId);
        try {
            this.document.open();
            String counterLabel = I18N.getString(counter.getName() + "Label");
            String title = I18N.getFormattedString("Statistiques_compteur", counterLabel) + " - " + range.getLabel();
            this.addParagraph(title, counter.getIconName());
            new PdfCounterReport(collector, counter, range, false, this.document).writeRequests(counter.getChildCounterName(), requestList);
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException((Exception)((Object)e));
        }
        this.document.close();
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    private void addParagraph(String paragraphTitle, String iconName) throws DocumentException, IOException {
        this.add(this.pdfDocumentFactory.createParagraphElement(paragraphTitle, iconName));
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private void add(Element element) throws DocumentException {
        this.document.add(element);
    }
}

