/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.PdfOtherReport;
import net.bull.javamelody.PdfReport;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfController {
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;

    PdfController(Collector collector, CollectorServer collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPdf(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        this.addPdfContentTypeAndDisposition(httpRequest, httpResponse);
        try {
            String part = httpRequest.getParameter("part");
            if (part == null) {
                if (!this.isFromCollectorServer()) {
                    this.collector.collectLocalContextWithoutErrors();
                }
                Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
                PdfReport pdfReport = new PdfReport(this.collector, this.isFromCollectorServer(), javaInformationsList, range, (OutputStream)httpResponse.getOutputStream());
                pdfReport.toPdf();
            } else {
                try {
                    this.doPdfPart(httpRequest, httpResponse, part);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            httpResponse.getOutputStream().flush();
            throw throwable;
        }
        httpResponse.getOutputStream().flush();
    }

    private void doPdfPart(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String part) throws Exception {
        if ("sessions".equalsIgnoreCase(part)) {
            this.doSessions(httpResponse);
        } else if ("processes".equalsIgnoreCase(part)) {
            this.doProcesses(httpResponse);
        } else if ("database".equalsIgnoreCase(part)) {
            int index = DatabaseInformations.parseRequestIndex(httpRequest.getParameter("request"));
            this.doDatabase(httpResponse, index);
        } else if ("mbeans".equalsIgnoreCase(part)) {
            this.doMBeans(httpResponse);
        } else if ("heaphisto".equalsIgnoreCase(part)) {
            this.doHeapHisto(httpResponse);
        } else if ("runtimeDependencies".equalsIgnoreCase(part)) {
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            String counterName = httpRequest.getParameter("counter");
            Counter counter = this.collector.getRangeCounter(range, counterName);
            PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)httpResponse.getOutputStream());
            pdfOtherReport.writeRuntimeDependencies(counter, range);
        } else if ("counterSummaryPerClass".equalsIgnoreCase(part)) {
            String requestId = httpRequest.getParameter("graph");
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            String counterName = httpRequest.getParameter("counter");
            Counter counter = this.collector.getRangeCounter(range, counterName);
            PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)httpResponse.getOutputStream());
            pdfOtherReport.writeCounterSummaryPerClass(this.collector, counter, requestId, range);
        } else {
            throw new IllegalArgumentException(part);
        }
    }

    private void doSessions(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)httpResponse.getOutputStream());
        List<SessionInformations> sessionsInformations = !this.isFromCollectorServer() ? SessionListener.getAllSessionsInformations() : this.collectorServer.collectSessionInformations(this.collector.getApplication(), null);
        pdfOtherReport.writeSessionInformations(sessionsInformations);
    }

    private void doProcesses(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)httpResponse.getOutputStream());
        List<ProcessInformations> processInformations = ProcessInformations.buildProcessInformations();
        pdfOtherReport.writeProcessInformations(processInformations);
    }

    private void doDatabase(HttpServletResponse httpResponse, int index) throws Exception {
        Action.checkSystemActionsEnabled();
        DatabaseInformations databaseInformations = !this.isFromCollectorServer() ? new DatabaseInformations(index) : this.collectorServer.collectDatabaseInformations(this.collector.getApplication(), index);
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)httpResponse.getOutputStream());
        pdfOtherReport.writeDatabaseInformations(databaseInformations);
    }

    private void doMBeans(HttpServletResponse httpResponse) throws Exception {
        Action.checkSystemActionsEnabled();
        if (this.isFromCollectorServer()) {
            throw new IllegalStateException("Not supported on the collect server");
        }
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)httpResponse.getOutputStream());
        pdfOtherReport.writeMBeans();
    }

    private void doHeapHisto(HttpServletResponse httpResponse) throws Exception {
        Action.checkSystemActionsEnabled();
        HeapHistogram heapHistogram = !this.isFromCollectorServer() ? VirtualMachine.createHeapHistogram() : this.collectorServer.collectHeapHistogram(this.collector.getApplication());
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)httpResponse.getOutputStream());
        pdfOtherReport.writeHeapHistogram(heapHistogram);
    }

    void addPdfContentTypeAndDisposition(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        httpResponse.setContentType("application/pdf");
        httpResponse.addHeader("Content-Disposition", PdfController.encodeFileNameToContentDisposition(httpRequest, PdfReport.getFileName(this.collector.getApplication())));
    }

    private boolean isFromCollectorServer() {
        return this.collectorServer != null;
    }

    private static String encodeFileNameToContentDisposition(HttpServletRequest httpRequest, String fileName) {
        assert (fileName != null);
        String userAgent = httpRequest.getHeader("user-agent");
        if (userAgent != null && userAgent.contains("MSIE")) {
            return "attachment;filename=" + fileName;
        }
        return PdfController.encodeFileNameToStandardContentDisposition(fileName);
    }

    private static String encodeFileNameToStandardContentDisposition(String fileName) {
        int length = fileName.length();
        StringBuilder sb = new StringBuilder(length + length / 4);
        sb.append("attachment;filename=\"");
        for (int i = 0; i < length; ++i) {
            char c = fileName.charAt(i);
            if (PdfController.isEncodingNotNeeded(c)) {
                sb.append(c);
                continue;
            }
            sb.append('%');
            if (c < '\u0010') {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static boolean isEncodingNotNeeded(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_';
    }
}

