/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.sun.faces.application.ActionListenerImpl;
import javax.faces.component.ActionSource2;
import javax.faces.event.ActionEvent;
import net.bull.javamelody.Counter;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public class JsfActionListener
extends ActionListenerImpl {
    private static final Counter JSF_COUNTER = MonitoringProxy.getJsfCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(JSF_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    public JsfActionListener() {
        JSF_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        JSF_COUNTER.setUsed(true);
        LOG.debug("jsf action listener initialized");
    }

    public void processAction(ActionEvent event) {
        if (DISABLED || !JSF_COUNTER.isDisplayed()) {
            super.processAction(event);
        }
        boolean systemError = false;
        try {
            ActionSource2 actionSource;
            String actionName = event.getComponent() instanceof ActionSource2 ? ((actionSource = (ActionSource2)event.getComponent()).getActionExpression() != null ? actionSource.getActionExpression().getExpressionString() : actionSource.getClass().getName()) : event.getComponent().getClass().getName();
            JSF_COUNTER.bindContextIncludingCpu(actionName);
            super.processAction(event);
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            JSF_COUNTER.addRequestForCurrentContext(systemError);
        }
    }
}

