/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

final class JobGlobalListener
implements JobListener {
    private static final Counter JOB_COUNTER = new Counter("job", "jobs.png", JdbcWrapper.SINGLETON.getSqlCounter());

    JobGlobalListener() {
    }

    static Counter getJobCounter() {
        return JOB_COUNTER;
    }

    static void initJobGlobalListener() {
        try {
            Scheduler defaultScheduler;
            JobGlobalListener jobGlobalListener = new JobGlobalListener();
            if (Boolean.parseBoolean(Parameters.getParameter(Parameter.QUARTZ_DEFAULT_LISTENER_DISABLED))) {
                defaultScheduler = null;
            } else {
                defaultScheduler = StdSchedulerFactory.getDefaultScheduler();
                defaultScheduler.addGlobalJobListener((JobListener)jobGlobalListener);
            }
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                if (scheduler == defaultScheduler) continue;
                scheduler.addGlobalJobListener((JobListener)jobGlobalListener);
            }
            LOG.debug("job global listener initialized");
        }
        catch (SchedulerException e) {
            LOG.info("initialization of job global listener failed, skipping", e);
        }
    }

    /*
     * Exception decompiling
     */
    static void destroyJobGlobalListener() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobDetail jobDetail = context.getJobDetail();
        String jobFullName = jobDetail.getGroup() + '.' + jobDetail.getName();
        JOB_COUNTER.bindContextIncludingCpu(jobFullName);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        JOB_COUNTER.unbindContext();
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        String stackTrace;
        if (jobException == null) {
            stackTrace = null;
        } else {
            StringWriter stackTraceWriter = new StringWriter(200);
            jobException.printStackTrace(new PrintWriter(stackTraceWriter));
            stackTrace = stackTraceWriter.toString();
        }
        JOB_COUNTER.addRequestForCurrentContext(stackTrace);
    }

    public String getName() {
        return this.getClass().getName();
    }
}

