/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.BadElementException;
import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfDocumentFactory {
    static final Font NORMAL_FONT = PdfDocumentFactory.getFont(8.0f, 0);
    static final Font BOLD_FONT = PdfDocumentFactory.getFont(8.0f, 1);
    static final Font PARAGRAPH_TITLE_FONT = PdfDocumentFactory.getFont(10.0f, 1);
    static final Font TABLE_CELL_FONT = PdfDocumentFactory.getFont(5.5f, 0);
    static final Font BOLD_CELL_FONT = PdfDocumentFactory.getFont(5.5f, 1);
    static final Font BLUE_FONT = PdfDocumentFactory.getFont(5.5f, 0);
    static final Font INFO_CELL_FONT = FontFactory.getFont((String)"Helvetica", (float)5.5f, (int)0, (Color)Color.GREEN);
    static final Font WARNING_CELL_FONT = FontFactory.getFont((String)"Helvetica", (float)5.5f, (int)1, (Color)Color.ORANGE);
    static final Font SEVERE_CELL_FONT = FontFactory.getFont((String)"Helvetica", (float)5.5f, (int)1, (Color)Color.RED);
    private static final Font TABLE_HEADER_FONT = PdfDocumentFactory.getFont(5.5f, 1);
    private final String application;
    private final OutputStream output;
    private final Map<String, Image> paragraphImagesByResourceName = new HashMap<String, Image>();
    private final Map<String, Image> smallImagesByResourceName = new HashMap<String, Image>();

    PdfDocumentFactory(String application, OutputStream output) {
        assert (application != null);
        assert (output != null);
        this.application = application;
        this.output = output;
    }

    Document createDocument() throws DocumentException, IOException {
        return this.createDocument(false);
    }

    Document createDocument(boolean landscape) throws DocumentException, IOException {
        Rectangle pageSize = landscape ? PageSize.A4.rotate() : PageSize.A4;
        Document document = new Document(pageSize, 20.0f, 20.0f, 20.0f, 40.0f);
        String title = I18N.getFormattedString("Monitoring_sur", this.application);
        this.createWriter(document, title);
        document.addAuthor(this.application);
        document.addCreator("JavaMelody par E. Vernat, http://javamelody.googlecode.com");
        document.addTitle(title);
        return document;
    }

    private void createWriter(Document document, String title) throws DocumentException, IOException {
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)this.output);
        HeaderFooter header = new HeaderFooter(new Phrase(title), false);
        header.setAlignment(0);
        header.setBorder(0);
        document.setHeader(header);
        writer.setPageEvent((PdfPageEvent)new PdfAdvancedPageNumberEvents());
    }

    Element createParagraphElement(String paragraphTitle, String iconName) throws DocumentException, IOException {
        Paragraph paragraph = new Paragraph("", PARAGRAPH_TITLE_FONT);
        paragraph.setSpacingBefore(5.0f);
        paragraph.setSpacingAfter(5.0f);
        if (iconName != null) {
            paragraph.add((Object)new Chunk(this.getParagraphImage(iconName), 0.0f, -5.0f));
        }
        Phrase element = new Phrase(' ' + paragraphTitle, PARAGRAPH_TITLE_FONT);
        element.setLeading(12.0f);
        paragraph.add((Object)element);
        ChapterAutoNumber chapter = new ChapterAutoNumber(paragraph);
        chapter.setNumberDepth(0);
        chapter.setBookmarkOpen(false);
        chapter.setTriggerNewPage(false);
        return chapter;
    }

    private Image getParagraphImage(String resourceFileName) throws DocumentException, IOException {
        Image image = this.paragraphImagesByResourceName.get(resourceFileName);
        if (image == null) {
            image = PdfDocumentFactory.getImage(resourceFileName);
            image.scaleAbsolute(16.0f, 16.0f);
            this.paragraphImagesByResourceName.put(resourceFileName, image);
        }
        return image;
    }

    Image getSmallImage(String resourceFileName) throws DocumentException, IOException {
        Image image = this.smallImagesByResourceName.get(resourceFileName);
        if (image == null) {
            image = PdfDocumentFactory.getImage(resourceFileName);
            image.scaleAbsolute(8.0f, 8.0f);
            this.smallImagesByResourceName.put(resourceFileName, image);
        }
        return image;
    }

    static Image getImage(String resourceFileName) throws BadElementException, IOException {
        return Image.getInstance((URL)PdfDocumentFactory.class.getResource(Parameters.getResourcePath(resourceFileName)));
    }

    static PdfPTable createPdfPTable(List<String> headers, int[] relativeWidths) throws DocumentException {
        assert (headers.size() == relativeWidths.length);
        PdfPTable table = new PdfPTable(headers.size());
        table.setWidthPercentage(100.0f);
        table.setWidths(relativeWidths);
        table.setHeaderRows(1);
        PdfPCell defaultCell = table.getDefaultCell();
        defaultCell.setGrayFill(0.9f);
        defaultCell.setHorizontalAlignment(1);
        defaultCell.setPaddingLeft(0.0f);
        defaultCell.setPaddingRight(0.0f);
        for (String header : headers) {
            table.addCell(new Phrase(header, TABLE_HEADER_FONT));
        }
        defaultCell.setPaddingLeft(2.0f);
        defaultCell.setPaddingRight(2.0f);
        return table;
    }

    static Font getFont(float size, int style) {
        if (Locale.CHINESE.getLanguage().equals(I18N.getResourceBundle().getLocale().getLanguage())) {
            try {
                BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                return new Font(bfChinese, size, style);
            }
            catch (DocumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return FontFactory.getFont((String)"Helvetica", (float)size, (int)style);
    }

    static {
        BLUE_FONT.setColor(Color.BLUE);
    }

    private static class PdfAdvancedPageNumberEvents
    extends PdfPageEventHelper {
        private PdfContentByte cb;
        private PdfTemplate template;
        private final BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);

        PdfAdvancedPageNumberEvents() throws DocumentException, IOException {
        }

        public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            this.cb = writer.getDirectContent();
            this.template = this.cb.createTemplate(50.0f, 50.0f);
        }

        public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
        }

        public void onEndPage(PdfWriter writer, Document document) {
            int pageN = writer.getPageNumber();
            String text = pageN + " / ";
            float len = this.bf.getWidthPoint(text, 8.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            float width = document.getPageSize().getWidth();
            this.cb.setTextMatrix(width / 2.0f, 30.0f);
            this.cb.showText(text);
            this.cb.endText();
            this.cb.addTemplate(this.template, width / 2.0f + len, 30.0f);
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            this.template.beginText();
            this.template.setFontAndSize(this.bf, 8.0f);
            this.template.showText(String.valueOf(writer.getPageNumber() - 1));
            this.template.endText();
        }
    }
}

