/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.HtmlCoreReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.ProcessInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlProcessInformationsReport {
    private static final boolean PDF_ENABLED = HtmlCoreReport.isPdfEnabled();
    private final List<ProcessInformations> processInformationsList;
    private final Writer writer;
    private final boolean windows;
    private final DecimalFormat percentFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    HtmlProcessInformationsReport(List<ProcessInformations> processInformationsList, Writer writer) {
        assert (processInformationsList != null);
        assert (writer != null);
        this.processInformationsList = processInformationsList;
        this.writer = writer;
        this.windows = HtmlProcessInformationsReport.isWindowsProcessList(processInformationsList);
    }

    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeln("<img src='?resource=processes.png' width='24' height='24' alt='#Processus#' />&nbsp;");
        this.writeln("<b>#Processus#</b>");
        this.writeTable();
    }

    void writeTable() throws IOException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Processus#'>");
        this.write("<thead><tr><th>#Utilisateur#</th>");
        this.write("<th class='sorttable_numeric'>#PID#</th>");
        if (!this.windows) {
            this.write("<th class='sorttable_numeric'>#cpu#</th><th class='sorttable_numeric'>#mem#</th>");
        }
        this.write("<th class='sorttable_numeric'>#vsz#</th>");
        if (!this.windows) {
            this.write("<th class='sorttable_numeric'>#rss#</th><th>#tty#</th>");
            this.write("<th>#stat#</th><th>#start#</th>");
        }
        this.write("<th>#cpuTime#</th><th>#command#</th>");
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (ProcessInformations processInformations : this.processInformationsList) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeProcessInformations(processInformations);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
        if (!this.windows) {
            this.write("<div align='right'>");
            this.write("<a href='http://en.wikipedia.org/wiki/Ps_(Unix)' target='_blank'>ps command reference</a></div>");
        }
    }

    private void writeProcessInformations(ProcessInformations processInformations) throws IOException {
        this.write("<td>");
        this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getUser()));
        String newColumnRight = "</td><td align='right'>";
        String newColumn = "</td><td>";
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(processInformations.getPid()));
        if (!this.windows) {
            this.write("</td><td align='right'>");
            this.write(this.percentFormat.format(processInformations.getCpuPercentage()));
            this.write("</td><td align='right'>");
            this.write(this.percentFormat.format(processInformations.getMemPercentage()));
        }
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(processInformations.getVsz()));
        if (!this.windows) {
            this.write("</td><td align='right'>");
            this.write(this.integerFormat.format(processInformations.getRss()));
            this.write("</td><td>");
            this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getTty()));
            this.write("</td><td>");
            this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getStat()));
            this.write("</td><td align='right'>");
            this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getStart()));
        }
        this.write("</td><td align='right'>");
        this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getCpuTime()));
        this.write("</td><td>");
        this.writer.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getCommand()));
        this.write("</td>");
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=processes'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (PDF_ENABLED) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=processes&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("</div>");
    }

    static boolean isWindowsProcessList(List<ProcessInformations> processInformationsList) {
        for (ProcessInformations processInformations : processInformationsList) {
            if (processInformations.getTty() == null) continue;
            return false;
        }
        return true;
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

