/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VirtualMachine {
    private static boolean enabled = VirtualMachine.isSupported();
    private static Object jvmVirtualMachine;

    private VirtualMachine() {
    }

    static boolean isSupported() {
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        return "1.6".compareTo(javaVersion) < 0 && (javaVendor.contains("Sun") || javaVendor.contains("Oracle") || javaVendor.contains("Apple") || VirtualMachine.isJRockit());
    }

    static boolean isJRockit() {
        return System.getProperty("java.vendor").contains("BEA");
    }

    static synchronized boolean isEnabled() {
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Object getJvmVirtualMachine() throws Exception {
        if (jvmVirtualMachine == null) {
            Class<?> virtualMachineClass = VirtualMachine.findVirtualMachineClass();
            Method attachMethod = virtualMachineClass.getMethod("attach", String.class);
            String pid = PID.getPID();
            try {
                jvmVirtualMachine = VirtualMachine.invoke(attachMethod, null, pid);
                enabled = jvmVirtualMachine != null;
            }
            catch (Throwable throwable) {
                enabled = jvmVirtualMachine != null;
                throw throwable;
            }
        }
        return jvmVirtualMachine;
    }

    private static Class<?> findVirtualMachineClass() throws ClassNotFoundException, MalformedURLException {
        String virtualMachineClassName = "com.sun.tools.attach.VirtualMachine";
        try {
            return Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException e) {
            String[] defaultToolsLocation;
            File file = new File(System.getProperty("java.home"));
            if ("jre".equalsIgnoreCase(file.getName())) {
                file = file.getParentFile();
            }
            for (String name : defaultToolsLocation = new String[]{"lib", "tools.jar"}) {
                file = new File(file, name);
            }
            URL[] urls = new URL[]{file.toURI().toURL()};
            URLClassLoader cl = URLClassLoader.newInstance(urls);
            return Class.forName("com.sun.tools.attach.VirtualMachine", true, cl);
        }
    }

    static synchronized void detach() throws Exception {
        if (jvmVirtualMachine != null) {
            Class<?> virtualMachineClass = jvmVirtualMachine.getClass();
            Method detachMethod = virtualMachineClass.getMethod("detach", new Class[0]);
            jvmVirtualMachine = VirtualMachine.invoke(detachMethod, jvmVirtualMachine, new Object[0]);
            jvmVirtualMachine = null;
        }
    }

    static InputStream heapHisto() throws Exception {
        if (!VirtualMachine.isSupported()) {
            throw new IllegalStateException(I18N.getString("heap_histo_non_supporte"));
        }
        if (!VirtualMachine.isEnabled()) {
            throw new IllegalStateException(I18N.getString("heap_histo_non_actif"));
        }
        try {
            Class<?> virtualMachineClass = VirtualMachine.getJvmVirtualMachine().getClass();
            Method heapHistoMethod = virtualMachineClass.getMethod("heapHisto", Object[].class);
            return (InputStream)VirtualMachine.invoke(heapHistoMethod, VirtualMachine.getJvmVirtualMachine(), new Object[]{new Object[]{"-all"}});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(I18N.getString("heap_histo_jre"), e);
        }
        catch (Exception e) {
            if ("com.sun.tools.attach.AttachNotSupportedException".equals(e.getClass().getName())) {
                throw new IllegalStateException(I18N.getString("heap_histo_jre"), e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HeapHistogram createHeapHistogram() throws Exception {
        InputStream input = VirtualMachine.heapHisto();
        try {
            HeapHistogram heapHistogram = new HeapHistogram(input, VirtualMachine.isJRockit());
            return heapHistogram;
        }
        finally {
            input.close();
        }
    }

    private static Object invoke(Method method, Object object, Object ... args) throws Exception {
        try {
            return method.invoke(object, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new Exception(e.getCause());
        }
    }
}

