/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JdbcWrapperHelper {
    private static final Map<String, DataSource> SPRING_DATASOURCES = new LinkedHashMap<String, DataSource>();
    private static final Map<String, DataSource> JNDI_DATASOURCES_BACKUP = new LinkedHashMap<String, DataSource>();

    private JdbcWrapperHelper() {
    }

    static void registerSpringDataSource(String name, DataSource dataSource) {
        SPRING_DATASOURCES.put(name, dataSource);
    }

    static void rebindDataSource(ServletContext servletContext, String jndiName, DataSource dataSource, DataSource dataSourceProxy) throws Throwable {
        Object lock = JdbcWrapperHelper.changeContextWritable(servletContext, null);
        InitialContext initialContext = new InitialContext();
        initialContext.rebind(jndiName, (Object)dataSourceProxy);
        JNDI_DATASOURCES_BACKUP.put(jndiName, dataSource);
        JdbcWrapperHelper.changeContextWritable(servletContext, lock);
        initialContext.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rebindInitialDataSources(ServletContext servletContext) throws Throwable {
        try {
            InitialContext initialContext = new InitialContext();
            for (Map.Entry<String, DataSource> entry : JNDI_DATASOURCES_BACKUP.entrySet()) {
                String jndiName = entry.getKey();
                DataSource dataSource = entry.getValue();
                Object lock = JdbcWrapperHelper.changeContextWritable(servletContext, null);
                initialContext.rebind(jndiName, (Object)dataSource);
                JdbcWrapperHelper.changeContextWritable(servletContext, lock);
            }
            initialContext.close();
            Object var8_7 = null;
            JNDI_DATASOURCES_BACKUP.clear();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JNDI_DATASOURCES_BACKUP.clear();
            throw throwable;
        }
    }

    static Map<String, DataSource> getJndiAndSpringDataSources() throws NamingException {
        LinkedHashMap<String, DataSource> dataSources;
        try {
            dataSources = new LinkedHashMap<String, DataSource>(JdbcWrapperHelper.getJndiDataSources());
        }
        catch (NoInitialContextException e) {
            dataSources = new LinkedHashMap();
        }
        dataSources.putAll(SPRING_DATASOURCES);
        return dataSources;
    }

    static Map<String, DataSource> getJndiDataSources() throws NamingException {
        LinkedHashMap<String, DataSource> dataSources = new LinkedHashMap<String, DataSource>(2);
        String datasourcesParameter = Parameters.getParameter(Parameter.DATASOURCES);
        if (datasourcesParameter == null) {
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("java:comp/env/jdbc"));
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("java:/jdbc"));
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("java:global/jdbc"));
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("jdbc"));
        } else if (datasourcesParameter.trim().length() != 0) {
            InitialContext initialContext = new InitialContext();
            for (String datasource : datasourcesParameter.split(",")) {
                String jndiName = datasource.trim();
                DataSource dataSource = (DataSource)initialContext.lookup(jndiName);
                dataSources.put(jndiName, dataSource);
            }
            initialContext.close();
        }
        return Collections.unmodifiableMap(dataSources);
    }

    private static Map<String, DataSource> getJndiDataSourcesAt(String jndiPrefix) throws NamingException {
        InitialContext initialContext = new InitialContext();
        LinkedHashMap<String, DataSource> dataSources = new LinkedHashMap<String, DataSource>(2);
        try {
            for (NameClassPair nameClassPair : Collections.list(initialContext.list(jndiPrefix))) {
                String jndiName = nameClassPair.getName().startsWith("java:") ? nameClassPair.getName() : jndiPrefix + '/' + nameClassPair.getName();
                Object value = initialContext.lookup(jndiName);
                if (!(value instanceof DataSource)) continue;
                dataSources.put(jndiName, (DataSource)value);
            }
        }
        catch (NamingException e) {
            return dataSources;
        }
        initialContext.close();
        return dataSources;
    }

    private static Object changeContextWritable(ServletContext servletContext, Object lock) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException, NamingException {
        assert (servletContext != null);
        if (servletContext.getServerInfo().contains("Tomcat") && System.getProperty("jonas.name") == null) {
            Field field = Class.forName("org.apache.naming.ContextAccessController").getDeclaredField("readOnlyContexts");
            JdbcWrapperHelper.setFieldAccessible(field);
            Hashtable readOnlyContexts = (Hashtable)field.get(null);
            if (lock == null) {
                Hashtable clone = new Hashtable(readOnlyContexts);
                readOnlyContexts.clear();
                return clone;
            }
            Hashtable myLock = (Hashtable)lock;
            readOnlyContexts.putAll(myLock);
            return null;
        }
        if (servletContext.getServerInfo().contains("jetty")) {
            Context jdbcContext = (Context)new InitialContext().lookup("java:comp");
            Field field = JdbcWrapperHelper.getAccessibleField(jdbcContext, "_env");
            Hashtable env = (Hashtable)field.get(jdbcContext);
            if (lock == null) {
                return env.remove("org.mortbay.jndi.lock");
            }
            env.put("org.mortbay.jndi.lock", lock);
            return null;
        }
        return null;
    }

    static Object getFieldValue(Object object, String fieldName) throws IllegalAccessException {
        return JdbcWrapperHelper.getAccessibleField(object, fieldName).get(object);
    }

    static void setFieldValue(Object object, String fieldName, Object value) throws IllegalAccessException {
        JdbcWrapperHelper.getAccessibleField(object, fieldName).set(object, value);
    }

    private static Field getAccessibleField(Object object, String fieldName) {
        assert (fieldName != null);
        Class<?> classe = object.getClass();
        Field result = null;
        do {
            for (Field field : classe.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                result = field;
                break;
            }
            classe = classe.getSuperclass();
        } while (result == null && classe != null);
        assert (result != null);
        JdbcWrapperHelper.setFieldAccessible(result);
        return result;
    }

    private static void setFieldAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }
}

