/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Collector;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Mailer;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfReport;
import net.bull.javamelody.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MailReport {
    MailReport() {
    }

    static void scheduleReportMailForLocalServer(Collector collector, Timer timer) {
        assert (collector != null);
        assert (timer != null);
        for (Period period : MailReport.getMailPeriods()) {
            MailReport.scheduleReportMailForLocalServer(collector, timer, period);
        }
    }

    static void scheduleReportMailForLocalServer(final Collector collector, final Timer timer, final Period period) {
        assert (collector != null);
        assert (timer != null);
        assert (period != null);
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    new MailReport().sendReportMailForLocalServer(collector, period);
                }
                catch (Throwable t) {
                    LOG.warn("sending mail report failed", t);
                }
                MailReport.scheduleReportMailForLocalServer(collector, timer, period);
            }
        };
        Date nextExecutionDate = MailReport.getNextExecutionDate(period);
        timer.schedule(task, nextExecutionDate);
        LOG.debug("mail report for the " + period.getMailCode() + " period scheduled with next execution date at " + nextExecutionDate);
    }

    static List<Period> getMailPeriods() {
        List<Period> mailPeriods;
        if (Parameters.getParameter(Parameter.MAIL_PERIODS) == null) {
            mailPeriods = Collections.singletonList(Period.SEMAINE);
        } else {
            String mailPeriodsParameter = Parameters.getParameter(Parameter.MAIL_PERIODS);
            mailPeriods = new ArrayList<Period>();
            for (String mailPeriod : mailPeriodsParameter.split(",")) {
                mailPeriods.add(Period.valueOfByMailCode(mailPeriod));
            }
        }
        return mailPeriods;
    }

    static Date getNextExecutionDate(Period period) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (period) {
            case JOUR: {
                calendar.add(6, 1);
                break;
            }
            case SEMAINE: {
                calendar.set(7, 1);
                if (calendar.getTimeInMillis() >= System.currentTimeMillis()) break;
                calendar.add(6, 7);
                break;
            }
            case MOIS: {
                calendar.set(5, 1);
                if (calendar.getTimeInMillis() >= System.currentTimeMillis()) break;
                calendar.add(2, 1);
                break;
            }
            case TOUT: {
                throw new IllegalArgumentException(String.valueOf((Object)period));
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)period));
            }
        }
        return calendar.getTime();
    }

    void sendReportMailForLocalServer(Collector collector, Period period) throws Exception {
        JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
        this.sendReportMail(collector, false, Collections.singletonList(javaInformations), period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReportMail(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Period period) throws Exception {
        File tmpFile = new File(Parameters.TEMPORARY_DIRECTORY, PdfReport.getFileName(collector.getApplication()));
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tmpFile));
            try {
                PdfReport pdfReport = new PdfReport(collector, collectorServer, javaInformationsList, period, (OutputStream)output);
                pdfReport.toPdf();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ((OutputStream)output).close();
                throw throwable;
            }
            ((OutputStream)output).close();
            String subject = I18N.getFormattedString("Monitoring_sur", collector.getApplication());
            Mailer mailer = new Mailer(Parameters.getParameter(Parameter.MAIL_SESSION));
            String adminEmails = Parameters.getParameter(Parameter.ADMIN_EMAILS);
            mailer.send(adminEmails, subject, "", Collections.singletonList(tmpFile), false);
            Object var11_12 = null;
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            throw throwable;
        }
    }
}

