/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.imageio.ImageIO;
import net.bull.javamelody.HtmlJavaInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.MemoryInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.TomcatInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfJavaInformationsReport {
    private static final String DIVIDE = " / ";
    private static final String BAR_SEPARATOR = "   ";
    private final boolean noDatabase = Parameters.isNoDatabase();
    private final DecimalFormat decimalFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final List<JavaInformations> javaInformationsList;
    private final Document document;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private final Font boldCellFont = PdfDocumentFactory.BOLD_CELL_FONT;
    private PdfPTable currentTable;

    PdfJavaInformationsReport(List<JavaInformations> javaInformationsList, Document document) {
        assert (javaInformationsList != null);
        assert (document != null);
        this.javaInformationsList = javaInformationsList;
        this.document = document;
    }

    void toPdf() throws DocumentException, IOException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.currentTable = PdfJavaInformationsReport.createJavaInformationsTable();
            this.writeSummary(javaInformations);
            this.addCell("");
            this.addCell("");
            this.document.add((Element)this.currentTable);
        }
    }

    private static PdfPTable createJavaInformationsTable() throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        table.setHorizontalAlignment(0);
        table.setWidthPercentage(100.0f);
        table.setWidths(new int[]{2, 8});
        table.getDefaultCell().setBorder(0);
        return table;
    }

    private void writeSummary(JavaInformations javaInformations) throws BadElementException, IOException {
        this.addCell(PdfJavaInformationsReport.getI18nString("Host") + ':');
        this.currentTable.addCell(new Phrase(javaInformations.getHost(), this.boldCellFont));
        this.addCell(PdfJavaInformationsReport.getI18nString("memoire_utilisee") + ':');
        MemoryInformations memoryInformations = javaInformations.getMemoryInformations();
        long usedMemory = memoryInformations.getUsedMemory();
        long maxMemory = memoryInformations.getMaxMemory();
        Phrase memoryPhrase = new Phrase(this.integerFormat.format(usedMemory / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo") + DIVIDE + this.integerFormat.format(maxMemory / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo") + BAR_SEPARATOR, this.cellFont);
        com.lowagie.text.Image memoryImage = com.lowagie.text.Image.getInstance((Image)Bar.toBar(memoryInformations.getUsedMemoryPercentage()), null);
        memoryImage.scalePercent(50.0f);
        memoryPhrase.add((Object)new Chunk(memoryImage, 0.0f, 0.0f));
        this.currentTable.addCell(memoryPhrase);
        if (javaInformations.getSessionCount() >= 0) {
            this.addCell(PdfJavaInformationsReport.getI18nString("nb_sessions_http") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getSessionCount()));
        }
        this.addCell(PdfJavaInformationsReport.getI18nString("nb_threads_actifs") + "\n(" + PdfJavaInformationsReport.getI18nString("Requetes_http_en_cours") + "):");
        this.addCell(this.integerFormat.format(javaInformations.getActiveThreadCount()));
        if (!this.noDatabase) {
            this.addCell(PdfJavaInformationsReport.getI18nString("nb_connexions_actives") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getActiveConnectionCount()));
            this.addCell(PdfJavaInformationsReport.getI18nString("nb_connexions_utilisees") + "\n(" + PdfJavaInformationsReport.getI18nString("ouvertes") + "):");
            int usedConnectionCount = javaInformations.getUsedConnectionCount();
            int maxConnectionCount = javaInformations.getMaxConnectionCount();
            if (maxConnectionCount <= 0) {
                this.addCell(this.integerFormat.format(usedConnectionCount));
            } else {
                Phrase usedConnectionCountPhrase = new Phrase(this.integerFormat.format(usedConnectionCount) + DIVIDE + this.integerFormat.format(maxConnectionCount) + BAR_SEPARATOR, this.cellFont);
                com.lowagie.text.Image usedConnectionCountImage = com.lowagie.text.Image.getInstance((Image)Bar.toBar(javaInformations.getUsedConnectionPercentage()), null);
                usedConnectionCountImage.scalePercent(50.0f);
                usedConnectionCountPhrase.add((Object)new Chunk(usedConnectionCountImage, 0.0f, 0.0f));
                this.currentTable.addCell(usedConnectionCountPhrase);
            }
        }
        if (javaInformations.getSystemLoadAverage() >= 0.0) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Charge_systeme") + ':');
            this.addCell(this.decimalFormat.format(javaInformations.getSystemLoadAverage()));
        }
    }

    void writeInformationsDetails() throws DocumentException, IOException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.currentTable = PdfJavaInformationsReport.createJavaInformationsTable();
            this.writeSummary(javaInformations);
            this.writeDetails(javaInformations);
            this.document.add((Element)this.currentTable);
        }
    }

    private void writeDetails(JavaInformations javaInformations) throws BadElementException, IOException {
        String serverInfo;
        this.addCell(PdfJavaInformationsReport.getI18nString("OS") + ':');
        Phrase osPhrase = new Phrase("", this.cellFont);
        String osIconName = HtmlJavaInformationsReport.getOSIconName(javaInformations.getOS());
        String separator = BAR_SEPARATOR;
        if (osIconName != null) {
            com.lowagie.text.Image osImage = PdfDocumentFactory.getImage("servers/" + osIconName);
            osImage.scalePercent(40.0f);
            osPhrase.add((Object)new Chunk(osImage, 0.0f, 0.0f));
            osPhrase.add((Object)BAR_SEPARATOR);
        }
        osPhrase.add((Object)(javaInformations.getOS() + " (" + javaInformations.getAvailableProcessors() + ' ' + PdfJavaInformationsReport.getI18nString("coeurs") + ')'));
        this.currentTable.addCell(osPhrase);
        this.addCell(PdfJavaInformationsReport.getI18nString("Java") + ':');
        this.addCell(javaInformations.getJavaVersion());
        this.addCell(PdfJavaInformationsReport.getI18nString("JVM") + ':');
        Phrase jvmVersionPhrase = new Phrase(javaInformations.getJvmVersion(), this.cellFont);
        if (javaInformations.getJvmVersion().contains("Client")) {
            jvmVersionPhrase.add((Object)BAR_SEPARATOR);
            com.lowagie.text.Image alertImage = PdfDocumentFactory.getImage("alert.png");
            alertImage.scalePercent(50.0f);
            jvmVersionPhrase.add((Object)new Chunk(alertImage, 0.0f, -2.0f));
        }
        this.currentTable.addCell(jvmVersionPhrase);
        this.addCell(PdfJavaInformationsReport.getI18nString("PID") + ':');
        this.addCell(javaInformations.getPID());
        if (javaInformations.getUnixOpenFileDescriptorCount() >= 0L) {
            this.writeFileDescriptorCounts(javaInformations);
        }
        if ((serverInfo = javaInformations.getServerInfo()) != null) {
            this.writeServerInfo(serverInfo);
            this.addCell(PdfJavaInformationsReport.getI18nString("Contexte_webapp") + ':');
            this.addCell(javaInformations.getContextPath());
        }
        this.addCell(PdfJavaInformationsReport.getI18nString("Demarrage") + ':');
        this.addCell(I18N.createDateAndTimeFormat().format(javaInformations.getStartDate()));
        this.addCell(PdfJavaInformationsReport.getI18nString("Arguments_JVM") + ':');
        this.addCell(javaInformations.getJvmArguments());
        if (javaInformations.getSessionCount() >= 0) {
            this.addCell(PdfJavaInformationsReport.getI18nString("httpSessionsMeanAge") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getSessionMeanAgeInMinutes()));
        }
        this.writeTomcatInformations(javaInformations.getTomcatInformationsList());
        this.addCell(PdfJavaInformationsReport.getI18nString("Gestion_memoire") + ':');
        this.writeMemoryInformations(javaInformations.getMemoryInformations());
        if (javaInformations.getFreeDiskSpaceInTemp() >= 0L) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Free_disk_space") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getFreeDiskSpaceInTemp() / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo"));
        }
        this.writeDatabaseVersionAndDataSourceDetails(javaInformations);
        if (javaInformations.isDependenciesEnabled()) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Dependencies") + ':');
            this.addCell(I18N.getFormattedString("nb_dependencies", javaInformations.getDependenciesList().size()) + " ;\n" + javaInformations.getDependencies());
        }
        this.addCell("");
        this.addCell("");
    }

    private void writeServerInfo(String serverInfo) throws BadElementException, IOException {
        this.addCell(PdfJavaInformationsReport.getI18nString("Serveur") + ':');
        Phrase serverInfoPhrase = new Phrase("", this.cellFont);
        String applicationServerIconName = HtmlJavaInformationsReport.getApplicationServerIconName(serverInfo);
        if (applicationServerIconName != null) {
            com.lowagie.text.Image applicationServerImage = PdfDocumentFactory.getImage("servers/" + applicationServerIconName);
            applicationServerImage.scalePercent(40.0f);
            serverInfoPhrase.add((Object)new Chunk(applicationServerImage, 0.0f, 0.0f));
            serverInfoPhrase.add((Object)BAR_SEPARATOR);
        }
        serverInfoPhrase.add((Object)serverInfo);
        this.currentTable.addCell(serverInfoPhrase);
    }

    private void writeFileDescriptorCounts(JavaInformations javaInformations) throws BadElementException, IOException {
        long unixOpenFileDescriptorCount = javaInformations.getUnixOpenFileDescriptorCount();
        long unixMaxFileDescriptorCount = javaInformations.getUnixMaxFileDescriptorCount();
        this.addCell(PdfJavaInformationsReport.getI18nString("nb_fichiers") + ':');
        Phrase fileDescriptorCountPhrase = new Phrase(this.integerFormat.format(unixOpenFileDescriptorCount) + DIVIDE + this.integerFormat.format(unixMaxFileDescriptorCount) + BAR_SEPARATOR, this.cellFont);
        com.lowagie.text.Image fileDescriptorCountImage = com.lowagie.text.Image.getInstance((Image)Bar.toBar(javaInformations.getUnixOpenFileDescriptorPercentage()), null);
        fileDescriptorCountImage.scalePercent(50.0f);
        fileDescriptorCountPhrase.add((Object)new Chunk(fileDescriptorCountImage, 0.0f, 0.0f));
        this.currentTable.addCell(fileDescriptorCountPhrase);
    }

    private void writeDatabaseVersionAndDataSourceDetails(JavaInformations javaInformations) {
        if (!this.noDatabase && javaInformations.getDataBaseVersion() != null) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Base_de_donnees") + ':');
            this.addCell(javaInformations.getDataBaseVersion());
        }
        if (javaInformations.getDataSourceDetails() != null) {
            this.addCell(PdfJavaInformationsReport.getI18nString("DataSource_jdbc") + ':');
            this.addCell(javaInformations.getDataSourceDetails());
            this.addCell("");
            Anchor anchor = new Anchor("DataSource reference", PdfDocumentFactory.BLUE_FONT);
            anchor.setName("DataSource reference");
            anchor.setReference("http://commons.apache.org/dbcp/apidocs/org/apache/commons/dbcp/BasicDataSource.html");
            this.currentTable.addCell((Phrase)anchor);
        }
    }

    private void writeTomcatInformations(List<TomcatInformations> tomcatInformationsList) throws BadElementException, IOException {
        for (TomcatInformations tomcatInformations : tomcatInformationsList) {
            if (tomcatInformations.getRequestCount() <= 0) continue;
            this.addCell("Tomcat " + tomcatInformations.getName() + ':');
            int currentThreadsBusy = tomcatInformations.getCurrentThreadsBusy();
            String equal = " = ";
            Phrase phrase = new Phrase(PdfJavaInformationsReport.getI18nString("busyThreads") + " = " + this.integerFormat.format(currentThreadsBusy) + DIVIDE + this.integerFormat.format(tomcatInformations.getMaxThreads()) + BAR_SEPARATOR, this.cellFont);
            com.lowagie.text.Image threadsImage = com.lowagie.text.Image.getInstance((Image)Bar.toBar(100.0 * (double)currentThreadsBusy / (double)tomcatInformations.getMaxThreads()), null);
            threadsImage.scalePercent(50.0f);
            phrase.add((Object)new Chunk(threadsImage, 0.0f, 0.0f));
            phrase.add((Object)new Chunk('\n' + PdfJavaInformationsReport.getI18nString("bytesReceived") + " = " + this.integerFormat.format(tomcatInformations.getBytesReceived()) + '\n' + PdfJavaInformationsReport.getI18nString("bytesSent") + " = " + this.integerFormat.format(tomcatInformations.getBytesSent()) + '\n' + PdfJavaInformationsReport.getI18nString("requestCount") + " = " + this.integerFormat.format(tomcatInformations.getRequestCount()) + '\n' + PdfJavaInformationsReport.getI18nString("errorCount") + " = " + this.integerFormat.format(tomcatInformations.getErrorCount()) + '\n' + PdfJavaInformationsReport.getI18nString("processingTime") + " = " + this.integerFormat.format(tomcatInformations.getProcessingTime()) + '\n' + PdfJavaInformationsReport.getI18nString("maxProcessingTime") + " = " + this.integerFormat.format(tomcatInformations.getMaxTime())));
            this.currentTable.addCell(phrase);
        }
    }

    private void writeMemoryInformations(MemoryInformations memoryInformations) throws BadElementException, IOException {
        this.addCell(memoryInformations.getMemoryDetails().replace(" Mo", ' ' + PdfJavaInformationsReport.getI18nString("Mo")));
        long usedPermGen = memoryInformations.getUsedPermGen();
        if (usedPermGen > 0L) {
            long maxPermGen = memoryInformations.getMaxPermGen();
            this.addCell(PdfJavaInformationsReport.getI18nString("Memoire_Perm_Gen") + ':');
            if (maxPermGen > 0L) {
                Phrase permGenPhrase = new Phrase(this.integerFormat.format(usedPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo") + DIVIDE + this.integerFormat.format(maxPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo") + BAR_SEPARATOR, this.cellFont);
                com.lowagie.text.Image permGenImage = com.lowagie.text.Image.getInstance((Image)Bar.toBar(memoryInformations.getUsedPermGenPercentage()), null);
                permGenImage.scalePercent(50.0f);
                permGenPhrase.add((Object)new Chunk(permGenImage, 0.0f, 0.0f));
                this.currentTable.addCell(permGenPhrase);
            } else {
                this.addCell(this.integerFormat.format(usedPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo"));
            }
        }
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }

    static final class Bar {
        private static final double MIN_VALUE = 0.0;
        private static final double MAX_VALUE = 100.0;
        private static final int PARTIAL_BLOCKS = 5;
        private static final int FULL_BLOCKS = 10;
        private static final double UNIT_SIZE = 2.0;
        private final BufferedImage image = new BufferedImage(106, 10, 1);
        private final Graphics graphics = this.image.getGraphics();
        private int x;

        private Bar() {
        }

        static BufferedImage toBar(double percentValue) throws IOException {
            Bar bar = new Bar();
            bar.draw(percentValue);
            bar.graphics.dispose();
            return bar.image;
        }

        private void draw(double percentValue) throws IOException {
            int emptyBlocks;
            assert (this.x == 0);
            double myPercent = Math.max(Math.min(percentValue, 100.0), 0.0);
            int fullBlockCount = (int)Math.floor(myPercent / 10.0);
            int partialBlockIndex = (int)Math.floor((myPercent - (double)fullBlockCount * 2.0 * 5.0) / 2.0);
            this.addImage(Bar.getBarImage(fullBlockCount > 0 || partialBlockIndex > 0 ? "a" : "a0"));
            BufferedImage fullBody = Bar.getBarImage(String.valueOf(5));
            for (int i = 0; i < fullBlockCount; ++i) {
                this.addImage(fullBody);
            }
            if (partialBlockIndex > 0) {
                BufferedImage partialBody = Bar.getBarImage(String.valueOf(partialBlockIndex));
                this.addImage(partialBody);
            }
            if ((emptyBlocks = 10 - fullBlockCount - (partialBlockIndex > 0 ? 1 : 0)) > 0) {
                BufferedImage emptyBody = Bar.getBarImage(String.valueOf(0));
                for (int i = 0; i < emptyBlocks; ++i) {
                    this.addImage(emptyBody);
                }
            }
            this.addImage(Bar.getBarImage(fullBlockCount == 10 ? "b" : "b0"));
        }

        private void addImage(BufferedImage img) {
            this.graphics.drawImage(img, this.x, 0, null);
            this.x += img.getWidth();
        }

        private static BufferedImage getBarImage(String key) throws IOException {
            return ImageIO.read(Bar.class.getResource(Parameters.getResourcePath("bar/rb_" + key + ".gif")));
        }
    }
}

