/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.CompressionServletResponseWrapper;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HtmlController;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MBeans;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfController;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.ThreadInformations;
import net.bull.javamelody.TransportFormat;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MonitoringController {
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;
    private String messageForReport;
    private String anchorNameForRedirect;

    MonitoringController(Collector collector, CollectorServer collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String executeActionIfNeeded(HttpServletRequest httpRequest) throws IOException {
        assert (httpRequest != null);
        String actionParameter = httpRequest.getParameter("action");
        if (actionParameter != null) {
            String string;
            try {
                I18N.bindLocale(httpRequest.getLocale());
                Action action = Action.valueOfIgnoreCase(actionParameter);
                if (action != Action.CLEAR_COUNTER) {
                    Action.checkSystemActionsEnabled();
                }
                String counterName = httpRequest.getParameter("counter");
                String sessionId = httpRequest.getParameter("sessionId");
                String threadId = httpRequest.getParameter("threadId");
                String jobId = httpRequest.getParameter("jobId");
                this.messageForReport = action.execute(this.collector, counterName, sessionId, threadId, jobId);
                this.anchorNameForRedirect = action.getContextName(counterName);
                string = this.messageForReport;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                I18N.unbindLocale();
                throw throwable;
            }
            I18N.unbindLocale();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReport(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        assert (httpRequest != null);
        assert (httpResponse != null);
        assert (javaInformationsList != null);
        String resource = httpRequest.getParameter("resource");
        if (resource != null) {
            this.doResource(httpResponse, resource);
            return;
        }
        MonitoringController.noCache(httpResponse);
        try {
            I18N.bindLocale(httpRequest.getLocale());
            String part = httpRequest.getParameter("part");
            String graph = httpRequest.getParameter("graph");
            if (part == null && graph != null) {
                Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
                this.doGraph(httpRequest, httpResponse, range, graph);
            } else if ("lastValue".equalsIgnoreCase(part)) {
                this.doLastValue(httpResponse, graph);
            } else if ("web.xml".equalsIgnoreCase(part)) {
                this.doWebXml(httpResponse);
            } else if ("pom.xml".equalsIgnoreCase(part)) {
                this.doPomXml(httpResponse);
            } else if (httpRequest.getParameter("jmxValue") != null) {
                Action.checkSystemActionsEnabled();
                this.doJmxValue(httpResponse, httpRequest.getParameter("jmxValue"));
            } else {
                this.doReportCore(httpRequest, httpResponse, javaInformationsList);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            I18N.unbindLocale();
            throw throwable;
        }
        I18N.unbindLocale();
    }

    private void doReportCore(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        String format = httpRequest.getParameter("format");
        if (format == null || "html".equalsIgnoreCase(format) || "htmlbody".equalsIgnoreCase(format)) {
            this.doCompressedHtml(httpRequest, httpResponse, javaInformationsList);
        } else if ("pdf".equalsIgnoreCase(format)) {
            PdfController pdfController = new PdfController(this.collector, this.collectorServer);
            pdfController.doPdf(httpRequest, httpResponse, javaInformationsList);
        } else {
            this.doCompressedSerializable(httpRequest, httpResponse, javaInformationsList);
        }
    }

    static void noCache(HttpServletResponse httpResponse) {
        httpResponse.addHeader("Cache-Control", "no-cache");
        httpResponse.addHeader("Pragma", "no-cache");
        httpResponse.addHeader("Expires", "-1");
    }

    void addPdfContentTypeAndDisposition(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        new PdfController(this.collector, this.collectorServer).addPdfContentTypeAndDisposition(httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        block3: {
            HtmlController htmlController = new HtmlController(this.collector, this.collectorServer, this.messageForReport, this.anchorNameForRedirect);
            if (MonitoringController.isCompressionSupported(httpRequest) && !(httpResponse instanceof CompressionServletResponseWrapper)) {
                CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
                try {
                    htmlController.doHtml(httpRequest, (HttpServletResponse)wrappedResponse, javaInformationsList);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    wrappedResponse.finishResponse();
                    throw throwable;
                }
                wrappedResponse.finishResponse();
                {
                    break block3;
                }
            }
            htmlController.doHtml(httpRequest, httpResponse, javaInformationsList);
        }
    }

    void writeHtmlToLastShutdownFile() {
        new HtmlController(this.collector, this.collectorServer, this.messageForReport, this.anchorNameForRedirect).writeHtmlToLastShutdownFile();
    }

    static BufferedWriter getWriter(HttpServletResponse httpResponse) throws IOException {
        return HtmlController.getWriter(httpResponse);
    }

    private void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        Serializable serializable;
        try {
            serializable = this.createSerializable(httpRequest, javaInformationsList);
        }
        catch (Exception e) {
            serializable = e;
        }
        this.doCompressedSerializable(httpRequest, httpResponse, serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Serializable serializable) throws IOException {
        block3: {
            if (MonitoringController.isCompressionSupported(httpRequest) && !(httpResponse instanceof CompressionServletResponseWrapper)) {
                CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 51200);
                try {
                    this.doSerializable(httpRequest, (HttpServletResponse)wrappedResponse, serializable);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    wrappedResponse.finishResponse();
                    throw throwable;
                }
                wrappedResponse.finishResponse();
                {
                    break block3;
                }
            }
            this.doSerializable(httpRequest, httpResponse, serializable);
        }
    }

    private void doSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Serializable serializable) throws IOException {
        String format = httpRequest.getParameter("format");
        TransportFormat transportFormat = TransportFormat.valueOfIgnoreCase(format);
        httpResponse.setContentType(transportFormat.getMimeType());
        String fileName = "JavaMelody_" + this.collector.getApplication().replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + '.' + transportFormat.getCode();
        httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
        transportFormat.writeSerializableTo(serializable, (OutputStream)httpResponse.getOutputStream());
    }

    private Serializable createSerializable(HttpServletRequest httpRequest, List<JavaInformations> javaInformationsList) throws Exception {
        String part = httpRequest.getParameter("part");
        if ("heaphisto".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return VirtualMachine.createHeapHistogram();
        }
        if ("sessions".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            String sessionId = httpRequest.getParameter("sessionId");
            if (sessionId == null) {
                return new ArrayList<SessionInformations>(SessionListener.getAllSessionsInformations());
            }
            return SessionListener.getSessionInformationsBySessionId(sessionId);
        }
        if ("processes".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<ProcessInformations>(ProcessInformations.buildProcessInformations());
        }
        if ("database".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            int requestIndex = DatabaseInformations.parseRequestIndex(httpRequest.getParameter("request"));
            return new DatabaseInformations(requestIndex);
        }
        if ("connections".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<ConnectionInformations>(JdbcWrapper.getConnectionInformationsList());
        }
        if ("threads".equalsIgnoreCase(part)) {
            return new ArrayList<ThreadInformations>(javaInformationsList.get(0).getThreadInformationsList());
        }
        return this.createDefaultSerializable(javaInformationsList);
    }

    Serializable createDefaultSerializable(List<JavaInformations> javaInformationsList) {
        List<Counter> counters = this.collector.getCounters();
        ArrayList<Object> serialized = new ArrayList<Object>(counters.size() + javaInformationsList.size());
        for (Counter counter : counters) {
            serialized.add(counter.clone());
        }
        serialized.addAll(javaInformationsList);
        if (this.messageForReport != null) {
            serialized.add(this.messageForReport);
        }
        return serialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResource(HttpServletResponse httpResponse, String resource) throws IOException {
        httpResponse.addHeader("Cache-Control", "max-age=3600");
        ServletOutputStream out = httpResponse.getOutputStream();
        String localResource = Parameters.getResourcePath(resource.replace("..", ""));
        if (localResource.endsWith(".css")) {
            httpResponse.setContentType("text/css");
        } else {
            String mimeType = Parameters.getServletContext().getMimeType(localResource);
            if (mimeType != null) {
                httpResponse.setContentType(mimeType);
            }
        }
        BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(localResource));
        try {
            TransportFormat.pump(in, (OutputStream)out);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    private void doGraph(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Range range, String graphName) throws IOException {
        int width = Math.min(Integer.parseInt(httpRequest.getParameter("width")), 1600);
        int height = Math.min(Integer.parseInt(httpRequest.getParameter("height")), 1600);
        JRobin jrobin = this.collector.getJRobin(graphName);
        if (jrobin != null) {
            byte[] img = jrobin.graph(range, width, height);
            httpResponse.setContentType("image/png");
            httpResponse.setContentLength(img.length);
            String fileName = graphName + ".png";
            httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
            httpResponse.getOutputStream().write(img);
            httpResponse.flushBuffer();
        }
    }

    private void doLastValue(HttpServletResponse httpResponse, String graphName) throws IOException {
        httpResponse.setContentType("text/plain");
        boolean first = true;
        for (String graph : graphName.split(",")) {
            JRobin jrobin = this.collector.getJRobin(graph);
            double lastValue = jrobin == null ? -1.0 : jrobin.getLastValue();
            if (first) {
                first = false;
            } else {
                httpResponse.getWriter().write(",");
            }
            httpResponse.getWriter().write(String.valueOf(lastValue));
        }
        httpResponse.flushBuffer();
    }

    private void doJmxValue(HttpServletResponse httpResponse, String jmxValueParameter) throws IOException {
        httpResponse.setContentType("text/plain");
        httpResponse.getWriter().write(MBeans.getConvertedAttributes(jmxValueParameter));
        httpResponse.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWebXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType("application/xml");
        httpResponse.addHeader("Content-Disposition", "inline;filename=web.xml");
        InputStream in = MonitoringController.getWebXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPomXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType("application/xml");
        httpResponse.addHeader("Content-Disposition", "inline;filename=pom.xml");
        InputStream in = MonitoringController.getPomXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    private static InputStream getWebXmlAsStream() {
        InputStream webXml = Parameters.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
        if (webXml == null) {
            return null;
        }
        return new BufferedInputStream(webXml);
    }

    private static InputStream getPomXmlAsStream() {
        Set mavenDir = Parameters.getServletContext().getResourcePaths("/META-INF/maven/");
        if (mavenDir == null || mavenDir.isEmpty()) {
            return null;
        }
        Set groupDir = Parameters.getServletContext().getResourcePaths((String)mavenDir.iterator().next());
        if (groupDir == null || groupDir.isEmpty()) {
            return null;
        }
        InputStream pomXml = Parameters.getServletContext().getResourceAsStream(groupDir.iterator().next() + "pom.xml");
        if (pomXml == null) {
            return null;
        }
        return new BufferedInputStream(pomXml);
    }

    static boolean isCompressionSupported(HttpServletRequest httpRequest) {
        boolean supportCompression = false;
        ArrayList<String> acceptEncodings = Collections.list(httpRequest.getHeaders("Accept-Encoding"));
        for (String name : acceptEncodings) {
            if (!name.contains("gzip")) continue;
            supportCompression = true;
            break;
        }
        return supportCompression;
    }

    static boolean isJavaInformationsNeeded(HttpServletRequest httpRequest) {
        return httpRequest.getParameter("resource") == null && httpRequest.getParameter("graph") == null && (httpRequest.getParameter("part") == null || "currentRequests".equalsIgnoreCase(httpRequest.getParameter("part")) || "threads".equalsIgnoreCase(httpRequest.getParameter("part")));
    }

    static {
        boolean webXmlExists = false;
        boolean pomXmlExists = false;
        try {
            InputStream pomXmlAsStream;
            InputStream webXmlAsStream = MonitoringController.getWebXmlAsStream();
            if (webXmlAsStream != null) {
                webXmlAsStream.close();
                webXmlExists = true;
            }
            if ((pomXmlAsStream = MonitoringController.getPomXmlAsStream()) != null) {
                pomXmlAsStream.close();
                pomXmlExists = true;
            }
        }
        catch (IOException e) {
            LOG.warn(e.toString(), e);
        }
        JavaInformations.setWebXmlExistsAndPomXmlExists(webXmlExists, pomXmlExists);
    }
}

