/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.bull.javamelody.HtmlCoreReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.MBeans;
import net.bull.javamelody.PID;

class HtmlMBeansReport {
    private static final boolean PDF_ENABLED = HtmlCoreReport.isPdfEnabled();
    private static final String BR = "<br/>";
    private MBeans mbeans;
    private final Writer writer;
    private final String pid = PID.getPID();
    private int sequence;

    HtmlMBeansReport(Writer writer) {
        assert (writer != null);
        this.writer = writer;
        this.setMBeans(new MBeans());
    }

    void toHtml() throws IOException, JMException {
        this.writeLinks();
        this.writeln(BR);
        this.writeln("<img src='?resource=mbeans.png' width='24' height='24' alt='#MBeans#' />&nbsp;");
        this.writeln("<b>#MBeans#</b>");
        this.writeTree();
    }

    void writeTree() throws IOException, JMException {
        this.writeTreeForCurrentMBeans();
        MBeanServer plateformMBeanServer = MBeans.getPlatformMBeanServer();
        for (MBeanServer mbeanServer : MBeans.getMBeanServers()) {
            if (mbeanServer == plateformMBeanServer) continue;
            this.setMBeans(new MBeans(mbeanServer));
            this.writeln(BR);
            this.writer.write("<b>" + HtmlMBeansReport.htmlEncode(mbeanServer.getDefaultDomain()) + "</b>");
            this.writeTreeForCurrentMBeans();
        }
    }

    private void writeTreeForCurrentMBeans() throws IOException, JMException {
        this.writeln("<div style='margin-left: 20px'>");
        Map<String, Map<String, List<ObjectName>>> mapObjectNamesByDomainAndFirstProperty = this.mbeans.getMapObjectNamesByDomainAndFirstProperty();
        for (Map.Entry<String, Map<String, List<ObjectName>>> entryObjectNamesByDomainAndFirstProperty : mapObjectNamesByDomainAndFirstProperty.entrySet()) {
            String domain = entryObjectNamesByDomainAndFirstProperty.getKey();
            String domainId = this.getNextId();
            this.write(BR);
            this.writeShowHideLink(domainId, HtmlMBeansReport.htmlEncode(domain));
            this.writeln("<div id='" + domainId + "' style='display: none; margin-left: 20px;'><div>");
            Map<String, List<ObjectName>> mapObjectNamesByFirstProperty = entryObjectNamesByDomainAndFirstProperty.getValue();
            boolean firstInDomain = true;
            for (Map.Entry<String, List<ObjectName>> entryObjectNamesByFirstProperty : mapObjectNamesByFirstProperty.entrySet()) {
                String firstProperty = entryObjectNamesByFirstProperty.getKey();
                String firstPropertyId = this.getNextId();
                if (firstInDomain) {
                    firstInDomain = false;
                } else {
                    this.write(BR);
                }
                this.writeShowHideLink(firstPropertyId, HtmlMBeansReport.htmlEncode(firstProperty));
                this.writeln("<div id='" + firstPropertyId + "' style='display: none; margin-left: 20px;'><div>");
                List<ObjectName> objectNames = entryObjectNamesByFirstProperty.getValue();
                boolean firstMBean = true;
                for (ObjectName name : objectNames) {
                    if (firstMBean) {
                        firstMBean = false;
                    } else {
                        this.write(BR);
                    }
                    String mbean = name.toString();
                    String mbeanId = this.getNextId();
                    int indexOfComma = mbean.indexOf(44);
                    if (indexOfComma != -1) {
                        mbean = mbean.substring(indexOfComma + 1);
                        this.writeShowHideLink(mbeanId, HtmlMBeansReport.htmlEncode(mbean));
                        this.writeln("<div id='" + mbeanId + "' style='display: none; margin-left: 20px;'>");
                        this.writeAttributes(name);
                        this.writeln("</div>");
                        continue;
                    }
                    this.writeAttributes(name);
                }
                this.writeln("</div></div>");
            }
            this.writeln("</div></div>");
        }
        this.writeln("</div>");
    }

    private String getNextId() {
        return 'x' + this.pid + '_' + this.sequence++;
    }

    private void writeAttributes(ObjectName name) throws JMException, IOException {
        MBeanInfo mbeanInfo = this.mbeans.getMBeanInfo(name);
        MBeanAttributeInfo[] attributeInfos = mbeanInfo.getAttributes();
        Map<String, Object> attributes = this.mbeans.getAttributes(name, attributeInfos);
        String description = this.mbeans.formatMBeansDescription(mbeanInfo.getDescription());
        if (description != null || !attributes.isEmpty()) {
            this.writeln("<table border='0' cellspacing='0' cellpadding='3' summary=''>");
            if (description != null) {
                this.write("<tr><td colspan='3'>(");
                this.writer.write(HtmlMBeansReport.htmlEncode(description));
                this.write(")</td></tr>");
            }
            for (Map.Entry<String, Object> entryAttributes : attributes.entrySet()) {
                String attributeName = entryAttributes.getKey();
                Object attributeValue = entryAttributes.getValue();
                this.writeAttribute(name, attributeName, attributeValue, attributeInfos);
            }
            this.writeln("</table>");
        }
    }

    private void writeAttribute(ObjectName name, String attributeName, Object attributeValue, MBeanAttributeInfo[] attributeInfos) throws IOException {
        this.write("<tr valign='top'><td>");
        this.writer.write("<a href='?jmxValue=" + name.toString().replace(" ", "%20").replace("'", "%27") + '.' + attributeName + "' ");
        this.writeln("title=\"#Lien_valeur_mbeans#\">-</a>&nbsp;");
        this.writer.write(HtmlMBeansReport.htmlEncode(attributeName));
        this.write("</td><td>");
        this.writer.write(HtmlMBeansReport.htmlEncode(this.mbeans.formatAttributeValue(attributeValue)));
        this.write("</td><td>");
        String attributeDescription = this.mbeans.getAttributeDescription(attributeName, attributeInfos);
        if (attributeDescription != null && !attributeDescription.equals(attributeName)) {
            this.write("(");
            this.writer.write(HtmlMBeansReport.htmlEncode(attributeDescription));
            this.write(")");
        } else {
            this.write("nbsp;");
        }
        this.write("</td></tr>");
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=mbeans'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (PDF_ENABLED) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=mbeans&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("</div>");
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writer.write("<a href=\"javascript:showHide('" + idToShow + "');\"><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private void setMBeans(MBeans mBeans) {
        this.mbeans = mBeans;
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, false);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

