/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfDocumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfRuntimeDependenciesReport {
    private final Counter counter;
    private final Document document;
    private final Font warningCellFont = PdfDocumentFactory.WARNING_CELL_FONT;
    private final Font severeCellFont = PdfDocumentFactory.SEVERE_CELL_FONT;
    private final Font normalFont = PdfDocumentFactory.NORMAL_FONT;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private PdfPTable currentTable;
    private List<String> calledBeans;
    private double standardDeviation;

    PdfRuntimeDependenciesReport(Counter counter, Document document) {
        assert (counter != null);
        assert (document != null);
        this.counter = counter;
        this.document = document;
    }

    Map<String, Map<String, Integer>> getRuntimeDependencies() {
        Map<String, Set<CounterRequest>> methodsCalledByCallerBeans = this.getMethodsCalledByCallerBeans();
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
        for (Map.Entry<String, Set<CounterRequest>> entry : methodsCalledByCallerBeans.entrySet()) {
            String callerBean = entry.getKey();
            Set<CounterRequest> childRequests = entry.getValue();
            HashMap<String, Integer> nbMethodsCalledByCalledBean = new HashMap<String, Integer>();
            for (CounterRequest childRequest : childRequests) {
                String calledBean = PdfRuntimeDependenciesReport.getClassNameFromRequest(childRequest);
                if (callerBean.equals(calledBean)) continue;
                Integer nbOfMethodCalls = (Integer)nbMethodsCalledByCalledBean.get(calledBean);
                nbOfMethodCalls = nbOfMethodCalls == null ? Integer.valueOf(1) : Integer.valueOf(nbOfMethodCalls + 1);
                nbMethodsCalledByCalledBean.put(calledBean, nbOfMethodCalls);
            }
            if (nbMethodsCalledByCalledBean.isEmpty()) continue;
            result.put(callerBean, nbMethodsCalledByCalledBean);
        }
        return result;
    }

    private Map<String, Set<CounterRequest>> getMethodsCalledByCallerBeans() {
        assert (this.counter.isBusinessFacadeCounter());
        List<CounterRequest> requests = this.counter.getRequests();
        HashMap<String, CounterRequest> requestsById = new HashMap<String, CounterRequest>();
        for (CounterRequest request : requests) {
            requestsById.put(request.getId(), request);
        }
        HashMap<String, Set<CounterRequest>> methodsCalledByCallerBeans = new HashMap<String, Set<CounterRequest>>();
        for (CounterRequest request : requests) {
            Set<String> childRequestIds = request.getChildRequestsExecutionsByRequestId().keySet();
            if (childRequestIds.isEmpty()) continue;
            String callerBean = PdfRuntimeDependenciesReport.getClassNameFromRequest(request);
            HashSet<CounterRequest> childRequests = (HashSet<CounterRequest>)methodsCalledByCallerBeans.get(callerBean);
            if (childRequests == null) {
                childRequests = new HashSet<CounterRequest>();
                methodsCalledByCallerBeans.put(callerBean, childRequests);
            }
            for (String childRequestId : childRequestIds) {
                CounterRequest childRequest;
                if (!this.counter.isRequestIdFromThisCounter(childRequestId) || (childRequest = (CounterRequest)requestsById.get(childRequestId)) == null) continue;
                childRequests.add(childRequest);
            }
        }
        return methodsCalledByCallerBeans;
    }

    private static String getClassNameFromRequest(CounterRequest request) {
        int lastIndexOf = request.getName().lastIndexOf(46);
        if (lastIndexOf != -1) {
            return request.getName().substring(0, lastIndexOf);
        }
        return request.getName();
    }

    private static double getStandardDeviation(Map<String, Map<String, Integer>> runtimeDependencies) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int sum = 0;
        for (Map<String, Integer> beanDependencies : runtimeDependencies.values()) {
            for (Integer value : beanDependencies.values()) {
                values.add(value);
                sum += value.intValue();
            }
        }
        int mean = sum / values.size();
        int square = 0;
        for (Integer value : values) {
            int diff = value - mean;
            square += diff * diff;
        }
        return Math.sqrt((double)square / (double)values.size());
    }

    private List<String> getCalledBeans(Map<String, Map<String, Integer>> runtimeDependencies) {
        HashSet<String> calledBeansSet = new HashSet<String>();
        for (Map<String, Integer> values : runtimeDependencies.values()) {
            calledBeansSet.addAll(values.keySet());
        }
        ArrayList<String> result = new ArrayList<String>(calledBeansSet);
        Collections.sort(result);
        return result;
    }

    void toPdf() throws DocumentException {
        Map<String, Map<String, Integer>> runtimeDependencies = this.getRuntimeDependencies();
        if (runtimeDependencies.isEmpty()) {
            this.document.add((Element)new Phrase(PdfRuntimeDependenciesReport.getI18nString("Aucune_dependance"), this.normalFont));
            return;
        }
        this.document.add((Element)new Phrase(PdfRuntimeDependenciesReport.getI18nString("runtime_dependencies_desc"), this.normalFont));
        this.standardDeviation = PdfRuntimeDependenciesReport.getStandardDeviation(runtimeDependencies);
        this.calledBeans = this.getCalledBeans(runtimeDependencies);
        this.writeHeader();
        ArrayList<String> callerBeans = new ArrayList<String>(runtimeDependencies.keySet());
        Collections.sort(callerBeans);
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (String callerBean : callerBeans) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            Map<String, Integer> beanDependencies = runtimeDependencies.get(callerBean);
            this.writeBeanDependencies(callerBean, beanDependencies);
        }
        this.document.add((Element)this.currentTable);
    }

    private void writeBeanDependencies(String callerBean, Map<String, Integer> beanDependencies) {
        this.getDefaultCell().setHorizontalAlignment(0);
        this.addCell(callerBean, this.cellFont);
        this.getDefaultCell().setHorizontalAlignment(2);
        for (String calledBean : this.calledBeans) {
            Integer dependency = beanDependencies.get(calledBean);
            if (dependency == null) {
                this.addCell("", this.cellFont);
                continue;
            }
            String s = dependency.toString();
            if ((double)dependency.intValue() > this.standardDeviation * 2.0) {
                this.addCell(s, this.severeCellFont);
                continue;
            }
            if ((double)dependency.intValue() > this.standardDeviation) {
                this.addCell(s, this.warningCellFont);
                continue;
            }
            this.addCell(s, this.cellFont);
        }
    }

    private void writeHeader() throws DocumentException {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Beans");
        headers.addAll(this.calledBeans);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 4;
        PdfPTable table = new PdfPTable(headers.size());
        table.setWidthPercentage(100.0f);
        table.setWidths(relativeWidths);
        table.setHeaderRows(1);
        PdfPCell defaultCell = table.getDefaultCell();
        defaultCell.setGrayFill(0.9f);
        defaultCell.setHorizontalAlignment(1);
        defaultCell.setVerticalAlignment(5);
        defaultCell.setPaddingLeft(0.0f);
        defaultCell.setPaddingRight(0.0f);
        for (String header : headers) {
            table.addCell(new Phrase(header, PdfDocumentFactory.BOLD_CELL_FONT));
            defaultCell.setRotation(90);
        }
        defaultCell.setRotation(0);
        defaultCell.setPaddingLeft(2.0f);
        defaultCell.setPaddingRight(2.0f);
        this.currentTable = table;
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string, Font font) {
        this.currentTable.addCell(new Phrase(string, font));
    }
}

