/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Mailer {
    private final String jndiName;
    private Session session;
    private InternetAddress fromAddress;

    Mailer(String jndiName) {
        assert (jndiName != null);
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() throws NamingException {
        if (this.session == null) {
            Mailer mailer = this;
            synchronized (mailer) {
                InitialContext ctx = new InitialContext();
                try {
                    this.session = (Session)ctx.lookup(this.jndiName);
                }
                catch (ClassCastException e) {
                    this.session = Session.getInstance((Properties)this.getPropertiesFromSession(ctx.lookup(this.jndiName)));
                }
                ctx.close();
            }
            this.fromAddress = InternetAddress.getLocalAddress((Session)this.session);
        }
        return this.session;
    }

    void setSession(Session session) {
        this.session = session;
        this.fromAddress = InternetAddress.getLocalAddress((Session)session);
    }

    private Properties getPropertiesFromSession(Object jndiSession) {
        try {
            Method getPropertiesMethod = jndiSession.getClass().getMethod("getProperties", null);
            return (Properties)getPropertiesMethod.invoke(jndiSession, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(String toAddress, String subject, String message, List<File> attachments, boolean highPriority) throws NamingException, MessagingException {
        block10: {
            assert (toAddress != null);
            assert (subject != null);
            assert (message != null);
            InternetAddress[] toAddresses = InternetAddress.parse((String)toAddress, (boolean)false);
            MimeMessage msg = new MimeMessage(this.getSession());
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.setFrom((Address)this.fromAddress);
            if (highPriority) {
                msg.setHeader("X-Priority", "1");
                msg.setHeader("x-msmail-priority", "high");
            }
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setText(message);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)mbp);
            if (attachments != null && !attachments.isEmpty()) {
                for (File attachment : attachments) {
                    FileDataSource source = new FileDataSource(attachment);
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName(attachment.getName());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
            }
            msg.setContent((Multipart)multipart);
            String protocol = this.session.getProperty("mail.transport.protocol");
            if (protocol == null) {
                protocol = "smtp";
            }
            if (Boolean.parseBoolean(this.session.getProperty("mail." + protocol + ".auth"))) {
                Transport tr = this.session.getTransport(protocol);
                try {
                    tr.connect(this.session.getProperty("mail." + protocol + ".user"), this.session.getProperty("mail." + protocol + ".password"));
                    msg.saveChanges();
                    tr.sendMessage((Message)msg, msg.getAllRecipients());
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    tr.close();
                    throw throwable;
                }
                tr.close();
                {
                    break block10;
                }
            }
            Transport.send((Message)msg);
        }
    }
}

