/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlThreadInformationsReport {
    private final List<ThreadInformations> threadInformationsList;
    private final Writer writer;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean stackTraceEnabled;
    private final boolean cpuTimeEnabled;
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();

    HtmlThreadInformationsReport(List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, Writer writer) {
        assert (threadInformationsList != null);
        assert (writer != null);
        this.threadInformationsList = threadInformationsList;
        this.writer = writer;
        this.stackTraceEnabled = stackTraceEnabled;
        this.cpuTimeEnabled = !threadInformationsList.isEmpty() && threadInformationsList.get(0).getCpuTimeMillis() != -1L;
    }

    void toHtml() throws IOException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Threads#'>");
        this.write("<thead><tr><th>#Thread#</th>");
        this.write("<th>#Demon#</th><th class='sorttable_numeric'>#Priorite#</th><th>#Etat#</th>");
        if (this.stackTraceEnabled) {
            this.write("<th>#Methode_executee#</th>");
        }
        if (this.cpuTimeEnabled) {
            this.write("<th class='sorttable_numeric'>#Temps_cpu#</th><th class='sorttable_numeric'>#Temps_user#</th>");
        }
        if (this.systemActionsEnabled) {
            this.writeln("<th class='noPrint'>#Tuer#</th>");
        }
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (ThreadInformations threadInformations : this.threadInformationsList) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeThreadInformations(threadInformations);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
        this.writeln("<div align='right'>");
        this.writeln("#Temps_threads#");
        this.writeln("</div>");
    }

    void writeDeadlocks() throws IOException {
        ArrayList<ThreadInformations> deadlockedThreads = new ArrayList<ThreadInformations>();
        for (ThreadInformations thread : this.threadInformationsList) {
            if (!thread.isDeadlocked()) continue;
            deadlockedThreads.add(thread);
        }
        if (!deadlockedThreads.isEmpty()) {
            this.write("<div class='severe'>#Threads_deadlocks#");
            String separator = " ";
            for (ThreadInformations thread : deadlockedThreads) {
                this.writer.write(separator);
                this.writer.write(HtmlThreadInformationsReport.htmlEncode(thread.getName()));
                separator = ", ";
            }
            this.write("</div>");
        }
    }

    private void writeThreadInformations(ThreadInformations threadInformations) throws IOException {
        this.write("<td>");
        this.writeThreadWithStackTrace(threadInformations);
        this.write("</td> <td align='center'>");
        if (threadInformations.isDaemon()) {
            this.write("#oui#");
        } else {
            this.write("#non#");
        }
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(threadInformations.getPriority()));
        this.write("</td> <td>");
        this.write("<img src='?resource=bullets/");
        this.write(HtmlThreadInformationsReport.getStateIcon(threadInformations));
        this.write("' alt='");
        this.write(String.valueOf((Object)threadInformations.getState()));
        this.write("'/>");
        this.write(String.valueOf((Object)threadInformations.getState()));
        if (this.stackTraceEnabled) {
            this.write("</td> <td>");
            this.writeExecutedMethod(threadInformations);
        }
        if (this.cpuTimeEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(threadInformations.getCpuTimeMillis()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(threadInformations.getUserTimeMillis()));
        }
        if (this.systemActionsEnabled) {
            this.write("</td> <td align='center' class='noPrint'>");
            this.write("<a href='?action=kill_thread&amp;threadId=");
            this.write(threadInformations.getGlobalThreadId());
            String confirmKillThread = I18N.javascriptEncode(I18N.getFormattedString("confirm_kill_thread", threadInformations.getName()));
            this.writer.write("' onclick=\"javascript:return confirm('" + confirmKillThread + "');\">");
            String title = HtmlThreadInformationsReport.htmlEncode(I18N.getFormattedString("kill_thread", threadInformations.getName()));
            this.writer.write("<img width='16' height='16' src='?resource=stop.png' alt='" + title + "' title='" + title + "' />");
            this.write("</a>");
        }
        this.write("</td>");
    }

    static String getStateIcon(ThreadInformations threadInformations) {
        switch (threadInformations.getState()) {
            case RUNNABLE: {
                return "green.png";
            }
            case WAITING: {
                return "yellow.png";
            }
            case TIMED_WAITING: {
                if (HtmlThreadInformationsReport.isSleeping(threadInformations)) {
                    return "blue.png";
                }
                return "yellow.png";
            }
            case BLOCKED: {
                return "red.png";
            }
            case NEW: 
            case TERMINATED: {
                return "gray.png";
            }
        }
        throw new IllegalArgumentException("state inconnu" + (Object)((Object)threadInformations.getState()));
    }

    private static boolean isSleeping(ThreadInformations threadInformations) {
        List<StackTraceElement> stackTrace = threadInformations.getStackTrace();
        return stackTrace != null && !stackTrace.isEmpty() && "sleep".equals(stackTrace.get(0).getMethodName()) && "java.lang.Thread".equals(stackTrace.get(0).getClassName());
    }

    void writeThreadWithStackTrace(ThreadInformations threadInformations) throws IOException {
        List<StackTraceElement> stackTrace = threadInformations.getStackTrace();
        String encodedName = HtmlThreadInformationsReport.htmlEncode(threadInformations.getName());
        if (stackTrace != null && !stackTrace.isEmpty()) {
            this.writeln("<a class='tooltip'>");
            this.writeln("<em>");
            this.writer.write(encodedName);
            this.writeln("<br/>");
            for (StackTraceElement stackTraceElement : stackTrace) {
                this.write(HtmlThreadInformationsReport.htmlEncode(stackTraceElement.toString()));
                this.writeln("<br/>");
            }
            this.writeln("</em>");
            this.writer.write(encodedName);
            this.writeln("</a>");
        } else {
            this.writer.write(encodedName);
        }
    }

    void writeExecutedMethod(ThreadInformations threadInformations) throws IOException {
        String executedMethod = threadInformations.getExecutedMethod();
        if (executedMethod != null && executedMethod.length() != 0) {
            this.write(HtmlThreadInformationsReport.htmlEncode(executedMethod));
        } else {
            this.write("&nbsp;");
        }
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

