/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;

class HtmlJndiTreeReport {
    private static final String JNDI_PREFIX = "java:";
    private final Context context;
    private final String path;
    private final Writer writer;

    HtmlJndiTreeReport(Context context, String path, Writer writer) {
        assert (context != null);
        assert (writer != null);
        this.context = context;
        this.path = path != null ? path : (Parameters.getServletContext().getServerInfo().contains("GlassFish") ? "comp" : "");
        this.writer = writer;
    }

    void toHtml() throws IOException, NamingException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeln("<img src='?resource=jndi.png' width='24' height='24' alt='#Arbre_JNDI#' />&nbsp;");
        if (this.path.length() == 0) {
            this.writeln("<b>#Arbre_JNDI#</b>");
        } else {
            this.writer.write("<b>" + I18N.getFormattedString("Arbre_JNDI_pour_contexte", HtmlJndiTreeReport.htmlEncode(this.path)) + "</b>\n");
        }
        this.writeTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTable() throws IOException, NamingException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Arbre_JNDI#'>");
        this.write("<thead><tr><th>#Nom#</th><th>#Type#</th>");
        this.writeln("</tr></thead><tbody>");
        String jndiName = Parameters.getServletContext().getServerInfo().contains("WebLogic") ? JNDI_PREFIX + this.path + '/' : JNDI_PREFIX + this.path;
        NamingEnumeration<Binding> enumeration = this.context.listBindings(jndiName);
        try {
            boolean odd = false;
            while (enumeration.hasMore()) {
                try {
                    Binding binding = enumeration.next();
                    if (odd) {
                        this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
                    } else {
                        this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
                    }
                    odd = !odd;
                    this.writeBinding(binding);
                    this.writeln("</tr>");
                }
                catch (NamingException e) {}
            }
            this.writeln("</tbody></table>");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.context.close();
            throw throwable;
        }
        this.context.close();
    }

    private void writeBinding(Binding binding) throws IOException {
        String name = this.getBindingName(binding);
        this.write("<td>");
        String encodedName = HtmlJndiTreeReport.htmlEncode(name);
        String className = binding.getClassName();
        if (binding.getObject() instanceof Context || "javax.naming.Context".equals(className)) {
            String contextPath = this.path.length() > 0 ? this.path + '/' + name : name;
            this.writer.write("<a href=\"?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(contextPath) + "\">");
            this.writer.write("<img width='16' height='16' src='?resource=folder.png' alt='" + encodedName + "' />&nbsp;");
            this.writer.write(encodedName);
            this.writer.write("</a>");
        } else {
            this.writer.write(encodedName);
        }
        this.write("</td>");
        this.write("<td>");
        this.writer.write(className != null ? HtmlJndiTreeReport.htmlEncode(className) : "&nbsp;");
        this.write("</td>");
    }

    private String getBindingName(Binding binding) {
        String result = binding.getName();
        if (result.startsWith(JNDI_PREFIX)) {
            result = result.substring(JNDI_PREFIX.length());
        }
        if (result.startsWith(this.path)) {
            result = result.substring(this.path.length());
        }
        if (result.length() > 0 && result.charAt(0) == '/') {
            result = result.substring(1);
        }
        return result;
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writer.write("<a href='?#systeminfo'>");
        this.writeln("<img src='?resource=action_home.png' alt='#Page_principale#'/> #Page_principale#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(this.path) + "'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

