/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.bull.javamelody.TransportFormat;

class GWTRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] originalPayload;
    private String gwtRpcMethodName;
    private ServletInputStream inputStream;
    private BufferedReader reader;

    GWTRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransportFormat.pump((InputStream)request.getInputStream(), byteArrayOutputStream);
        this.originalPayload = byteArrayOutputStream.toByteArray();
        String payload = new String(this.originalPayload);
        this.parseGwtRpcMethodName(payload);
    }

    private void parseGwtRpcMethodName(String payload) {
        String[] split = payload.split("\\|");
        if (split[6].length() > 0) {
            this.gwtRpcMethodName = split[6];
        }
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            String characterEncoding = this.getCharacterEncoding();
            this.reader = characterEncoding == null ? new BufferedReader(new InputStreamReader((InputStream)this.getInputStream())) : new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), characterEncoding));
        }
        return this.reader;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.originalPayload);
            this.inputStream = new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }
            };
        }
        return this.inputStream;
    }

    String getGwtRpcMethodName() {
        return this.gwtRpcMethodName;
    }
}

