/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterResponseStream;
import net.bull.javamelody.Parameters;

class CounterStorage {
    private final Counter counter;

    CounterStorage(Counter counter) {
        assert (counter != null);
        this.counter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeToFile() throws IOException {
        int n;
        File file = this.getFile();
        if (this.counter.getRequestsCount() == 0 && this.counter.getErrorsCount() == 0 && !file.exists()) {
            return -1;
        }
        File directory = file.getParentFile();
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + directory.getPath());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            CounterResponseStream counterOutput = new CounterResponseStream(new GZIPOutputStream(new BufferedOutputStream(out)));
            ObjectOutputStream output = new ObjectOutputStream((OutputStream)((Object)counterOutput));
            try {
                output.writeObject(this.counter);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                output.close();
                throw throwable;
            }
            output.close();
            n = counterOutput.getDataLength();
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            out.close();
            throw throwable;
        }
        out.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Counter readFromFile() throws IOException {
        Counter counter;
        File file = this.getFile();
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            try {
                ObjectInputStream input = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(in)));
                try {
                    counter = (Counter)input.readObject();
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    input.close();
                    throw throwable;
                }
                input.close();
                Object var8_8 = null;
            }
            catch (ClassNotFoundException e) {
                throw CounterStorage.createIOException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return counter;
    }

    private File getFile() {
        File storageDirectory = Parameters.getStorageDirectory(this.counter.getApplication());
        return new File(storageDirectory, this.counter.getStorageName() + ".ser.gz");
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }
}

